/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import com.intuit.ipp.data.SyncError;
import com.intuit.ipp.data.SyncErrorResponse;
import com.intuit.ipp.serialization.JsonResourceTypeLocator;
import com.intuit.ipp.serialization.SyncErrorDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class SyncErrorResponseDeserializer
extends JsonDeserializer<SyncErrorResponse> {
    private static final String STARTPOSITION = "startPosition";
    private static final String MAXRESULTS = "maxResults";
    private static final String TOTALCOUNT = "totalCount";
    private static final String LATESTUPLOADTIME = "latestUploadTime";

    public SyncErrorResponse deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        JakartaXmlBindAnnotationIntrospector primary = new JakartaXmlBindAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        SyncErrorResponse sr = new SyncErrorResponse();
        Iterator ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (key.equals(STARTPOSITION)) {
                sr.setStartPosition(Integer.valueOf(jn.get(STARTPOSITION).intValue()));
                continue;
            }
            if (key.equals(MAXRESULTS)) {
                sr.setMaxResults(Integer.valueOf(jn.get(MAXRESULTS).intValue()));
                continue;
            }
            if (key.equals(TOTALCOUNT)) {
                sr.setTotalCount(Integer.valueOf(jn.get(TOTALCOUNT).intValue()));
                continue;
            }
            if (key.equals(LATESTUPLOADTIME)) {
                try {
                    sr.setLatestUploadTime(date.parse(jn.get(LATESTUPLOADTIME).textValue()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (JsonResourceTypeLocator.lookupType(key) == null) continue;
            JsonNode jn1 = jn.get(key);
            ArrayList<SyncError> syncErrorlist = new ArrayList<SyncError>();
            if (jn1.isArray()) {
                for (JsonNode jn2 : jn1) {
                    SyncError serror = this.getSyncError(jn2);
                    syncErrorlist.add(serror);
                }
            }
            sr.setSyncError(syncErrorlist);
        }
        return sr;
    }

    private SyncError getSyncError(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("SyncErrorDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(SyncError.class, (JsonDeserializer)new SyncErrorDeserializer());
        mapper.registerModule((Module)simpleModule);
        return (SyncError)mapper.treeToValue((TreeNode)jsonNode, SyncError.class);
    }
}

