/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitResponse;
import com.intuit.ipp.data.TaxRateApplicableOnEnum;
import com.intuit.ipp.data.TaxRateDetails;
import com.intuit.ipp.data.TaxService;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;

public class TaxServiceDeserializer
extends JsonDeserializer<TaxService> {
    private static final String FAULT = "Fault";

    public TaxService deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TaxService taxService = new TaxService();
        JakartaXmlBindAnnotationIntrospector primary = new JakartaXmlBindAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        Iterator ite = jn.fieldNames();
        IntuitResponse qr = new IntuitResponse();
        ArrayList<TaxRateDetails> taxRateDetailsList = new ArrayList<TaxRateDetails>();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (key.equalsIgnoreCase(FAULT)) {
                qr.setFault((Fault)mapper.treeToValue((TreeNode)jn.get(FAULT), Fault.class));
                taxService.setFault((Fault)mapper.treeToValue((TreeNode)jn.get(FAULT), Fault.class));
                continue;
            }
            if (key.equalsIgnoreCase("TaxCode")) {
                taxService.setTaxCode((String)mapper.treeToValue((TreeNode)jn.get(key), String.class));
                continue;
            }
            if (key.equalsIgnoreCase("TaxCodeId")) {
                taxService.setTaxCodeId((String)mapper.treeToValue((TreeNode)jn.get(key), String.class));
                continue;
            }
            if (!key.equalsIgnoreCase("TaxRateDetails")) continue;
            JsonNode jn1 = jn.get(key);
            if (jn1.isArray()) {
                for (JsonNode jn2 : jn1) {
                    TaxRateDetails taxRateDetails = this.getTaxRateDetails(jn2);
                    taxRateDetailsList.add(taxRateDetails);
                }
            }
            taxService.setTaxRateDetails(taxRateDetailsList);
        }
        return taxService;
    }

    private TaxRateDetails getTaxRateDetails(JsonNode jn) throws IOException {
        TaxRateDetails taxRateDetails = new TaxRateDetails();
        ObjectMapper mapper = new ObjectMapper();
        JakartaXmlBindAnnotationIntrospector primary = new JakartaXmlBindAnnotationIntrospector(mapper.getTypeFactory());
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Iterator ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (key.equalsIgnoreCase("TaxRateName")) {
                taxRateDetails.setTaxRateName((String)mapper.treeToValue((TreeNode)jn.get(key), String.class));
                continue;
            }
            if (key.equalsIgnoreCase("RateValue")) {
                taxRateDetails.setRateValue((BigDecimal)mapper.treeToValue((TreeNode)jn.get(key), BigDecimal.class));
                continue;
            }
            if (key.equalsIgnoreCase("TaxAgencyId")) {
                taxRateDetails.setTaxAgencyId((String)mapper.treeToValue((TreeNode)jn.get(key), String.class));
                continue;
            }
            if (key.equalsIgnoreCase("TaxApplicableOn")) {
                taxRateDetails.setTaxApplicableOn((TaxRateApplicableOnEnum)mapper.treeToValue((TreeNode)jn.get(key), TaxRateApplicableOnEnum.class));
                continue;
            }
            if (!key.equalsIgnoreCase("TaxRateId")) continue;
            taxRateDetails.setTaxRateId((String)mapper.treeToValue((TreeNode)jn.get(key), String.class));
        }
        return taxRateDetails;
    }
}

