/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.services;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intuit.ipp.data.WebhooksEvent;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.StringUtils;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;

public class WebhooksService {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String ALGORITHM = "HmacSHA256";

    public boolean verifyPayload(String intuitSignature, String payload) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(this.getVerifierKey().getBytes("UTF-8"), ALGORITHM);
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(secretKey);
            String hash = DatatypeConverter.printBase64Binary((byte[])mac.doFinal(payload.getBytes()));
            return hash.equals(intuitSignature);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("NoSuchAlgorithmException while validating payload", (Throwable)e);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("UnsupportedEncodingException while validating payload", (Throwable)e);
            return false;
        }
        catch (InvalidKeyException e) {
            LOG.error("InvalidKeyException validating payload", (Throwable)e);
            return false;
        }
    }

    public WebhooksEvent getWebhooksEvent(String payload) {
        if (!StringUtils.hasText(payload)) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (WebhooksEvent)mapper.readValue(payload, WebhooksEvent.class);
        }
        catch (JsonParseException e) {
            LOG.error("Error while parsing payload", (Throwable)e);
            return null;
        }
        catch (JsonMappingException e) {
            LOG.error("Error while mapping payload", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error("IO exception while parsing payload", (Throwable)e);
            return null;
        }
    }

    private String getVerifierKey() {
        return Config.getProperty("webhooks.verifier.token");
    }
}

