/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.compression;

import com.intuit.ipp.compression.ICompressor;
import com.intuit.ipp.exception.CompressionException;
import com.intuit.ipp.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;

public class DeflateCompressor
implements ICompressor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final int LENGTH_256 = 256;

    @Override
    public byte[] compress(String data, byte[] uploadFile) throws CompressionException {
        if (!StringUtils.hasText(data)) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        DeflaterOutputStream deflater = null;
        byte[] compressedData = null;
        try {
            baos = new ByteArrayOutputStream();
            deflater = new DeflaterOutputStream(baos);
            ((OutputStream)deflater).write(data.getBytes());
            if (uploadFile != null) {
                ((OutputStream)deflater).write(uploadFile);
            }
            ((OutputStream)deflater).close();
            byte[] byArray = compressedData = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new CompressionException("IOException while compress the data using Deflate compression.", ioe);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to close ByteArrayOutputStream.");
                }
            }
        }
    }

    @Override
    public OutputStream decompress(InputStream in) throws CompressionException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int r;
            InflaterInputStream inflater = new InflaterInputStream(in);
            byte[] bbuf = new byte[256];
            while ((r = ((InputStream)inflater).read(bbuf)) >= 0) {
                baos.write(bbuf, 0, r);
            }
            ByteArrayOutputStream byteArrayOutputStream = baos;
            return byteArrayOutputStream;
        }
        catch (IOException ioe) {
            throw new CompressionException("IOException while decompress the data using Deflate compression.", ioe);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to close ByteArrayOutputStream.");
                }
            }
        }
    }
}

