/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.core;

import com.intuit.ipp.core.ServiceType;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.security.IAuthorizer;
import java.util.List;
import java.util.UUID;

public class Context {
    private IAuthorizer authorizer = null;
    private String appToken = null;
    private String appDBID = null;
    private String realmID = null;
    private ServiceType intuitServiceType = null;
    private String requestID = null;
    private String minorVersion = null;
    private List includeParam = null;
    private Integer customerRequestTimeout = null;
    private String ticket = null;
    private UUID trackingID = null;

    public Context(IAuthorizer authorizer, String appToken, ServiceType platformServiceType, String realmID) throws FMSException {
        this.authorizer = authorizer;
        this.appToken = appToken;
        if (platformServiceType == null) {
            throw new FMSException("Unable to get ServiceType for the given information");
        }
        this.intuitServiceType = platformServiceType;
        this.realmID = realmID;
    }

    public Context(IAuthorizer authorizer, ServiceType platformServiceType, String realmID) throws FMSException {
        this.authorizer = authorizer;
        if (platformServiceType == null) {
            throw new FMSException("Unable to get ServiceType for the given information");
        }
        this.intuitServiceType = platformServiceType;
        this.realmID = realmID;
    }

    public IAuthorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(IAuthorizer authorizer) {
        this.authorizer = authorizer;
    }

    public ServiceType getIntuitServiceType() {
        return this.intuitServiceType;
    }

    public void setIntuitServiceType(ServiceType intuitServiceType) {
        this.intuitServiceType = intuitServiceType;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getAppDBID() {
        return this.appDBID;
    }

    public void setAppDBID(String appDBID) {
        this.appDBID = appDBID;
    }

    public String getRealmID() {
        return this.realmID;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public void setRealmID(String realmID) {
        this.realmID = realmID;
    }

    public void invalidate() {
        this.appToken = null;
        this.appDBID = null;
        this.authorizer = null;
        this.intuitServiceType = null;
        this.realmID = null;
    }

    public String getRequestID() {
        if (this.requestID == null) {
            this.requestID = UUID.randomUUID().toString().replace("-", "");
        }
        return this.requestID;
    }

    public String getTicket() {
        return this.ticket;
    }

    public UUID getTrackingID() {
        return this.trackingID;
    }

    public List getIncludeParam() {
        return this.includeParam;
    }

    public void setRequestID(String requestID) {
        this.requestID = requestID;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public void setTrackingID(UUID trackingID) {
        this.trackingID = trackingID;
    }

    public void setMinorVersion(String minorVersion) {
        this.minorVersion = minorVersion;
    }

    public void setIncludeParam(List includeParam) {
        this.includeParam = includeParam;
    }

    public Integer getCustomerRequestTimeout() {
        return this.customerRequestTimeout;
    }

    public void setCustomerRequestTimeout(Integer customerRequestTimeout) {
        this.customerRequestTimeout = customerRequestTimeout;
    }
}

