/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.compression.CompressorFactory;
import com.intuit.ipp.compression.ICompressor;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.StringUtils;
import org.slf4j.Logger;

public class CompressionInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        LOG.debug("Enter CompressionInterceptor...");
        String serializedData = intuitMessage.getRequestElements().getSerializedData();
        if (StringUtils.hasText(serializedData)) {
            byte[] compressedData = null;
            String compressFormat = Config.getProperty("message.request.compression");
            LOG.info("compression format : " + compressFormat);
            byte[] uploadFile = intuitMessage.getRequestElements().getUploadFile();
            if (StringUtils.hasText(compressFormat)) {
                ICompressor compressor = CompressorFactory.getCompressor(compressFormat);
                compressedData = compressor.compress(serializedData, uploadFile);
            } else if (uploadFile != null) {
                byte[] serializedDateByte = serializedData.getBytes();
                compressedData = new byte[serializedDateByte.length + uploadFile.length];
                System.arraycopy(serializedDateByte, 0, compressedData, 0, serializedDateByte.length);
                System.arraycopy(uploadFile, 0, compressedData, serializedDateByte.length, uploadFile.length);
            } else {
                compressedData = serializedData.getBytes();
            }
            intuitMessage.getRequestElements().setCompressedData(compressedData);
        }
        LOG.debug("Exit CompressionInterceptor.");
    }
}

