/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.query.expr;

import com.intuit.ipp.query.Operation;
import com.intuit.ipp.query.Path;
import com.intuit.ipp.query.expr.Expression;
import com.intuit.ipp.util.MessageUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class EnumPath
extends Path<Enum<?>> {
    public EnumPath(String path, String entity) {
        super(path, entity);
    }

    public Expression<Enum<?>> eq(Enum<?> value) {
        String valueString = "'" + EnumPath.getValue(value) + "'";
        return new Expression(this, Operation.eq, valueString);
    }

    public Expression<Enum<?>> neq(Enum<?> value) {
        String valueString = "'" + EnumPath.getValue(value) + "'";
        return new Expression(this, Operation.neq, valueString);
    }

    public Expression<Enum<?>> lt(Enum<?> value) {
        String valueString = "'" + EnumPath.getValue(value) + "'";
        return new Expression(this, Operation.lt, valueString);
    }

    public Expression<Enum<?>> lte(Enum<?> value) {
        String valueString = "'" + EnumPath.getValue(value) + "'";
        return new Expression(this, Operation.lte, valueString);
    }

    public Expression<Enum<?>> gt(Enum<?> value) {
        String valueString = "'" + EnumPath.getValue(value) + "'";
        return new Expression(this, Operation.gt, valueString);
    }

    public Expression<Enum<?>> gte(Enum<?> value) {
        String valueString = "'" + EnumPath.getValue(value) + "'";
        return new Expression(this, Operation.gte, valueString);
    }

    public Expression<Enum<?>> in(Enum<?>[] value) {
        String listString = "";
        Boolean firstString = true;
        for (Enum<?> v : value) {
            if (firstString.booleanValue()) {
                listString = listString.concat("('").concat(EnumPath.getValue(v)).concat("'");
                firstString = false;
                continue;
            }
            listString = listString.concat(", '").concat(EnumPath.getValue(v)).concat("'");
        }
        listString = listString.concat(")");
        return new Expression(this, Operation.in, listString);
    }

    private static String getValue(Enum<?> value) {
        try {
            String methodName = EnumPath.validateClass(value) ? "value" : "name";
            Method m = value.getClass().getDeclaredMethod(methodName, new Class[0]);
            return (String)m.invoke(value, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return value.toString();
    }

    private static boolean validateClass(Enum<?> value) {
        List<Object> enumList = MessageUtils.getWhitelistedEnums();
        return enumList.contains(value.getClass());
    }
}

