/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intuit.ipp.data.BatchItemRequest;
import com.intuit.ipp.data.CDCQuery;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.exception.SerializationException;
import com.intuit.ipp.serialization.JSONSerializer;
import com.intuit.ipp.util.StringUtils;
import java.io.IOException;
import org.slf4j.Logger;

public class BatchItemRequestSerializer
extends JsonSerializer<BatchItemRequest> {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String BID = "bId";
    private static final String QUERY = "Query";
    private static final String REPORT_QUERY = "ReportQuery";
    private static final String CDC_QUERY = "CDCQuery";
    private static final String OPERATION = "operation";
    private static final String OPTIONS_DATA = "optionsData";

    @Override
    public void serialize(BatchItemRequest batchItemRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (StringUtils.hasText(batchItemRequest.getBId())) {
            jgen.writeFieldName(BID);
            jgen.writeString(batchItemRequest.getBId());
        }
        if (batchItemRequest.getIntuitObject() != null) {
            jgen.writeFieldName(((IntuitEntity)batchItemRequest.getIntuitObject().getValue()).getClass().getSimpleName());
            try {
                jgen.writeNumber(new JSONSerializer().serialize(batchItemRequest.getIntuitObject()));
            }
            catch (SerializationException e) {
                LOG.error("SerializationException while generating Json for IntuitObject in BatchItemRequestSerializer.", e);
                throw new IOException(e);
            }
        }
        if (batchItemRequest.getCDCQuery() != null) {
            jgen.writeFieldName(CDC_QUERY);
            try {
                jgen.writeNumber(this.getCDCQueryJson(batchItemRequest.getCDCQuery()));
            }
            catch (Exception e) {
                LOG.error("SerializationException while generating Json for CDCQuery in BatchItemRequestSerializer.", e);
                throw new IOException(e);
            }
        }
        if (StringUtils.hasText(batchItemRequest.getQuery())) {
            jgen.writeFieldName(QUERY);
            jgen.writeString(batchItemRequest.getQuery());
        }
        if (StringUtils.hasText(batchItemRequest.getReportQuery())) {
            jgen.writeFieldName(REPORT_QUERY);
            jgen.writeString(batchItemRequest.getReportQuery());
        }
        if (batchItemRequest.getOperation() != null) {
            jgen.writeFieldName(OPERATION);
            jgen.writeString(batchItemRequest.getOperation().value());
        }
        if (StringUtils.hasText(batchItemRequest.getOptionsData())) {
            jgen.writeFieldName(OPTIONS_DATA);
            jgen.writeString(batchItemRequest.getOptionsData());
        }
        jgen.writeEndObject();
    }

    private String getCDCQueryJson(CDCQuery cdcQuery) throws SerializationException {
        ObjectMapper mapper = this.getObjectMapper();
        String json = null;
        try {
            json = mapper.writeValueAsString(cdcQuery);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
        return json;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        JacksonAnnotationIntrospector primary = new JacksonAnnotationIntrospector();
        JaxbAnnotationIntrospector secondary = new JaxbAnnotationIntrospector(mapper.getTypeFactory());
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(primary, secondary);
        mapper.setAnnotationIntrospector(pair);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }
}

