/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intuit.ipp.data.BatchItemResponse;
import com.intuit.ipp.data.CDCResponse;
import com.intuit.ipp.data.CustomFieldDefinition;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.data.ObjectFactory;
import com.intuit.ipp.data.QueryResponse;
import com.intuit.ipp.data.Report;
import com.intuit.ipp.serialization.CDCQueryResponseDeserializer;
import com.intuit.ipp.serialization.CustomFieldDefinitionDeserializer;
import com.intuit.ipp.serialization.IntuitResponseDeserializerHelper;
import com.intuit.ipp.serialization.JsonResourceTypeLocator;
import com.intuit.ipp.serialization.QueryResponseDeserializer;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;

public class BatchItemResponseDeserializer
extends JsonDeserializer<BatchItemResponse> {
    private IntuitResponseDeserializerHelper intuitResponseDeserializerHelper = new IntuitResponseDeserializerHelper();
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String FAULT = "Fault";
    private static final String REPORT = "Report";
    private static final String BID = "bId";
    private static final String QUERYRESPONSE = "QueryResponse";
    private static final String CDC_QUERY_RESPONSE = "CDCResponse";
    private ObjectFactory objFactory = new ObjectFactory();

    @Override
    public BatchItemResponse deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(primary, secondary);
        mapper.setAnnotationIntrospector(pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        BatchItemResponse qr = new BatchItemResponse();
        Iterator<String> ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = ite.next();
            if (key.equalsIgnoreCase(FAULT)) {
                qr.setFault(mapper.treeToValue(jn.get(FAULT), Fault.class));
                continue;
            }
            if (key.equalsIgnoreCase(REPORT)) {
                qr.setReport(mapper.treeToValue(jn.get(REPORT), Report.class));
                continue;
            }
            if (key.equalsIgnoreCase(BID)) {
                qr.setBId(jn.get(BID).textValue());
                continue;
            }
            if (key.equals(QUERYRESPONSE)) {
                qr.setQueryResponse(this.getQueryResponse(jn.get(key)));
                continue;
            }
            if (key.equals(CDC_QUERY_RESPONSE)) {
                qr.setCDCResponse(this.getCDCQueryResponse(jn.get(key)));
                continue;
            }
            String entity = key;
            LOG.debug("entity key : " + key);
            if (JsonResourceTypeLocator.lookupType(entity) == null) continue;
            this.registerModulesForCustomFieldDef(mapper);
            Object intuitType = mapper.treeToValue(jn.get(key), JsonResourceTypeLocator.lookupType(entity));
            if (!(intuitType instanceof IntuitEntity)) continue;
            this.intuitResponseDeserializerHelper.updateBigDecimalScale((IntuitEntity)intuitType);
            JAXBElement<IntuitEntity> intuitObject = this.objFactory.createIntuitObject((IntuitEntity)intuitType);
            qr.setIntuitObject(intuitObject);
        }
        return qr;
    }

    private QueryResponse getQueryResponse(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("QueryResponseDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(QueryResponse.class, new QueryResponseDeserializer());
        mapper.registerModule(simpleModule);
        return mapper.treeToValue(jsonNode, QueryResponse.class);
    }

    private CDCResponse getCDCQueryResponse(JsonNode jsonNode) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("CDCQueryResponseDeserializer", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(CDCResponse.class, new CDCQueryResponseDeserializer());
        mapper.registerModule(simpleModule);
        return mapper.treeToValue(jsonNode, CDCResponse.class);
    }

    private void registerModulesForCustomFieldDef(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule("CustomFieldDefinition", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(CustomFieldDefinition.class, new CustomFieldDefinitionDeserializer());
        objectMapper.registerModule(simpleModule);
    }
}

