/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intuit.ipp.data.CustomFieldDefinition;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.data.ObjectFactory;
import com.intuit.ipp.data.QueryResponse;
import com.intuit.ipp.data.RecurringTransaction;
import com.intuit.ipp.serialization.CustomFieldDefinitionDeserializer;
import com.intuit.ipp.serialization.IntuitResponseDeserializerHelper;
import com.intuit.ipp.serialization.JsonResourceTypeLocator;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;

public class QueryResponseDeserializer
extends JsonDeserializer<QueryResponse> {
    private IntuitResponseDeserializerHelper intuitResponseDeserializerHelper = new IntuitResponseDeserializerHelper();
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final String FAULT = "Fault";
    private static final String STARTPOSITION = "startPosition";
    private static final String MAXRESULTS = "maxResults";
    private static final String TOTALCOUNT = "totalCount";
    private static final String RECURRINGTXN = "RecurringTransaction";
    private ObjectFactory objFactory = new ObjectFactory();

    @Override
    public QueryResponse deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(primary, secondary);
        mapper.setAnnotationIntrospector(pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        QueryResponse qr = new QueryResponse();
        Iterator<String> ite = jn.fieldNames();
        while (ite.hasNext()) {
            JsonNode jn1;
            String key = ite.next();
            if (key.equals(FAULT)) {
                qr.setFault(mapper.treeToValue(jn.get(FAULT), Fault.class));
                continue;
            }
            if (key.equals(STARTPOSITION)) {
                qr.setStartPosition(jn.get(STARTPOSITION).intValue());
                continue;
            }
            if (key.equals(MAXRESULTS)) {
                qr.setMaxResults(jn.get(MAXRESULTS).intValue());
                continue;
            }
            if (key.equals(TOTALCOUNT)) {
                qr.setTotalCount(jn.get(TOTALCOUNT).intValue());
                continue;
            }
            if (key.equals(RECURRINGTXN)) {
                if (JsonResourceTypeLocator.lookupType(key) == null || !(jn1 = jn.get(key)).isArray()) continue;
                Iterator<JsonNode> iteJson = jn1.iterator();
                while (iteJson.hasNext()) {
                    RecurringTransaction rt = new RecurringTransaction();
                    JsonNode jn2 = iteJson.next();
                    Iterator<JsonNode> iteJson2 = jn2.iterator();
                    while (iteJson2.hasNext()) {
                        Iterator<String> s = jn2.fieldNames();
                        String rtKey = s.next();
                        LOG.debug("RecurringTransaction : " + rtKey);
                        JsonNode jn3 = iteJson2.next();
                        this.registerModulesForCustomFieldDef(mapper);
                        Object intuitType = mapper.treeToValue(jn3, JsonResourceTypeLocator.lookupType(rtKey));
                        if (!(intuitType instanceof IntuitEntity)) continue;
                        this.intuitResponseDeserializerHelper.updateBigDecimalScale((IntuitEntity)intuitType);
                        JAXBElement<IntuitEntity> intuitObject = this.objFactory.createIntuitObject((IntuitEntity)intuitType);
                        rt.setIntuitObject(intuitObject);
                    }
                    this.registerModulesForCustomFieldDef(mapper);
                    RecurringTransaction intuitType = rt;
                    if (!(intuitType instanceof IntuitEntity)) continue;
                    this.intuitResponseDeserializerHelper.updateBigDecimalScale(intuitType);
                    JAXBElement<IntuitEntity> intuitObject = this.objFactory.createIntuitObject(intuitType);
                    qr.getIntuitObject().add(intuitObject);
                }
                continue;
            }
            if (JsonResourceTypeLocator.lookupType(key) == null) continue;
            jn1 = jn.get(key);
            LOG.debug("Query response entity Key :" + key);
            if (!jn1.isArray()) continue;
            for (JsonNode jn2 : jn1) {
                this.registerModulesForCustomFieldDef(mapper);
                Object intuitType = mapper.treeToValue(jn2, JsonResourceTypeLocator.lookupType(key));
                if (!(intuitType instanceof IntuitEntity)) continue;
                this.intuitResponseDeserializerHelper.updateBigDecimalScale((IntuitEntity)intuitType);
                JAXBElement<IntuitEntity> intuitObject = this.objFactory.createIntuitObject((IntuitEntity)intuitType);
                qr.getIntuitObject().add(intuitObject);
            }
        }
        return qr;
    }

    private void registerModulesForCustomFieldDef(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule("CustomFieldDefinition", new Version(1, 0, 0, null));
        simpleModule.addDeserializer(CustomFieldDefinition.class, new CustomFieldDefinitionDeserializer());
        objectMapper.registerModule(simpleModule);
    }
}

