/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.intuit.ipp.exception.SerializationException;
import com.intuit.ipp.serialization.IEntitySerializer;
import com.intuit.ipp.serialization.JSONSerializer;
import com.intuit.ipp.serialization.XMLSerializer;
import com.intuit.ipp.util.StringUtils;

public final class SerializerFactory {
    public static final String XML_SERIALIZE_FORMAT = "xml";
    public static final String JSON_SERIALIZE_FORMAT = "json";

    private SerializerFactory() {
    }

    public static SerializerFactory getInstance() {
        return new SerializerFactory();
    }

    public static IEntitySerializer getSerializer(String serializeFormat) throws SerializationException {
        IEntitySerializer serializer = null;
        if (SerializerFactory.isValidSerializeFormat(serializeFormat)) {
            if (serializeFormat.equalsIgnoreCase(XML_SERIALIZE_FORMAT)) {
                serializer = new XMLSerializer();
            } else if (serializeFormat.equalsIgnoreCase(JSON_SERIALIZE_FORMAT)) {
                serializer = new JSONSerializer();
            }
        }
        return serializer;
    }

    public static boolean isValidSerializeFormat(String serializeFormat) throws SerializationException {
        if (!StringUtils.hasText(serializeFormat)) {
            throw new SerializationException("serialization format is either null or empty!");
        }
        if (serializeFormat.equalsIgnoreCase(XML_SERIALIZE_FORMAT) || serializeFormat.equalsIgnoreCase(JSON_SERIALIZE_FORMAT)) {
            return true;
        }
        throw new SerializationException("Serializer not supported for the given serialization format : " + serializeFormat);
    }
}

