/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.intuit.ipp.core.Response;
import com.intuit.ipp.data.EntitlementsResponse;
import com.intuit.ipp.exception.SerializationException;
import com.intuit.ipp.serialization.IEntitySerializer;
import com.intuit.ipp.util.MessageUtils;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;

public class XMLSerializer
implements IEntitySerializer {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    @Override
    public <T> String serialize(T object) throws SerializationException {
        if (object == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = MessageUtils.createMarshaller();
            marshaller.marshal(object, (Writer)writer);
        }
        catch (JAXBException e) {
            LOG.error("unable to marshall in XML Serializer", e);
            throw new SerializationException(e);
        }
        String documentToPost = writer.toString();
        LOG.debug("XML serialized data : " + documentToPost);
        return documentToPost;
    }

    @Override
    public Response deserialize(String str, Class<?> cl) throws SerializationException {
        Object unmarshalledObject = this.deserializeData(str, cl);
        return (Response)((JAXBElement)unmarshalledObject).getValue();
    }

    private Object deserializeData(String str, Class<?> cl) throws SerializationException {
        Object unmarshalledObject;
        String validXmlString = this.getValidatedXmlString(str);
        LOG.trace("valid : " + validXmlString);
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((String)cl.getPackage().getName()).createUnmarshaller();
            unmarshalledObject = unmarshaller.unmarshal((Reader)new StringReader(new String(validXmlString.getBytes(), "UTF-8")));
        }
        catch (Exception e) {
            LOG.error("unable to unmarshall in XML deserializer s 1", e);
            throw new SerializationException(e);
        }
        return unmarshalledObject;
    }

    private String getValidatedXmlString(String str) {
        String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
        String validXmlString = str.replaceAll(xml10pattern, "");
        return validXmlString;
    }

    @Override
    public Response deserializeEntitlements(String decompressedData, Class<EntitlementsResponse> cl) throws SerializationException {
        EntitlementsResponse response;
        String validXmlString = this.getValidatedXmlString(decompressedData);
        LOG.trace("valid : " + validXmlString);
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{EntitlementsResponse.class}).createUnmarshaller();
            response = (EntitlementsResponse)unmarshaller.unmarshal((Reader)new StringReader(new String(validXmlString.getBytes(), "UTF-8")));
        }
        catch (Exception e) {
            LOG.error("unable to unmarshall in XML deserializer s 1", e);
            throw new SerializationException(e);
        }
        return response;
    }
}

