/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.services;

import com.intuit.ipp.core.Context;
import com.intuit.ipp.data.TaxService;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.IntuitInterceptorProvider;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.RequestElements;
import com.intuit.ipp.net.MethodType;
import java.util.Map;

public class GlobalTaxService {
    private transient Context context = null;

    protected GlobalTaxService() {
    }

    public GlobalTaxService(Context context) {
        this.context = context;
    }

    public TaxService addTaxCode(TaxService entity) throws FMSException {
        IntuitMessage intuitMessage = this.prepareAddTaxCode(entity);
        new IntuitInterceptorProvider().executeInterceptors(intuitMessage);
        TaxService taxServiceResponse = (TaxService)intuitMessage.getResponseElements().getResponse();
        return taxServiceResponse;
    }

    private IntuitMessage prepareAddTaxCode(TaxService entity) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        requestElements.setEntity(entity);
        requestElements.setObjectToSerialize(entity);
        requestElements.setContext(this.context);
        return intuitMessage;
    }
}

