/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.core.Context;
import com.intuit.ipp.exception.CompressionException;
import com.intuit.ipp.exception.ConfigurationException;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.RequestElements;
import com.intuit.ipp.interceptors.ResponseElements;
import com.intuit.ipp.net.IntuitRetryPolicyHandler;
import com.intuit.ipp.net.MethodType;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.PropertyHelper;
import com.intuit.ipp.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;

public class HTTPBatchClientConnectionInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final int LENGTH_256 = 256;
    private EntitiesManager entitiesManager = new EntitiesManager(this);

    public void execute(List<IntuitMessage> intuitMessages) throws FMSException {
        LOG.debug("Enter HTTPBatchClientConnectionInterceptor - batch...");
        RequestElements intuitRequest = this.getFirst(intuitMessages).getRequestElements();
        IntuitRetryPolicyHandler handler = this.getRetryHandler();
        HttpClientBuilder hcBuilder = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)handler).setDefaultRequestConfig(this.setTimeout(intuitRequest.getContext())).setDefaultCredentialsProvider(this.setProxyAuthentication()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.prepareClientSSL());
        this.entitiesManager.reset();
        HttpHost proxy = this.getProxy();
        if (proxy != null) {
            hcBuilder.setProxy(proxy);
        }
        CloseableHttpClient client = hcBuilder.build();
        HttpRequestBase httpRequest = this.prepareHttpRequest(intuitRequest);
        if (httpRequest instanceof HttpPost) {
            for (IntuitMessage intuitMessage : intuitMessages) {
                this.execute(intuitMessage);
            }
            try {
                ((HttpPost)httpRequest).setEntity(this.entitiesManager.asSingleEntity());
            }
            catch (IOException ex) {
                LOG.debug("HTTPBatchClientConnectionInterceptor was unable to convert input into single HTTP entity");
                throw new FMSException("Unable to prepare http entity" + ex.getMessage() + "\n" + String.valueOf(ex.getStackTrace()));
            }
            finally {
                this.entitiesManager.reset();
            }
        }
        IntuitMessage intuitMessage = this.executeHttpRequest(httpRequest, client);
        for (IntuitMessage originalMessage : intuitMessages) {
            ResponseElements originalResponseElements = originalMessage.getResponseElements();
            ResponseElements receivedResponseElements = intuitMessage.getResponseElements();
            originalResponseElements.setResponseContent(receivedResponseElements.getResponseContent());
            originalResponseElements.setEncodingHeader(receivedResponseElements.getEncodingHeader());
            originalResponseElements.setContentTypeHeader(receivedResponseElements.getContentTypeHeader());
            originalResponseElements.setStatusLine(receivedResponseElements.getStatusLine());
            originalResponseElements.setStatusCode(receivedResponseElements.getStatusCode());
        }
        LOG.debug("Exit HTTPBatchClientConnectionInterceptor.");
    }

    private IntuitMessage getFirst(List<IntuitMessage> intuitMessages) throws FMSException {
        if (intuitMessages.isEmpty()) {
            throw new FMSException("IntuitMessages list is empty. Nothing to upload.");
        }
        return intuitMessages.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLConnectionSocketFactory prepareClientSSL() {
        try {
            String path = Config.getProperty("proxy.keystore.path");
            String pass = Config.getProperty("proxy.keystore.password");
            KeyStore trustStore = null;
            if (path != null && pass != null) {
                trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream instream = new FileInputStream(new File(path));){
                    trustStore.load(instream, pass.toCharArray());
                }
            }
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            String tlsVersion = Config.getProperty("tls.version");
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, new String[]{tlsVersion}, null, (HostnameVerifier)new NoopHostnameVerifier());
            return sslConnectionFactory;
        }
        catch (Exception ex) {
            LOG.error("couldn't create httpClient!! {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    public CredentialsProvider setProxyAuthentication() {
        String username = Config.getProperty("proxy.username");
        String password = Config.getProperty("proxy.password");
        if (StringUtils.hasText(username) && StringUtils.hasText(password)) {
            String host = Config.getProperty("proxy.host");
            String port = Config.getProperty("proxy.port");
            if (StringUtils.hasText(host) && StringUtils.hasText(port)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                String domain = Config.getProperty("proxy.domain");
                if (StringUtils.hasText(domain)) {
                    credentialsProvider.setCredentials(new AuthScope(host, Integer.parseInt(port)), (Credentials)new NTCredentials(username, password, host, domain));
                } else {
                    credentialsProvider.setCredentials(new AuthScope(host, Integer.parseInt(port)), (Credentials)new UsernamePasswordCredentials(username, password));
                }
                return credentialsProvider;
            }
        }
        return null;
    }

    private <T extends CloseableHttpClient> HttpRequestBase prepareHttpRequest(RequestElements intuitRequest) throws FMSException {
        HttpRequestBase httpRequest = this.extractMethod(intuitRequest, this.extractURI(intuitRequest));
        this.populateRequestHeaders(httpRequest, intuitRequest.getRequestHeaders());
        this.authorizeRequest(intuitRequest.getContext(), httpRequest);
        LOG.debug("Request URI : " + String.valueOf(httpRequest.getURI()));
        LOG.debug("Http Method : " + httpRequest.getMethod());
        return httpRequest;
    }

    private URI extractURI(RequestElements intuitRequest) throws FMSException {
        URI uri = null;
        try {
            uri = new URI(intuitRequest.getRequestParameters().get("uri"));
        }
        catch (URISyntaxException e) {
            throw new FMSException("URISyntaxException", e);
        }
        return uri;
    }

    private HttpRequestBase extractMethod(RequestElements intuitRequest, URI uri) throws FMSException {
        String method = intuitRequest.getRequestParameters().get("method_type");
        if (method.equals(MethodType.GET.toString())) {
            return new HttpGet(uri);
        }
        if (method.equals(MethodType.POST.toString())) {
            return new HttpPost(uri);
        }
        throw new FMSException("Unexpected HTTP method");
    }

    private IntuitMessage executeHttpRequest(HttpRequestBase httpRequest, CloseableHttpClient client) throws FMSException {
        CloseableHttpResponse httpResponse = null;
        IntuitMessage intuitMessage = new IntuitMessage();
        try {
            HttpHost target = new HttpHost(httpRequest.getURI().getHost(), -1, httpRequest.getURI().getScheme());
            httpResponse = client.execute(target, (HttpRequest)httpRequest);
            LOG.debug("Connection status : " + String.valueOf(httpResponse.getStatusLine()));
            this.setResponseElements(intuitMessage, (HttpResponse)httpResponse);
            IntuitMessage intuitMessage2 = intuitMessage;
            return intuitMessage2;
        }
        catch (ClientProtocolException e) {
            throw new ConfigurationException("Error in Http Protocol definition", e);
        }
        catch (IOException e) {
            throw new FMSException(e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close CloseableHttpResponse .", (Throwable)e);
                }
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception e) {
                    LOG.warn("Unable to close CloseableHttpClient connection.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        this.entitiesManager.add(this.populateEntity(intuitMessage.getRequestElements()));
    }

    private void populateRequestHeaders(HttpRequestBase httpRequest, Map<String, String> requestHeaders) {
        Set<String> keySet = requestHeaders.keySet();
        for (String key : keySet) {
            String value = requestHeaders.get(key);
            httpRequest.addHeader(key, value);
        }
        PropertyHelper propertyHelper = PropertyHelper.getInstance();
        String requestSource = propertyHelper.getRequestSource() + propertyHelper.getVersion();
        if (propertyHelper.getRequestSourceHeader() != null) {
            httpRequest.addHeader(propertyHelper.getRequestSourceHeader(), requestSource);
        }
    }

    private void authorizeRequest(Context context, HttpRequestBase httpRequest) throws FMSException {
        context.getAuthorizer().authorize(httpRequest);
    }

    private IntuitRetryPolicyHandler getRetryHandler() throws FMSException {
        IntuitRetryPolicyHandler handler = null;
        String policy = Config.getProperty("retry.mode");
        if (policy.equalsIgnoreCase("fixed")) {
            String retryCountStr = Config.getProperty("retry.fixed.count");
            String retryIntervalStr = Config.getProperty("retry.fixed.interval");
            try {
                handler = new IntuitRetryPolicyHandler(Integer.parseInt(retryCountStr), Integer.parseInt(retryIntervalStr));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e);
            }
        }
        if (policy.equalsIgnoreCase("incremental")) {
            String retryCountStr = Config.getProperty("retry.incremental.count");
            String retryIntervalStr = Config.getProperty("retry.incremental.interval");
            String retryIncrementStr = Config.getProperty("retry.incremental.increment");
            try {
                handler = new IntuitRetryPolicyHandler(Integer.parseInt(retryCountStr), Integer.parseInt(retryIntervalStr), Integer.parseInt(retryIncrementStr));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e);
            }
        }
        if (policy.equalsIgnoreCase("exponential")) {
            String retryCountStr = Config.getProperty("retry.exponential.count");
            String minBackoffStr = Config.getProperty("retry.exponential.minBackoff");
            String maxBackoffStr = Config.getProperty("retry.exponential.maxBackoff");
            String deltaBackoffStr = Config.getProperty("retry.exponential.deltaBackoff");
            try {
                handler = new IntuitRetryPolicyHandler(Integer.parseInt(retryCountStr), Integer.parseInt(minBackoffStr), Integer.parseInt(maxBackoffStr), Integer.parseInt(deltaBackoffStr));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e);
            }
        }
        return handler;
    }

    public HttpHost getProxy() {
        String host = Config.getProperty("proxy.host");
        String port = Config.getProperty("proxy.port");
        HttpHost proxy = null;
        if (StringUtils.hasText(host) && StringUtils.hasText(port)) {
            proxy = new HttpHost(host, Integer.parseInt(port));
        }
        return proxy;
    }

    private void setResponseElements(IntuitMessage intuitMessage, HttpResponse httpResponse) throws FMSException {
        ResponseElements responseElements = intuitMessage.getResponseElements();
        if (httpResponse.getLastHeader("Content-Encoding") != null) {
            responseElements.setEncodingHeader(httpResponse.getLastHeader("Content-Encoding").getValue());
        } else {
            responseElements.setEncodingHeader(null);
        }
        if (httpResponse.getLastHeader("content-type") != null) {
            responseElements.setContentTypeHeader(httpResponse.getLastHeader("content-type").getValue());
        } else {
            responseElements.setContentTypeHeader(null);
        }
        responseElements.setStatusLine(httpResponse.getStatusLine());
        responseElements.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        try {
            responseElements.setResponseContent(this.getCopyOfResponseContent(httpResponse.getEntity().getContent()));
        }
        catch (IllegalStateException e) {
            LOG.error("IllegalStateException while get the content from HttpRespose.", (Throwable)e);
            throw new FMSException(e);
        }
        catch (Exception e) {
            LOG.error("IOException in HTTPClientConnectionInterceptor while reading the entity from HttpResponse.", (Throwable)e);
            throw new FMSException(e);
        }
    }

    private InputStream getCopyOfResponseContent(InputStream is) throws FMSException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream copyIs = null;
        try {
            int r;
            byte[] bbuf = new byte[256];
            while ((r = is.read(bbuf)) >= 0) {
                baos.write(bbuf, 0, r);
            }
            ByteArrayInputStream byteArrayInputStream = copyIs = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ioe) {
            LOG.error("IOException while decompress the data using GZIP compression.", (Throwable)ioe);
            throw new CompressionException(ioe);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to close ByteArrayOutputStream.");
                }
            }
        }
    }

    private RequestConfig setTimeout(Context context) {
        int socketTimeout = 0;
        int connectionTimeout = 0;
        if (context.getCustomerRequestTimeout() != null) {
            socketTimeout = context.getCustomerRequestTimeout();
        } else {
            String reqTimeout = Config.getProperty("timeout.requestTimeout");
            if (StringUtils.hasText(reqTimeout)) {
                socketTimeout = new Integer(reqTimeout.trim());
            }
        }
        String connTimeout = Config.getProperty("timeout.connectionTimeout");
        if (StringUtils.hasText(connTimeout)) {
            connectionTimeout = new Integer(connTimeout.trim());
        }
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(connectionTimeout).setCookieSpec("ignoreCookies").build();
        return defaultRequestConfig;
    }

    private HttpEntity populateEntity(RequestElements intuitRequest) throws FMSException {
        byte[] compressedData = intuitRequest.getCompressedData();
        if (null == compressedData) {
            try {
                return new StringEntity(intuitRequest.getPostString());
            }
            catch (UnsupportedEncodingException e) {
                throw new FMSException("UnsupportedEncodingException", e);
            }
        }
        return new InputStreamEntity((InputStream)new ByteArrayInputStream(compressedData), (long)compressedData.length);
    }

    private class EntitiesManager {
        private List<HttpEntity> entities = new ArrayList<HttpEntity>();
        private static final int MIN_SIZE = 1;
        private static final int MIN_SIZE_INDEX = 0;

        private EntitiesManager(HTTPBatchClientConnectionInterceptor hTTPBatchClientConnectionInterceptor) {
        }

        public boolean isEmpty() {
            return this.entities.isEmpty();
        }

        public void reset() {
            if (!this.isEmpty()) {
                this.entities.clear();
            }
        }

        public void add(HttpEntity entity) {
            this.entities.add(entity);
        }

        public HttpEntity asSingleEntity() throws IOException {
            if (1 == this.entities.size()) {
                return this.entities.get(0);
            }
            byte[] buffer = new byte[]{};
            for (HttpEntity entity : this.entities) {
                InputStream stream = entity.getContent();
                buffer = ArrayUtils.addAll((byte[])buffer, (byte[])IOUtils.toByteArray((InputStream)stream));
            }
            return new InputStreamEntity((InputStream)new ByteArrayInputStream(buffer), (long)buffer.length);
        }
    }
}

