/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.core.Context;
import com.intuit.ipp.exception.CompressionException;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.RequestElements;
import com.intuit.ipp.interceptors.ResponseElements;
import com.intuit.ipp.net.MethodType;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.PropertyHelper;
import com.intuit.ipp.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class HTTPURLConnectionInterceptor
implements Interceptor {
    public static final String HTTP_URL_CONNECTION = "HTTP_URL_CONNECTION";
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final int LENGTH_256 = 256;

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        LOG.debug("Enter HTTPURLConnectionInterceptor...");
        RequestElements intuitRequest = intuitMessage.getRequestElements();
        URI uri = null;
        HttpURLConnection httpUrlConnection = null;
        String methodtype = intuitRequest.getRequestParameters().get("method_type");
        Proxy proxy = this.setupProxy();
        try {
            byte[] compressedData;
            uri = new URI(intuitRequest.getRequestParameters().get("uri"));
            URL url = uri.toURL();
            httpUrlConnection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            httpUrlConnection.setRequestMethod(methodtype);
            this.setTimeout(httpUrlConnection);
            this.populateRequestHeaders(httpUrlConnection, intuitRequest.getRequestHeaders());
            this.authorizeRequest(intuitRequest.getContext(), httpUrlConnection);
            if (intuitRequest.getCompressedData() != null) {
                httpUrlConnection.setDoOutput(true);
            }
            LOG.debug("Request URI : " + String.valueOf(uri));
            LOG.debug("Request Method : " + methodtype);
            LOG.debug("Request Headers : " + String.valueOf(httpUrlConnection.getRequestProperties()));
            LOG.debug("Request Body : " + intuitRequest.getSerializedData());
            httpUrlConnection.connect();
            if (methodtype.equals(MethodType.POST.toString()) && (compressedData = intuitRequest.getCompressedData()) != null) {
                DataOutputStream output = new DataOutputStream(httpUrlConnection.getOutputStream());
                output.write(compressedData);
                output.flush();
                output.close();
            }
            this.setResponseElements(intuitMessage, httpUrlConnection);
        }
        catch (URISyntaxException e) {
            throw new FMSException("URISyntaxException", e);
        }
        catch (IOException e) {
            throw new FMSException("IO Exception", e);
        }
        catch (Throwable e) {
            throw new FMSException("Unexpected expection", e);
        }
        finally {
            httpUrlConnection.disconnect();
        }
        LOG.debug("Exit HTTPURLConnectionInterceptor.");
    }

    private void populateRequestHeaders(HttpURLConnection httpUrlConnection, Map<String, String> requestHeaders) {
        Set<String> keySet = requestHeaders.keySet();
        for (String key : keySet) {
            String value = requestHeaders.get(key);
            httpUrlConnection.setRequestProperty(key, value);
        }
        PropertyHelper propertyHelper = PropertyHelper.getInstance();
        String requestSource = propertyHelper.getRequestSource() + propertyHelper.getVersion();
        if (propertyHelper.getRequestSourceHeader() != null) {
            httpUrlConnection.setRequestProperty(propertyHelper.getRequestSourceHeader(), requestSource);
        }
    }

    private void authorizeRequest(Context context, HttpURLConnection httpUrlConnection) throws FMSException {
        context.getAuthorizer().authorize(httpUrlConnection);
    }

    private Proxy setupProxy() {
        String host = Config.getProperty("proxy.host");
        String port = Config.getProperty("proxy.port");
        if (StringUtils.hasText(host) && StringUtils.hasText(port)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, Integer.parseInt(port)));
            final String username = Config.getProperty("proxy.username");
            final String password = Config.getProperty("proxy.password");
            if (StringUtils.hasText(username) && StringUtils.hasText(password)) {
                Authenticator authenticator = new Authenticator(this){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
            return proxy;
        }
        return null;
    }

    private void setResponseElements(IntuitMessage intuitMessage, HttpURLConnection httpUrlConnection) throws FMSException {
        LOG.debug("Response headers:" + String.valueOf(httpUrlConnection.getHeaderFields()));
        ResponseElements responseElements = intuitMessage.getResponseElements();
        responseElements.setEncodingHeader(httpUrlConnection.getContentEncoding());
        responseElements.setContentTypeHeader(httpUrlConnection.getContentType());
        try {
            InputStream responseStream;
            responseElements.setStatusCode(httpUrlConnection.getResponseCode());
            try {
                responseStream = httpUrlConnection.getInputStream();
            }
            catch (IOException ioe) {
                responseStream = httpUrlConnection.getErrorStream();
            }
            responseElements.setResponseContent(this.getCopyOfResponseContent(responseStream));
        }
        catch (IllegalStateException e) {
            LOG.error("IllegalStateException while get the content from HttpRespose.", (Throwable)e);
            throw new FMSException(e);
        }
        catch (Exception e) {
            LOG.error("IOException in HTTPURLConnectionInterceptor while reading the entity from HttpResponse.", (Throwable)e);
            throw new FMSException(e);
        }
    }

    private InputStream getCopyOfResponseContent(InputStream is) throws FMSException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream copyIs = null;
        try {
            int r;
            byte[] bbuf = new byte[256];
            while ((r = is.read(bbuf)) >= 0) {
                baos.write(bbuf, 0, r);
            }
            ByteArrayInputStream byteArrayInputStream = copyIs = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ioe) {
            LOG.error("IOException while decompress the data using GZIP compression.", (Throwable)ioe);
            throw new CompressionException(ioe);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to close ByteArrayOutputStream.");
                }
            }
        }
    }

    private void setTimeout(HttpURLConnection httpUrlConnection) {
        String reqTimeout;
        String connTimeout = Config.getProperty("timeout.connectionTimeout");
        if (StringUtils.hasText(connTimeout)) {
            httpUrlConnection.setReadTimeout(new Integer(connTimeout.trim()));
        }
        if (StringUtils.hasText(reqTimeout = Config.getProperty("timeout.requestTimeout"))) {
            httpUrlConnection.setConnectTimeout(new Integer(reqTimeout.trim()));
        }
    }
}

