/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.data.RecurringTransaction;
import com.intuit.ipp.exception.SerializationException;
import com.intuit.ipp.serialization.JSONSerializer;
import java.io.IOException;
import org.slf4j.Logger;

public class RecurringTransactionSerializer
extends JsonSerializer<RecurringTransaction> {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    public void serialize(RecurringTransaction recurringTransaction, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (recurringTransaction.getIntuitObject() != null) {
            jgen.writeFieldName(((IntuitEntity)recurringTransaction.getIntuitObject().getValue()).getClass().getSimpleName());
            try {
                jgen.writeNumber(new JSONSerializer().serialize(recurringTransaction.getIntuitObject()));
            }
            catch (SerializationException e) {
                LOG.error("SerializationException while generating Json for IntuitObject in RecurringTransactionSerializer.", (Throwable)e);
                throw new IOException(e);
            }
        }
        jgen.writeEndObject();
    }
}

