/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.services;

import com.intuit.ipp.core.Context;
import com.intuit.ipp.core.IEntity;
import com.intuit.ipp.data.AttachableResponse;
import com.intuit.ipp.data.BatchItemResponse;
import com.intuit.ipp.data.CDCResponse;
import com.intuit.ipp.data.CreditMemo;
import com.intuit.ipp.data.EntitlementsResponse;
import com.intuit.ipp.data.Estimate;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitBatchRequest;
import com.intuit.ipp.data.IntuitResponse;
import com.intuit.ipp.data.Invoice;
import com.intuit.ipp.data.ObjectFactory;
import com.intuit.ipp.data.Payment;
import com.intuit.ipp.data.PurchaseOrder;
import com.intuit.ipp.data.QueryResponse;
import com.intuit.ipp.data.RefundReceipt;
import com.intuit.ipp.data.SalesReceipt;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.IntuitBatchInterceptorProvider;
import com.intuit.ipp.interceptors.IntuitInterceptorProvider;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.RequestElements;
import com.intuit.ipp.interceptors.UploadRequestElements;
import com.intuit.ipp.net.ContentTypes;
import com.intuit.ipp.net.MethodType;
import com.intuit.ipp.net.OperationType;
import com.intuit.ipp.net.UploadEntry;
import com.intuit.ipp.services.BatchOperation;
import com.intuit.ipp.services.CDCQueryResult;
import com.intuit.ipp.services.CallbackHandler;
import com.intuit.ipp.services.QueryResult;
import com.intuit.ipp.util.MessageUtils;
import com.intuit.ipp.util.StringUtils;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.xml.bind.JAXBElement;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;

public class DataService {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final int LENGTH_200 = 200;
    private transient Context context = null;

    protected DataService() {
    }

    public DataService(Context context) {
        this.context = context;
    }

    public <T extends IEntity> List<T> findAll(T entity) throws FMSException {
        this.verifyEntity(entity);
        String intuitQuery = "SELECT * FROM " + entity.getClass().getSimpleName();
        QueryResult result = this.executeQuery(intuitQuery);
        return result.getEntities();
    }

    public QueryResult findAllTaxClassification() throws FMSException {
        String intuitQuery = "SELECT * FROM TaxClassification";
        QueryResult result = this.executeQuery(intuitQuery);
        return result;
    }

    public <T extends IEntity> T add(T entity) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareAdd(entity);
        this.executeInterceptors(intuitMessage);
        return this.retrieveEntity(intuitMessage);
    }

    protected void executeInterceptors(IntuitMessage intuitMessage) throws FMSException {
        new IntuitInterceptorProvider().executeInterceptors(intuitMessage);
    }

    protected void executeInterceptors(List<IntuitMessage> intuitMessages) throws FMSException {
        new IntuitBatchInterceptorProvider().executeInterceptors(intuitMessages);
    }

    protected void executeAsyncInterceptors(IntuitMessage intuitMessage) {
        new IntuitInterceptorProvider().executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> T delete(T entity) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareDelete(entity);
        this.executeInterceptors(intuitMessage);
        return this.retrieveEntity(intuitMessage);
    }

    public <T extends IEntity> T update(T entity) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareUpdate(entity);
        this.executeInterceptors(intuitMessage);
        return this.retrieveEntity(intuitMessage);
    }

    public <T extends IEntity> T updateAccountOnTxns(T entity) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareupdateAccountOnTxns(entity);
        this.executeInterceptors(intuitMessage);
        return this.retrieveEntity(intuitMessage);
    }

    public <T extends IEntity> T donotUpdateAccountOnTxns(T entity) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.preparedonotUpdateAccountOnTxns(entity);
        this.executeInterceptors(intuitMessage);
        return this.retrieveEntity(intuitMessage);
    }

    private <T extends IEntity> T retrieveEntity(IntuitMessage intuitMessage) {
        JAXBElement intuitObject;
        IEntity returnEntity = null;
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null && (intuitObject = intuitResponse.getIntuitObject()) != null) {
            returnEntity = (IEntity)intuitObject.getValue();
        }
        return (T)returnEntity;
    }

    public <T extends IEntity> T findById(T entity) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareFindById(entity);
        this.executeInterceptors(intuitMessage);
        IEntity returnEntity = null;
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null) {
            QueryResponse queryResponse;
            List intuitObject;
            if (intuitResponse.getIntuitObject() != null) {
                JAXBElement intuitObject2 = intuitResponse.getIntuitObject();
                if (intuitObject2 != null) {
                    returnEntity = (IEntity)intuitObject2.getValue();
                }
            } else if (intuitResponse.getQueryResponse() != null && (intuitObject = (queryResponse = intuitResponse.getQueryResponse()).getIntuitObject()) != null && intuitObject.size() > 0) {
                returnEntity = (IEntity)((JAXBElement)intuitObject.get(0)).getValue();
            }
        }
        return (T)returnEntity;
    }

    public QueryResult findTaxClassificationByParentId(IEntity entity) throws FMSException {
        QueryResponse queryResponse;
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareFindByParentId(entity);
        this.executeInterceptors(intuitMessage);
        QueryResult queryResult = null;
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null && (queryResponse = intuitResponse.getQueryResponse()) != null) {
            queryResult = this.getQueryResult(queryResponse);
        }
        return queryResult;
    }

    public QueryResult findTaxClassificationByLevel(IEntity entity) throws FMSException {
        QueryResponse queryResponse;
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareFindByLevel(entity);
        this.executeInterceptors(intuitMessage);
        QueryResult queryResult = null;
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null && (queryResponse = intuitResponse.getQueryResponse()) != null) {
            queryResult = this.getQueryResult(queryResponse);
        }
        return queryResult;
    }

    public <T extends IEntity> T voidRequest(T entity) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareVoidRequest(entity);
        this.executeInterceptors(intuitMessage);
        return this.retrieveEntity(intuitMessage);
    }

    public <T extends IEntity> T upload(T entity, InputStream docContent) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareUpload(entity, docContent);
        this.executeInterceptors(intuitMessage);
        return this.getReturnEntity(intuitMessage);
    }

    private <T extends IEntity> T getReturnEntity(IntuitMessage intuitMessage) {
        return this.getReturnEntity(intuitMessage, 0);
    }

    private <T extends IEntity> T getReturnEntity(IntuitMessage intuitMessage, int idx) {
        IEntity returnEntity = null;
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null) {
            List attachableResponse;
            if (intuitResponse.getIntuitObject() != null) {
                JAXBElement intuitObject = intuitResponse.getIntuitObject();
                if (intuitObject != null) {
                    returnEntity = (IEntity)intuitObject.getValue();
                }
            } else if (intuitResponse.getQueryResponse() != null) {
                QueryResponse queryResponse = intuitResponse.getQueryResponse();
                List intuitObject = queryResponse.getIntuitObject();
                if (intuitObject != null && intuitObject.size() > 0) {
                    returnEntity = (IEntity)((JAXBElement)intuitObject.get(idx)).getValue();
                }
            } else if (intuitResponse.getAttachableResponse() != null && (attachableResponse = intuitResponse.getAttachableResponse()) != null && attachableResponse.size() > 0) {
                returnEntity = ((AttachableResponse)attachableResponse.get(idx)).getAttachable();
            }
        }
        return (T)returnEntity;
    }

    public <T extends IEntity> List<T> upload(List<UploadEntry> entries) throws FMSException {
        List<IntuitMessage> intuitMessages = this.prepareUpload(entries);
        if (!intuitMessages.isEmpty()) {
            this.executeInterceptors(intuitMessages);
        }
        return this.getResultEntities(intuitMessages);
    }

    private <T extends IEntity> List<T> getResultEntities(List<IntuitMessage> intuitMessages) {
        ArrayList<T> resultEntities = new ArrayList<T>();
        int i = 0;
        for (IntuitMessage intuitMessage : intuitMessages) {
            if (!this.isContainResponse(intuitMessage, i)) {
                LOG.warn("Response object with index=" + i + " was expected, got nothing.");
            } else {
                resultEntities.add(this.getReturnEntity(intuitMessage, i));
            }
            ++i;
        }
        return resultEntities;
    }

    private List<IntuitMessage> prepareUpload(List<UploadEntry> entries) throws FMSException {
        ArrayList<IntuitMessage> intuitMessages = new ArrayList<IntuitMessage>();
        String boundaryId = null;
        for (UploadEntry item : entries) {
            if (item.isEmpty()) {
                LOG.warn("UploadEntry instance (hash:" + System.identityHashCode(item) + ") has at least one null property. It should have intuit entity and InputStream instances");
            }
            IntuitMessage intuitMessage = this.prepareUpload(item.getEntity(), item.getStream(), boundaryId);
            if (null == boundaryId) {
                boundaryId = intuitMessage.getRequestElements().getUploadRequestElements().getBoundaryId();
            }
            intuitMessages.add(intuitMessage);
        }
        return intuitMessages;
    }

    private boolean isContainResponse(IntuitMessage intuitMessage, int idx) {
        List response = ((IntuitResponse)intuitMessage.getResponseElements().getResponse()).getAttachableResponse();
        if (null == response) {
            return false;
        }
        if (0 >= response.size()) {
            return false;
        }
        return idx < response.size();
    }

    public <T extends IEntity> InputStream download(T entity) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareDownload(entity);
        this.executeInterceptors(intuitMessage);
        String response = intuitMessage.getResponseElements().getDecompressedData();
        if (response != null) {
            try {
                URL url = new URL(response);
                return url.openStream();
            }
            catch (Exception e) {
                throw new FMSException("Exception while downloading the input file from URL.", e);
            }
        }
        return null;
    }

    public <T extends IEntity> InputStream downloadPDF(T entity) throws FMSException {
        this.verifyEntity(entity);
        if (!this.isAvailableAsPDF(entity)) {
            throw new FMSException("Following entity: " + entity.getClass().getSimpleName() + " cannot be exported as PDF ");
        }
        IntuitMessage intuitMessage = this.prepareDownloadPDF(entity);
        this.executeInterceptors(intuitMessage);
        return intuitMessage.getResponseElements().getResponseBytes();
    }

    public <T extends IEntity> T sendEmail(T entity) throws FMSException {
        this.verifyEntity(entity);
        return this.sendEmail(entity, null);
    }

    public <T extends IEntity> T sendEmail(T entity, String email) throws FMSException {
        this.verifyEntity(entity);
        if (!this.isAvailableToEmail(entity)) {
            throw new FMSException("Following entity: " + entity.getClass().getSimpleName() + " cannot be send as email");
        }
        IntuitMessage intuitMessage = this.prepareEmail(entity, email);
        this.executeInterceptors(intuitMessage);
        return this.retrieveEntity(intuitMessage);
    }

    private <T extends IEntity> boolean isSpecialEntity(T entity) {
        return entity instanceof Estimate || entity instanceof Invoice || entity instanceof SalesReceipt || entity instanceof CreditMemo || entity instanceof Payment || entity instanceof RefundReceipt || entity instanceof PurchaseOrder;
    }

    public <T extends IEntity> boolean isAvailableAsPDF(T entity) {
        return this.isSpecialEntity(entity);
    }

    public <T extends IEntity> boolean isAvailableToEmail(T entity) {
        return this.isSpecialEntity(entity);
    }

    public QueryResult executeQuery(String query) throws FMSException {
        QueryResponse queryResponse;
        IntuitMessage intuitMessage = this.prepareQuery(query);
        this.executeInterceptors(intuitMessage);
        QueryResult queryResult = null;
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null && (queryResponse = intuitResponse.getQueryResponse()) != null) {
            queryResult = this.getQueryResult(queryResponse);
        }
        return queryResult;
    }

    public List<CDCQueryResult> executeCDCQuery(List<? extends IEntity> entities, String changedSince) throws FMSException {
        List cdcResponses;
        if (entities == null || entities.isEmpty()) {
            throw new FMSException("Entities is required.");
        }
        if (!StringUtils.hasText(changedSince)) {
            throw new FMSException("changedSince is required.");
        }
        IntuitMessage intuitMessage = this.prepareCDCQuery(entities, changedSince);
        this.executeInterceptors(intuitMessage);
        List<CDCQueryResult> cdcQueryResults = null;
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null && (cdcResponses = intuitResponse.getCDCResponse()) != null) {
            cdcQueryResults = this.getCDCQueryResult(cdcResponses);
        }
        return cdcQueryResults;
    }

    public void executeBatch(BatchOperation batchOperation) throws FMSException {
        List batchItemResponses;
        IntuitMessage intuitMessage = this.prepareBatch(batchOperation);
        this.executeInterceptors(intuitMessage);
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null && (batchItemResponses = intuitResponse.getBatchItemResponse()) != null && !batchItemResponses.isEmpty()) {
            int count = 0;
            for (BatchItemResponse batchItemResponse : batchItemResponses) {
                String bId = batchItemResponse.getBId();
                if (!StringUtils.hasText(bId)) {
                    bId = batchOperation.getBatchItemRequests().get(count).getBId();
                }
                if (batchItemResponse.getFault() != null) {
                    batchOperation.getFaultResult().put(bId, batchItemResponse.getFault());
                } else if (batchItemResponse.getReport() != null) {
                    batchOperation.getReportResult().put(bId, batchItemResponse.getReport());
                } else if (batchItemResponse.getIntuitObject() != null) {
                    batchOperation.getEntityResult().put(bId, (IEntity)batchItemResponse.getIntuitObject().getValue());
                } else if (batchItemResponse.getQueryResponse() != null) {
                    QueryResult queryResult = this.getQueryResult(batchItemResponse.getQueryResponse());
                    batchOperation.getQueryResult().put(bId, queryResult);
                } else if (batchItemResponse.getCDCResponse() != null) {
                    CDCQueryResult cdcQueryResult = this.getCDCQueryResult(batchItemResponse.getCDCResponse());
                    batchOperation.getCDCQueryResult().put(bId, cdcQueryResult);
                } else {
                    LOG.warn("BatchItemResponse is not Fault, Entity, Query and Report.");
                }
                ++count;
            }
        }
    }

    public <T extends IEntity> void findAllAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        String query = "SELECT * FROM " + entity.getClass().getSimpleName();
        this.executeQueryAsync(query, callbackHandler);
    }

    public <T extends IEntity> void addAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareAdd(entity);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> void deleteAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareDelete(entity);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> void updateAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareUpdate(entity);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> void findByIdAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareFindById(entity);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> void voidRequestAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareVoidRequest(entity);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> void uploadAsync(T entity, InputStream docContent, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareUpload(entity, docContent);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> void downloadAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        IntuitMessage intuitMessage = this.prepareDownload(entity);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> void downloadPDFAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        if (!this.isAvailableAsPDF(entity)) {
            throw new FMSException("Following entity: " + entity.getClass().getSimpleName() + " cannot be exported as PDF (Async) ");
        }
        IntuitMessage intuitMessage = this.prepareDownloadPDF(entity);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public <T extends IEntity> void sendEmailAsync(T entity, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        this.sendEmailAsync(entity, null, callbackHandler);
    }

    public <T extends IEntity> void sendEmailAsync(T entity, String email, CallbackHandler callbackHandler) throws FMSException {
        this.verifyEntity(entity);
        if (!this.isAvailableToEmail(entity)) {
            throw new FMSException("Following entity: " + entity.getClass().getSimpleName() + " cannot send as email (Async) ");
        }
        IntuitMessage intuitMessage = this.prepareEmail(entity, email);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public void executeQueryAsync(String query, CallbackHandler callbackHandler) throws FMSException {
        IntuitMessage intuitMessage = this.prepareQuery(query);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public void executeCDCQueryAsync(List<? extends IEntity> entities, String changedSince, CallbackHandler callbackHandler) throws FMSException {
        IntuitMessage intuitMessage = this.prepareCDCQuery(entities, changedSince);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    public EntitlementsResponse getEntitlements() throws FMSException {
        IntuitMessage intuitMessage = this.prepareEntitlementsRequest();
        this.executeInterceptors(intuitMessage);
        EntitlementsResponse entitlementsResponse = (EntitlementsResponse)intuitMessage.getResponseElements().getResponse();
        return entitlementsResponse;
    }

    public void executeBatchAsync(BatchOperation batchOperation, CallbackHandler callbackHandler) throws FMSException {
        IntuitMessage intuitMessage = this.prepareBatch(batchOperation);
        intuitMessage.getRequestElements().setCallbackHandler(callbackHandler);
        this.executeAsyncInterceptors(intuitMessage);
    }

    private <T extends IEntity> IntuitMessage prepareAdd(T entity) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        requestElements.setObjectToSerialize(this.getSerializableObject(entity));
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareUpdate(T entity) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        requestParameters.put("operation", OperationType.UPDATE.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        requestElements.setObjectToSerialize(this.getSerializableObject(entity));
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareupdateAccountOnTxns(T entity) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        requestParameters.put("operation", OperationType.UPDATEACCOUNTONTXNS.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        requestElements.setObjectToSerialize(this.getSerializableObject(entity));
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage preparedonotUpdateAccountOnTxns(T entity) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        requestParameters.put("operation", OperationType.DONOTUPDATEACCOUNTONTXNS.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        requestElements.setObjectToSerialize(this.getSerializableObject(entity));
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareDelete(T entity) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        requestParameters.put("operation", OperationType.DELETE.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        requestElements.setObjectToSerialize(this.getSerializableObject(entity));
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareFindById(T entity) throws FMSException {
        Class objectClass = entity.getClass();
        String entityName = objectClass.getSimpleName();
        Object rid = null;
        try {
            Method m = objectClass.getMethod("getId", new Class[0]);
            rid = m.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new FMSException("Unable to read the method getId", e);
        }
        if (!(entityName.equals("Preferences") || entityName.equals("OLBTransaction") || entityName.equals("OLBStatus") || rid != null)) {
            throw new FMSException("Id is required.");
        }
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.GET.toString());
        if (!(entityName.equals("Preferences") || entityName.equals("OLBTransaction") || entityName.equals("OLBStatus"))) {
            requestParameters.put("entityid", rid.toString());
        }
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareFindByLevel(T entity) throws FMSException {
        Class objectClass = entity.getClass();
        Object level = null;
        try {
            Method m = objectClass.getMethod("getLevel", new Class[0]);
            level = m.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new FMSException("Unable to read the method getId", e);
        }
        if (level == null) {
            throw new FMSException("level is required.");
        }
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.GET.toString());
        requestParameters.put("level", level.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareFindByParentId(T entity) throws FMSException {
        Class objectClass = entity.getClass();
        Object parentRef = null;
        Object parentId = null;
        try {
            Method m = objectClass.getMethod("getParentRef", new Class[0]);
            parentRef = m.invoke(entity, new Object[0]);
            Class<?> parentClass = parentRef.getClass();
            m = parentClass.getMethod("getValue", new Class[0]);
            parentId = m.invoke(parentRef, new Object[0]);
        }
        catch (Exception e) {
            throw new FMSException("Unable to read the method getId", e);
        }
        if (parentId == null) {
            throw new FMSException("parentId is required.");
        }
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.GET.toString());
        requestParameters.put("parentid", parentId.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareEntitlementsRequest() throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.GET.toString());
        requestElements.setContext(this.context);
        intuitMessage.setEntitlementService(true);
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareVoidRequest(T entity) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        requestParameters.put("include", OperationType.VOID.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        requestElements.setObjectToSerialize(this.getSerializableObject(entity));
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareUpload(T entity, InputStream docContent, String boundaryId) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        UploadRequestElements uploadRequestElements = requestElements.getUploadRequestElements();
        uploadRequestElements.setDocContent(docContent);
        uploadRequestElements.setBoundaryId(this.utilizeIf(boundaryId));
        uploadRequestElements.setElementsId(this.generateId().substring(0, 5));
        requestElements.setAction(OperationType.UPLOAD.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        requestElements.setObjectToSerialize(this.getSerializableObject(entity));
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareUpload(T entity, InputStream docContent) throws FMSException {
        return this.prepareUpload(entity, docContent, null);
    }

    private String utilizeIf(String id) {
        return null == id ? this.generateId() : id;
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }

    private <T extends IEntity> IntuitMessage prepareDownload(T entity) throws FMSException {
        Object rid = this.verifyEntityId(entity);
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.GET.toString());
        requestParameters.put("entityid", rid.toString());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        requestElements.setAction(OperationType.DOWNLOAD.toString());
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareDownloadPDF(T entity) throws FMSException {
        Object rid = this.verifyEntityId(entity);
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.GET.toString());
        requestParameters.put("entityid", rid.toString());
        requestParameters.put("selector", ContentTypes.PDF.name().toLowerCase());
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        return intuitMessage;
    }

    private <T extends IEntity> Object verifyEntityId(T entity) throws FMSException {
        Class objectClass = entity.getClass();
        Object rid = null;
        try {
            Method m = objectClass.getMethod("getId", new Class[0]);
            rid = m.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new FMSException("Unable to read the method getId", e);
        }
        if (rid == null) {
            throw new FMSException("Id is required.");
        }
        return rid;
    }

    private <T extends IEntity> boolean verifyEntity(T entity) throws FMSException {
        List<Object> entityList = MessageUtils.getWhitelistedEntities();
        if (entityList.contains(entity.getClass())) {
            return true;
        }
        throw new FMSException("Invalid Entity");
    }

    private <T extends IEntity> IntuitMessage prepareEmail(T entity, String email) throws FMSException {
        Object rid = this.verifyEntityId(entity);
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        requestParameters.put("entityid", rid.toString());
        requestParameters.put("selector", "send");
        if (null != email && !email.isEmpty()) {
            try {
                InternetAddress internetAddress = new InternetAddress(email);
                internetAddress.validate();
            }
            catch (AddressException e) {
                throw new FMSException("Email address \"" + email + "\" is not valid address according to  RFC 822.\n" + e.getMessage());
            }
            requestParameters.put("sendTo", email);
        }
        requestElements.setContext(this.context);
        requestElements.setEntity(entity);
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareQuery(String query) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        if (query.length() > 200) {
            requestParameters.put("method_type", MethodType.POST.toString());
            requestElements.setPostString(query);
        } else {
            requestParameters.put("method_type", MethodType.GET.toString());
            requestParameters.put("query", query);
        }
        requestElements.setAction(OperationType.QUERY.toString());
        requestElements.setContext(this.context);
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareCDCQuery(List<? extends IEntity> entities, String changedSince) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.GET.toString());
        if (entities != null) {
            StringBuffer entityParam = new StringBuffer();
            for (IEntity iEntity : entities) {
                entityParam.append(iEntity.getClass().getSimpleName()).append(",");
            }
            entityParam.delete(entityParam.length() - 1, entityParam.length());
            requestParameters.put("entities", entityParam.toString());
        }
        String cdcChangedSinceParam = null;
        String cdcAction = null;
        cdcChangedSinceParam = "changedSince";
        cdcAction = OperationType.CDCQUERY.toString();
        if (StringUtils.hasText(changedSince)) {
            requestParameters.put(cdcChangedSinceParam, changedSince);
        }
        requestElements.setAction(cdcAction);
        requestElements.setContext(this.context);
        return intuitMessage;
    }

    private <T extends IEntity> IntuitMessage prepareBatch(BatchOperation batchOperation) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.POST.toString());
        IntuitBatchRequest intuitBatchRequest = new IntuitBatchRequest();
        intuitBatchRequest.setBatchItemRequest(batchOperation.getBatchItemRequests());
        requestElements.setAction(OperationType.BATCH.toString());
        requestElements.setContext(this.context);
        requestElements.setObjectToSerialize(this.getSerializableRequestObject(intuitBatchRequest));
        requestElements.setBatchOperation(batchOperation);
        return intuitMessage;
    }

    protected <T extends IEntity> Object getSerializableObject(T object) throws FMSException {
        Class objectClass = object.getClass();
        String methodName = "create".concat(objectClass.getSimpleName());
        ObjectFactory objectEntity = new ObjectFactory();
        Class<?> objectEntityClass = objectEntity.getClass();
        Method method = null;
        try {
            method = objectEntityClass.getMethod(methodName, Class.forName(objectClass.getName()));
        }
        catch (Exception e) {
            LOG.error("Exception while prepare the method signature using reflection to generate JAXBElement", (Throwable)e);
            throw new FMSException("Exception while prepare the method signature using reflection to generate JAXBElement", e);
        }
        JAXBElement jaxbElement = null;
        try {
            jaxbElement = (JAXBElement)method.invoke((Object)objectEntity, object);
        }
        catch (Exception e) {
            LOG.error("Exception while invoking the method using reflection to generate JAXBElement", (Throwable)e);
            throw new FMSException("Exception while prepare the method signature using reflection to generate JAXBElement", e);
        }
        return jaxbElement;
    }

    protected <T> Object getSerializableRequestObject(T object) throws FMSException {
        Class<?> objectClass = object.getClass();
        String methodName = "create".concat(objectClass.getSimpleName());
        ObjectFactory objectEntity = new ObjectFactory();
        Class<?> objectEntityClass = objectEntity.getClass();
        Method method = null;
        try {
            method = objectEntityClass.getMethod(methodName, Class.forName(objectClass.getName()));
        }
        catch (Exception e) {
            LOG.error("Exception while prepare the method signature using reflection to generate JAXBElement", (Throwable)e);
            throw new FMSException("Exception while prepare the method signature using reflection to generate JAXBElement", e);
        }
        JAXBElement jaxbElement = null;
        try {
            jaxbElement = (JAXBElement)method.invoke((Object)objectEntity, object);
        }
        catch (Exception e) {
            LOG.error("Exception while invoking the method using reflection to generate JAXBElement", (Throwable)e);
            throw new FMSException("Exception while prepare the method signature using reflection to generate JAXBElement", e);
        }
        return jaxbElement;
    }

    private <T extends IEntity> List<T> getEntities(QueryResponse queryResponse) {
        ArrayList<IEntity> entityList = new ArrayList<IEntity>();
        List intuitObjectsList = queryResponse.getIntuitObject();
        if (intuitObjectsList != null && !intuitObjectsList.isEmpty()) {
            for (JAXBElement intuitObject : intuitObjectsList) {
                entityList.add((IEntity)intuitObject.getValue());
            }
        }
        return entityList;
    }

    protected QueryResult getQueryResult(QueryResponse queryResponse) {
        QueryResult queryResult = null;
        if (queryResponse != null) {
            queryResult = new QueryResult();
            queryResult.setEntities(this.getEntities(queryResponse));
            queryResult.setFault(queryResponse.getFault());
            queryResult.setMaxResults(queryResponse.getMaxResults());
            queryResult.setStartPosition(queryResponse.getStartPosition());
            queryResult.setTotalCount(queryResponse.getTotalCount());
        }
        return queryResult;
    }

    protected List<CDCQueryResult> getCDCQueryResult(List<CDCResponse> cdcResponses) {
        ArrayList<CDCQueryResult> cdcQueryResults = null;
        if (cdcResponses != null) {
            Iterator<CDCResponse> cdcResponseItr = cdcResponses.iterator();
            while (cdcResponseItr.hasNext()) {
                cdcQueryResults = new ArrayList<CDCQueryResult>();
                CDCQueryResult cdcQueryResult = this.getCDCQueryResult(cdcResponseItr.next());
                cdcQueryResults.add(cdcQueryResult);
            }
        }
        return cdcQueryResults;
    }

    protected CDCQueryResult getCDCQueryResult(CDCResponse cdcResponse) {
        CDCQueryResult cdcQueryResult = new CDCQueryResult();
        List queryResponses = cdcResponse.getQueryResponse();
        if (queryResponses != null) {
            HashMap<String, QueryResult> queryResults = new HashMap<String, QueryResult>();
            for (QueryResponse queryResponse : queryResponses) {
                QueryResult queryResult = this.getQueryResult(queryResponse);
                this.populateQueryResultsInCDC(queryResults, queryResult);
                this.populateFaultInCDC(cdcQueryResult, queryResult);
            }
            if (queryResults != null && !queryResults.isEmpty()) {
                cdcQueryResult.setQueryResults(queryResults);
                cdcQueryResult.setSize(cdcResponse.getSize());
            }
        } else if (cdcResponse.getFault() != null) {
            cdcQueryResult.setFalut(cdcResponse.getFault());
        }
        return cdcQueryResult;
    }

    private void populateQueryResultsInCDC(Map<String, QueryResult> queryResults, QueryResult queryResult) {
        List<? extends IEntity> entities;
        if (queryResult != null && (entities = queryResult.getEntities()) != null && !entities.isEmpty()) {
            IEntity entity = entities.get(0);
            String entityName = entity.getClass().getSimpleName();
            queryResults.put(entityName, queryResult);
        }
    }

    private void populateFaultInCDC(CDCQueryResult cdcQueryResult, QueryResult queryResult) {
        Fault fault;
        if (queryResult != null && (fault = queryResult.getFault()) != null) {
            cdcQueryResult.setFalut(fault);
        }
    }
}

