/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.intuit.oauth2.config.Environment;
import com.intuit.oauth2.config.Scope;
import com.intuit.oauth2.data.OAuthMigrationRequest;
import com.intuit.oauth2.data.OAuthMigrationResponse;
import com.intuit.oauth2.exception.ConnectionException;
import com.intuit.oauth2.http.HttpRequestClient;
import com.intuit.oauth2.http.MethodType;
import com.intuit.oauth2.http.Request;
import com.intuit.oauth2.http.Response;
import com.intuit.oauth2.utils.LoggerImpl;
import com.intuit.oauth2.utils.MapperImpl;
import com.intuit.oauth2.utils.PropertiesConfig;
import org.json.JSONObject;
import org.slf4j.Logger;

public class OAuthMigrationClient {
    private OAuthMigrationRequest oAuthMigrationRequest;
    private static final Logger logger = LoggerImpl.getInstance();
    private static final ObjectMapper mapper = MapperImpl.getInstance();

    public OAuthMigrationClient(OAuthMigrationRequest request) {
        this.oAuthMigrationRequest = request;
    }

    protected OAuthMigrationClient() {
    }

    public OAuthMigrationResponse migrate() throws ConnectionException {
        logger.debug("Enter OAuthMigrationClient::migrate");
        try {
            HttpRequestClient client = new HttpRequestClient(this.oAuthMigrationRequest.getOauth2config().getProxyConfig());
            String requestjson = new JSONObject().put("scope", this.getScopeValue(this.oAuthMigrationRequest.getScope())).put("redirect_uri", this.getRedirectUrl()).put("client_id", this.oAuthMigrationRequest.getOauth2config().getClientId()).put("client_secret", this.oAuthMigrationRequest.getOauth2config().getClientSecret()).toString();
            Request request = new Request.RequestBuilder(MethodType.GET, OAuthMigrationClient.getMigrationAPIUrl(this.oAuthMigrationRequest.getEnvironment())).requiresAuthentication(true).postJson(requestjson).build();
            Response response = client.makeJsonRequest(request, this.oAuthMigrationRequest);
            logger.debug("Response Code : " + response.getStatusCode());
            if (response.getStatusCode() == 200) {
                ObjectReader reader = mapper.readerFor(OAuthMigrationResponse.class);
                OAuthMigrationResponse oAuthMigrationResponse = (OAuthMigrationResponse)reader.readValue(response.getContent());
                return oAuthMigrationResponse;
            }
            logger.debug("failed calling migrate API");
            throw new ConnectionException("failed calling migrate API", response.getStatusCode() + "");
        }
        catch (Exception ex) {
            logger.error("Exception while calling migrate", ex);
            throw new ConnectionException(ex.getMessage(), ex);
        }
    }

    private static String getMigrationAPIUrl(Environment environment) {
        return PropertiesConfig.getInstance().getProperty("OAUTH_MIGRATION_URL_" + environment.value());
    }

    public String getScopeValue(Scope scope) {
        return PropertiesConfig.getInstance().getProperty(scope.value());
    }

    public String getRedirectUrl() {
        String url = PropertiesConfig.getInstance().getProperty("REDIRECT_URL");
        return this.oAuthMigrationRequest.getRedirectUri() == null || this.oAuthMigrationRequest.getRedirectUri().isEmpty() ? url : this.oAuthMigrationRequest.getRedirectUri();
    }
}

