/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.intuit.oauth2.config.Environment;
import com.intuit.oauth2.config.ProxyConfig;
import com.intuit.oauth2.data.DiscoveryAPIResponse;
import com.intuit.oauth2.exception.ConnectionException;
import com.intuit.oauth2.http.HttpRequestClient;
import com.intuit.oauth2.http.MethodType;
import com.intuit.oauth2.http.Request;
import com.intuit.oauth2.http.Response;
import com.intuit.oauth2.utils.LoggerImpl;
import com.intuit.oauth2.utils.MapperImpl;
import com.intuit.oauth2.utils.PropertiesConfig;
import org.slf4j.Logger;

public class DiscoveryAPIClient {
    private ObjectMapper mapper = MapperImpl.getInstance();
    private static final Logger logger = LoggerImpl.getInstance();
    private ProxyConfig proxyConfig;

    public DiscoveryAPIClient(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public DiscoveryAPIClient() {
        this.proxyConfig = null;
    }

    public DiscoveryAPIResponse callDiscoveryAPI(Environment environment) throws ConnectionException {
        logger.debug("Enter DiscoveryAPIClient::callDiscoveryAPI");
        try {
            HttpRequestClient client = new HttpRequestClient(this.proxyConfig);
            Request request = new Request.RequestBuilder(MethodType.GET, DiscoveryAPIClient.getDiscoveryAPIHost(environment)).requiresAuthentication(false).build();
            Response response = client.makeRequest(request);
            logger.debug("Response Code : " + response.getStatusCode());
            logger.debug("intuit_tid : " + response.getIntuit_tid());
            if (response.getStatusCode() == 200) {
                ObjectReader reader = this.mapper.readerFor(DiscoveryAPIResponse.class);
                DiscoveryAPIResponse discoveryAPIResponse = (DiscoveryAPIResponse)reader.readValue(response.getContent());
                discoveryAPIResponse.setIntuit_tid(response.getIntuit_tid());
                return discoveryAPIResponse;
            }
            logger.debug("failed calling discovery document API");
            logger.debug("Response content: " + response.getContent());
            throw new ConnectionException("Failed calling discovery document API", response.getStatusCode() + "", response.getIntuit_tid(), response);
        }
        catch (ConnectionException ex) {
            logger.error("ConnectionException while calling discovery document " + ex.getResponseContent() + ex.getResponseContent(), ex);
            throw new ConnectionException("Failed calling discovery document API", ex.getStatusCode() + "", ex.getIntuit_tid(), ex.getResponse());
        }
        catch (Exception ex) {
            logger.error("Exception while calling discovery document", ex);
            throw new ConnectionException(ex.getMessage(), ex);
        }
    }

    public DiscoveryAPIResponse callDiscoveryAPI(String discoveryEndpoint) throws ConnectionException {
        logger.debug("Enter DiscoveryAPIClient::callDiscoveryAPI");
        try {
            HttpRequestClient client = new HttpRequestClient(this.proxyConfig);
            Request request = new Request.RequestBuilder(MethodType.GET, discoveryEndpoint).requiresAuthentication(false).build();
            Response response = client.makeRequest(request);
            logger.debug("Response Code : " + response.getStatusCode());
            logger.debug("intuit_tid : " + response.getIntuit_tid());
            if (response.getStatusCode() == 200) {
                ObjectReader reader = this.mapper.readerFor(DiscoveryAPIResponse.class);
                DiscoveryAPIResponse discoveryAPIResponse = (DiscoveryAPIResponse)reader.readValue(response.getContent());
                discoveryAPIResponse.setIntuit_tid(response.getIntuit_tid());
                return discoveryAPIResponse;
            }
            logger.debug("failed calling discovery document API");
            logger.debug("Response content: " + response.getContent());
            throw new ConnectionException("Failed calling discovery document API", response.getStatusCode() + "", response.getIntuit_tid(), response);
        }
        catch (ConnectionException ex) {
            logger.error("ConnectionException while calling discovery document: " + ex.getResponseContent(), ex);
            throw new ConnectionException("Failed calling discovery document API", ex.getStatusCode() + "", ex.getIntuit_tid(), ex.getResponse());
        }
        catch (Exception ex) {
            logger.error("Exception while calling discovery document", ex);
            throw new ConnectionException(ex.getMessage(), ex);
        }
    }

    private static String getDiscoveryAPIHost(Environment environment) {
        return PropertiesConfig.getInstance().getProperty("DISCOVERY_API_HOST_" + environment.value());
    }
}

