/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.config;

import com.intuit.oauth2.client.DiscoveryAPIClient;
import com.intuit.oauth2.config.Environment;
import com.intuit.oauth2.config.ProxyConfig;
import com.intuit.oauth2.config.Scope;
import com.intuit.oauth2.data.DiscoveryAPIResponse;
import com.intuit.oauth2.exception.ConnectionException;
import com.intuit.oauth2.exception.InvalidRequestException;
import com.intuit.oauth2.utils.LoggerImpl;
import com.intuit.oauth2.utils.PropertiesConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class OAuth2Config {
    private String clientId;
    private String clientSecret;
    private String intuitIdTokenIssuer;
    private String intuitAuthorizationEndpoint;
    private String intuitBearerTokenEndpoint;
    private String intuitRevokeTokenEndpoint;
    private String intuitJwksURI;
    private String userProfileEndpoint;
    private ProxyConfig proxyConfig;
    private static final Logger logger = LoggerImpl.getInstance();

    private OAuth2Config(OAuth2ConfigBuilder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.intuitIdTokenIssuer = builder.intuitIdTokenIssuer;
        this.intuitAuthorizationEndpoint = builder.intuitAuthorizationEndpoint;
        this.intuitBearerTokenEndpoint = builder.intuitBearerTokenEndpoint;
        this.intuitRevokeTokenEndpoint = builder.intuitRevokeTokenEndpoint;
        this.intuitJwksURI = builder.intuitJwksURI;
        this.userProfileEndpoint = builder.userProfileEndpoint;
        this.proxyConfig = builder.proxyConfig;
    }

    public String getIntuitIdTokenIssuer() {
        return this.intuitIdTokenIssuer;
    }

    public String getIntuitAuthorizationEndpoint() {
        return this.intuitAuthorizationEndpoint;
    }

    public String getIntuitBearerTokenEndpoint() {
        return this.intuitBearerTokenEndpoint;
    }

    public String getIntuitRevokeTokenEndpoint() {
        return this.intuitRevokeTokenEndpoint;
    }

    public String getIntuitJwksURI() {
        return this.intuitJwksURI;
    }

    public String getUserProfileEndpoint() {
        return this.userProfileEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setIntuitAuthorizationEndpoint(String intuitAuthorizationEndpoint) {
        this.intuitAuthorizationEndpoint = intuitAuthorizationEndpoint;
    }

    public void setIntuitBearerTokenEndpoint(String intuitBearerTokenEndpoint) {
        this.intuitBearerTokenEndpoint = intuitBearerTokenEndpoint;
    }

    public void setIntuitRevokeTokenEndpoint(String intuitRevokeTokenEndpoint) {
        this.intuitRevokeTokenEndpoint = intuitRevokeTokenEndpoint;
    }

    public void setUserProfileEndpoint(String userProfileEndpoint) {
        this.userProfileEndpoint = userProfileEndpoint;
    }

    public void setIntuitIdTokenIssuer(String intuitIdTokenIssuer) {
        this.intuitIdTokenIssuer = intuitIdTokenIssuer;
    }

    public void setIntuitJwksURI(String intuitJwksURI) {
        this.intuitJwksURI = intuitJwksURI;
    }

    public String getScopeValue(Scope scope) {
        logger.debug("Enter OAuth2config::getDefaultScope");
        return PropertiesConfig.getInstance().getProperty(scope.value());
    }

    public String generateCSRFToken() {
        logger.debug("Enter OAuth2config::generateCSRFToken");
        return UUID.randomUUID().toString();
    }

    public String prepareUrl(List<Scope> scopes, String redirectUri, String csrfToken) throws InvalidRequestException {
        logger.debug("Enter OAuth2config::prepareUrl");
        if (scopes == null || scopes.isEmpty() || redirectUri.isEmpty() || csrfToken.isEmpty()) {
            logger.error("Invalid request for prepareUrl ");
            throw new InvalidRequestException("Invalid request for prepareUrl");
        }
        try {
            return this.intuitAuthorizationEndpoint + "?client_id=" + this.clientId + "&response_type=code&scope=" + URLEncoder.encode(this.buildScopeString(scopes), "UTF-8") + "&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&state=" + csrfToken;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Exception while preparing url for redirect ", e);
            throw new InvalidRequestException(e.getMessage(), e);
        }
    }

    private String buildScopeString(List<Scope> scopes) {
        StringBuilder sb = new StringBuilder();
        for (Scope scope : scopes) {
            sb.append(this.getScopeValue(scope) + " ");
        }
        return StringUtils.stripEnd(sb.toString(), " ");
    }

    private String buildScope(List<String> scopes) {
        StringBuilder sb = new StringBuilder();
        for (String scope : scopes) {
            sb.append(scope + " ");
        }
        return StringUtils.stripEnd(sb.toString(), " ");
    }

    public String prepareUrl(List<Scope> scopes, String redirectUri) throws InvalidRequestException {
        logger.debug("Enter OAuth2config::prepareUrl");
        if (scopes == null || scopes.isEmpty() || redirectUri.isEmpty()) {
            logger.error("Invalid request for prepareUrl ");
            throw new InvalidRequestException("Invalid request for prepareUrl");
        }
        try {
            return this.intuitAuthorizationEndpoint + "?client_id=" + this.clientId + "&response_type=code&scope=" + URLEncoder.encode(this.buildScopeString(scopes), "UTF-8") + "&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&state=" + this.generateCSRFToken();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Exception while preparing url for redirect ", e);
            throw new InvalidRequestException(e.getMessage(), e);
        }
    }

    public String prepareUrlWithCustomScopes(List<String> scopes, String redirectUri) throws InvalidRequestException {
        logger.debug("Enter OAuth2config::prepareUrl");
        if (scopes == null || scopes.isEmpty() || redirectUri.isEmpty()) {
            logger.error("Invalid request for prepareUrl ");
            throw new InvalidRequestException("Invalid request for prepareUrl");
        }
        try {
            return this.intuitAuthorizationEndpoint + "?client_id=" + this.clientId + "&response_type=code&scope=" + this.buildScope(scopes) + "&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&state=" + this.generateCSRFToken();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Exception while preparing url for redirect ", e);
            throw new InvalidRequestException(e.getMessage(), e);
        }
    }

    public String prepareUrlWithCustomScopes(List<String> scopes, String redirectUri, String csrfToken) throws InvalidRequestException {
        logger.debug("Enter OAuth2config::prepareUrl");
        if (scopes == null || scopes.isEmpty() || redirectUri.isEmpty()) {
            logger.error("Invalid request for prepareUrl ");
            throw new InvalidRequestException("Invalid request for prepareUrl");
        }
        try {
            return this.intuitAuthorizationEndpoint + "?client_id=" + this.clientId + "&response_type=code&scope=" + this.buildScope(scopes) + "&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&state=" + csrfToken;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Exception while preparing url for redirect ", e);
            throw new InvalidRequestException(e.getMessage(), e);
        }
    }

    public static class OAuth2ConfigBuilder {
        private String clientId;
        private String clientSecret;
        private String intuitIdTokenIssuer;
        private String intuitAuthorizationEndpoint;
        private String intuitBearerTokenEndpoint;
        private String intuitRevokeTokenEndpoint;
        private String intuitJwksURI;
        private String userProfileEndpoint;
        private String intuit_tid;
        private String statusCode;
        private String errorMessage;
        private ProxyConfig proxyConfig;

        public OAuth2ConfigBuilder(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        private void setFields(DiscoveryAPIResponse discoveryAPIResponse) {
            this.intuitIdTokenIssuer = discoveryAPIResponse.getIssuer();
            this.intuitAuthorizationEndpoint = discoveryAPIResponse.getAuthorizationEndpoint();
            this.intuitBearerTokenEndpoint = discoveryAPIResponse.getTokenEndpoint();
            this.intuitRevokeTokenEndpoint = discoveryAPIResponse.getRevocationEndpoint();
            this.intuitJwksURI = discoveryAPIResponse.getJwksUri();
            this.userProfileEndpoint = discoveryAPIResponse.getUserinfoEndpoint();
        }

        public OAuth2ConfigBuilder callDiscoveryAPI(Environment environment) {
            try {
                DiscoveryAPIResponse discoveryAPIResponse = new DiscoveryAPIClient(this.proxyConfig).callDiscoveryAPI(environment);
                if (discoveryAPIResponse != null) {
                    this.setFields(discoveryAPIResponse);
                }
            }
            catch (ConnectionException e) {
                logger.error("Exception while preparing url for redirect ", e);
                this.intuit_tid = e.getIntuit_tid();
                this.statusCode = e.getStatusCode();
                this.errorMessage = e.getErrorMessage();
            }
            return this;
        }

        public OAuth2ConfigBuilder callDiscoveryAPI(String discoveryEndpoint) {
            try {
                DiscoveryAPIResponse discoveryAPIResponse = new DiscoveryAPIClient(this.proxyConfig).callDiscoveryAPI(discoveryEndpoint);
                if (discoveryAPIResponse != null) {
                    this.setFields(discoveryAPIResponse);
                }
            }
            catch (ConnectionException e) {
                logger.error("Exception while preparing url for redirect ", e);
                this.intuit_tid = e.getIntuit_tid();
                this.statusCode = e.getStatusCode();
                this.errorMessage = e.getErrorMessage();
            }
            return this;
        }

        public OAuth2ConfigBuilder proxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public OAuth2Config buildConfig() {
            return new OAuth2Config(this);
        }
    }
}

