/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.exception;

import com.intuit.oauth2.http.Response;

public abstract class PlatformException
extends Exception {
    private static final long serialVersionUID = 2159710893546789727L;
    private String errorMessage;
    private String errorCode;
    private String statusCode;
    private String intuit_tid;
    private String responseContent;
    private Response response;

    public PlatformException(String errorMessage, String errorCode) {
        super(errorMessage);
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    public PlatformException(String errorMessage) {
        super(errorMessage);
        this.errorMessage = errorMessage;
    }

    public PlatformException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.errorMessage = errorMessage;
    }

    public PlatformException(String errorMessage, String statusCode, String intuit_tid, Response response) {
        super(errorMessage);
        this.errorMessage = errorMessage;
        this.statusCode = statusCode;
        this.intuit_tid = intuit_tid;
        try {
            this.responseContent = response.getContent();
        }
        catch (Exception e) {
            this.responseContent = "";
        }
        this.response = response;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getIntuit_tid() {
        return this.intuit_tid;
    }

    public void setIntuit_tid(String intuit_tid) {
        this.intuit_tid = intuit_tid;
    }

    public String getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    @Override
    public String toString() {
        return "Error Code: " + this.errorCode + ", Error Message: " + this.errorMessage + ", Response Content: " + this.responseContent;
    }
}

