/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.inversoft.json.LocalDateDeserializer;
import com.inversoft.json.LocalDateSerializer;
import com.inversoft.json.LocaleDeserializer;
import com.inversoft.json.LocaleSerializer;
import com.inversoft.json.ZoneIdDeserializer;
import com.inversoft.json.ZoneIdSerializer;
import com.inversoft.json.ZonedDateTimeDeserializer;
import com.inversoft.json.ZonedDateTimeSerializer;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;

public class JacksonModule
extends SimpleModule {
    private static final Version VERSION = VersionUtil.parseVersion((String)"0.22", (String)"org.primeframework.mvc", (String)"prime-jackson-module");

    public JacksonModule() {
        super(VERSION);
        this.addDeserializer(Locale.class, (JsonDeserializer)new LocaleDeserializer());
        this.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        this.addDeserializer(LocalDate.class, new LocalDateDeserializer());
        this.addDeserializer(ZoneId.class, new ZoneIdDeserializer());
        this.addSerializer(Locale.class, (JsonSerializer)new LocaleSerializer());
        this.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer());
        this.addSerializer(LocalDate.class, new LocalDateSerializer());
        this.addSerializer(ZoneId.class, new ZoneIdSerializer());
    }
}

