/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.inversoft.json.JacksonModule;
import java.util.Set;

public class ToString {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void setJacksonModules(Set<Module> jacksonModules) {
        if (jacksonModules.size() > 0) {
            objectMapper.registerModules(jacksonModules);
        }
    }

    public static String toJSONString(Object o) {
        try {
            return objectMapper.writer().without(SerializationFeature.INDENT_OUTPUT).writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(Object o) {
        try {
            return objectMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JacksonModule());
    }
}

