/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.jwt.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.primeframework.jwt.domain.InvalidJWTException;
import org.primeframework.jwt.json.JacksonModule;

public class Mapper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T deserialize(byte[] bytes, Class<T> type) throws InvalidJWTException {
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, type);
        }
        catch (IOException e) {
            throw new InvalidJWTException("The JWT could not be de-serialized.", e);
        }
    }

    public static byte[] serialize(Object object) throws InvalidJWTException {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new InvalidJWTException("The JWT could not be serialized..", e);
        }
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false).configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false).registerModule((Module)new JacksonModule());
    }
}

