/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.jwt;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.primeframework.jwt.Verifier;
import org.primeframework.jwt.domain.Algorithm;
import org.primeframework.jwt.domain.Header;
import org.primeframework.jwt.domain.InvalidJWTException;
import org.primeframework.jwt.domain.InvalidJWTSignatureException;
import org.primeframework.jwt.domain.JWT;
import org.primeframework.jwt.domain.JWTExpiredException;
import org.primeframework.jwt.domain.JWTUnavailableForProcessingException;
import org.primeframework.jwt.domain.MissingVerifierException;
import org.primeframework.jwt.json.Mapper;

public class JWTDecoder {
    private static JWTDecoder instance;

    public static JWTDecoder getInstance() {
        if (instance == null) {
            instance = new JWTDecoder();
        }
        return instance;
    }

    public JWT decode(String encodedJWT, Verifier ... verifiers) {
        Objects.requireNonNull(encodedJWT);
        Objects.requireNonNull(verifiers);
        String[] parts = this.getParts(encodedJWT);
        Header header = Mapper.deserialize(this.base64Decode(parts[0].getBytes(StandardCharsets.UTF_8)), Header.class);
        if (parts.length == 2 && verifiers.length == 0) {
            if (header.algorithm == Algorithm.none) {
                return Mapper.deserialize(this.base64Decode(parts[1].getBytes(StandardCharsets.UTF_8)), JWT.class);
            }
            throw new InvalidJWTSignatureException();
        }
        Verifier verifier = null;
        for (Verifier v : verifiers) {
            if (!v.canVerify(header.algorithm)) continue;
            verifier = v;
        }
        return this.decode(encodedJWT, header, parts, verifier);
    }

    public JWT decode(String encodedJWT, Map<String, Verifier> verifiers) {
        return this.decode(encodedJWT, verifiers, (Header h) -> h.get("kid"));
    }

    public JWT decode(String encodedJWT, Map<String, Verifier> verifiers, Function<Header, String> keyFunction) {
        Objects.requireNonNull(encodedJWT);
        Objects.requireNonNull(verifiers);
        String[] parts = this.getParts(encodedJWT);
        Header header = Mapper.deserialize(this.base64Decode(parts[0].getBytes(StandardCharsets.UTF_8)), Header.class);
        if (parts.length == 2 && verifiers.isEmpty()) {
            if (header.algorithm == Algorithm.none) {
                return Mapper.deserialize(this.base64Decode(parts[1].getBytes(StandardCharsets.UTF_8)), JWT.class);
            }
            throw new InvalidJWTSignatureException();
        }
        String key = keyFunction.apply(header);
        Verifier verifier = verifiers.get(key);
        if (verifier != null && !verifier.canVerify(header.algorithm)) {
            verifier = null;
        }
        return this.decode(encodedJWT, header, parts, verifier);
    }

    private byte[] base64Decode(byte[] bytes) {
        try {
            return Base64.getUrlDecoder().decode(bytes);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidJWTException("The encoded JWT is not properly Base64 encoded.", e);
        }
    }

    private JWT decode(String encodedJWT, Header header, String[] parts, Verifier verifier) {
        JWT jwt;
        int index = encodedJWT.lastIndexOf(".");
        byte[] message = encodedJWT.substring(0, index).getBytes(StandardCharsets.UTF_8);
        if (parts.length == 3 && verifier == null) {
            throw new MissingVerifierException("No Verifier has been provided for verify a signature signed using [" + header.algorithm.getName() + "]");
        }
        if (parts.length == 2 && verifier != null) {
            throw new InvalidJWTSignatureException();
        }
        if (parts.length == 3) {
            byte[] signature = this.base64Decode(parts[2].getBytes(StandardCharsets.UTF_8));
            verifier.verify(header.algorithm, message, signature);
        }
        if ((jwt = Mapper.deserialize(this.base64Decode(parts[1].getBytes(StandardCharsets.UTF_8)), JWT.class)).isExpired()) {
            throw new JWTExpiredException();
        }
        if (jwt.isUnavailableForProcessing()) {
            throw new JWTUnavailableForProcessingException();
        }
        return jwt;
    }

    private String[] getParts(String encodedJWT) {
        String[] parts = encodedJWT.split("\\.");
        if (parts.length == 3 || parts.length == 2 && encodedJWT.endsWith(".")) {
            return parts;
        }
        throw new InvalidJWTException("The encoded JWT is not properly formatted. Expected a three part dot separated string.");
    }
}

