/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.inversoft.rest.RESTClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

public class InputStreamBodyHandler
implements RESTClient.BodyHandler {
    public String contentType;
    public Long length;
    public InputStream request;

    public InputStreamBodyHandler(String contentType, InputStream request) {
        this.contentType = contentType;
        this.request = request;
    }

    public InputStreamBodyHandler(String contentType, Long length, InputStream request) {
        this.contentType = contentType;
        this.length = length;
        this.request = request;
    }

    @Override
    public void accept(OutputStream os) throws IOException {
        if (this.request != null) {
            int read;
            byte[] buf = new byte[1024];
            while ((read = this.request.read(buf)) != -1) {
                os.write(buf, 0, read);
            }
            os.flush();
        }
    }

    @Override
    public byte[] getBody() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getBodyObject() {
        return this.request;
    }

    @Override
    public void setHeaders(HttpURLConnection huc) {
        if (this.contentType != null) {
            huc.addRequestProperty("Content-Type", this.contentType);
        }
        if (this.length != null) {
            huc.addRequestProperty("Content-Length", "" + this.length);
        }
    }
}

