/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.inversoft.net.ssl.SSLTools;
import com.inversoft.rest.ClientResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTClient<RS, ERS> {
    private static final Logger logger = LoggerFactory.getLogger(RESTClient.class);
    public final Map<String, String> headers = new HashMap<String, String>();
    public final Map<String, List<Object>> parameters = new LinkedHashMap<String, List<Object>>();
    public final StringBuilder url = new StringBuilder();
    public BodyHandler bodyHandler;
    public String certificate;
    public int connectTimeout = 2000;
    public ResponseHandler<ERS> errorResponseHandler;
    public Class<ERS> errorType;
    public String key;
    public HTTPMethod method;
    public int readTimeout = 2000;
    public ResponseHandler<RS> successResponseHandler;
    public Class<RS> successType;
    public String userAgent = "Restify (https://github.com/inversoft/restify)";

    public RESTClient(Class<RS> successType, Class<ERS> errorType) {
        if (successType == Void.class || errorType == Void.class) {
            throw new IllegalArgumentException("Void.class isn't valid. Use Void.TYPE instead.");
        }
        this.successType = successType;
        this.errorType = errorType;
    }

    public RESTClient<RS, ERS> authorization(String key) {
        this.headers.put("Authorization", key);
        return this;
    }

    public RESTClient<RS, ERS> basicAuthorization(String username, String password) {
        if (username != null && password != null) {
            String credentials = username + ":" + password;
            Base64.Encoder encoder = Base64.getEncoder();
            String encoded = encoder.encodeToString(credentials.getBytes());
            this.headers.put("Authorization", "Basic " + encoded);
        }
        return this;
    }

    public RESTClient<RS, ERS> bodyHandler(BodyHandler bodyHandler) {
        this.bodyHandler = bodyHandler;
        return this;
    }

    public RESTClient<RS, ERS> certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    public RESTClient<RS, ERS> connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public RESTClient<RS, ERS> delete() {
        this.method = HTTPMethod.DELETE;
        return this;
    }

    public RESTClient<RS, ERS> errorResponseHandler(ResponseHandler<ERS> errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public RESTClient<RS, ERS> get() {
        this.method = HTTPMethod.GET;
        return this;
    }

    public URI getURI() {
        return URI.create(this.url.toString());
    }

    public ClientResponse<RS, ERS> go() {
        ClientResponse response;
        block61: {
            Throwable throwable;
            InputStream is;
            int status;
            HttpURLConnection huc;
            block60: {
                if (this.url.length() == 0) {
                    throw new IllegalStateException("You must specify a URL");
                }
                Objects.requireNonNull(this.method, "You must specify a HTTP method");
                if (this.successType != Void.TYPE && this.successResponseHandler == null) {
                    throw new IllegalStateException("You specified a success response type, you must then provide a success response handler.");
                }
                if (this.errorType != Void.TYPE && this.errorResponseHandler == null) {
                    throw new IllegalStateException("You specified an error response type, you must then provide an error response handler.");
                }
                response = new ClientResponse();
                response.request = this.bodyHandler != null ? this.bodyHandler.getBodyObject() : null;
                response.method = this.method;
                try {
                    Object entry;
                    if (this.parameters.size() > 0) {
                        if (this.url.indexOf("?") == -1) {
                            this.url.append("?");
                        }
                        Iterator<Map.Entry<String, List<Object>>> i = this.parameters.entrySet().iterator();
                        while (i.hasNext()) {
                            entry = i.next();
                            Iterator<Object> j = entry.getValue().iterator();
                            while (j.hasNext()) {
                                Object value = j.next();
                                this.url.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(value.toString(), "UTF-8"));
                                if (!j.hasNext()) continue;
                                this.url.append("&");
                            }
                            if (!i.hasNext()) continue;
                            this.url.append("&");
                        }
                    }
                    response.url = new URL(this.url.toString());
                    huc = (HttpURLConnection)response.url.openConnection();
                    if (response.url.getProtocol().toLowerCase().equals("https") && this.certificate != null) {
                        HttpsURLConnection hsuc = (HttpsURLConnection)huc;
                        if (this.key != null) {
                            hsuc.setSSLSocketFactory(SSLTools.getSSLServerContext(this.certificate, this.key).getSocketFactory());
                        } else {
                            hsuc.setSSLSocketFactory(SSLTools.getSSLSocketFactory(this.certificate));
                        }
                    }
                    huc.setDoOutput(this.bodyHandler != null);
                    huc.setConnectTimeout(this.connectTimeout);
                    huc.setReadTimeout(this.readTimeout);
                    huc.setRequestMethod(this.method.toString());
                    if (this.headers.keySet().stream().noneMatch(name -> name.equalsIgnoreCase("User-Agent"))) {
                        this.headers.put("User-Agent", this.userAgent);
                    }
                    if (this.headers.size() > 0) {
                        this.headers.forEach(huc::addRequestProperty);
                    }
                    if (this.bodyHandler != null) {
                        this.bodyHandler.setHeaders(huc);
                    }
                    huc.connect();
                    if (this.bodyHandler == null) break block60;
                    OutputStream os = huc.getOutputStream();
                    entry = null;
                    try {
                        this.bodyHandler.accept(os);
                        os.flush();
                    }
                    catch (Throwable throwable2) {
                        entry = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (os != null) {
                            if (entry != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)entry).addSuppressed(throwable3);
                                }
                            } else {
                                os.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug("Error calling REST WebService at [" + this.url + "]", (Throwable)e);
                    response.status = -1;
                    response.exception = e;
                    return response;
                }
            }
            try {
                status = huc.getResponseCode();
            }
            catch (Exception e) {
                logger.debug("Error calling REST WebService at [" + this.url + "]", (Throwable)e);
                response.status = -1;
                response.exception = e;
                return response;
            }
            response.status = status;
            if (status < 200 || status > 299) {
                if (this.errorResponseHandler == null) {
                    return response;
                }
                try {
                    is = huc.getErrorStream();
                    throwable = null;
                    try {
                        response.errorResponse = this.errorResponseHandler.apply(is);
                        break block61;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug("Error calling REST WebService at [" + this.url + "]", (Throwable)e);
                    response.exception = e;
                    return response;
                }
            }
            if (this.successResponseHandler == null || this.method == HTTPMethod.HEAD) {
                return response;
            }
            try {
                is = huc.getInputStream();
                throwable = null;
                try {
                    response.successResponse = this.successResponseHandler.apply(is);
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Error calling REST WebService at [" + this.url + "]", (Throwable)e);
                response.exception = e;
                return response;
            }
        }
        return response;
    }

    public RESTClient<RS, ERS> head() {
        this.method = HTTPMethod.HEAD;
        return this;
    }

    public RESTClient<RS, ERS> header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public RESTClient<RS, ERS> headers(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public RESTClient<RS, ERS> key(String key) {
        this.key = key;
        return this;
    }

    public RESTClient<RS, ERS> post() {
        this.method = HTTPMethod.POST;
        return this;
    }

    public RESTClient<RS, ERS> put() {
        this.method = HTTPMethod.PUT;
        return this;
    }

    public RESTClient<RS, ERS> readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public RESTClient<RS, ERS> successResponseHandler(ResponseHandler<RS> successResponseHandler) {
        this.successResponseHandler = successResponseHandler;
        return this;
    }

    public RESTClient<RS, ERS> uri(String uri) {
        if (this.url.length() == 0) {
            return this;
        }
        if (this.url.charAt(this.url.length() - 1) == '/' && uri.startsWith("/")) {
            this.url.append(uri.substring(1));
        } else if (this.url.charAt(this.url.length() - 1) != '/' && !uri.startsWith("/")) {
            this.url.append("/").append(uri);
        } else {
            this.url.append(uri);
        }
        return this;
    }

    public RESTClient<RS, ERS> url(String url) {
        this.url.delete(0, this.url.length());
        this.url.append(url);
        return this;
    }

    public RESTClient<RS, ERS> urlParameter(String name, Object value) {
        if (value == null) {
            return this;
        }
        List values = this.parameters.computeIfAbsent(name, k -> new ArrayList());
        if (value instanceof ZonedDateTime) {
            values.add(((ZonedDateTime)value).toInstant().toEpochMilli());
        } else if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        return this;
    }

    public RESTClient<RS, ERS> urlSegment(Object value) {
        if (value != null) {
            if (this.url.charAt(this.url.length() - 1) != '/') {
                this.url.append('/');
            }
            this.url.append(value.toString());
        }
        return this;
    }

    public static interface ResponseHandler<T> {
        public T apply(InputStream var1) throws IOException;
    }

    public static interface BodyHandler {
        public void accept(OutputStream var1) throws IOException;

        public byte[] getBody();

        default public Object getBodyObject() {
            return null;
        }

        public void setHeaders(HttpURLConnection var1);
    }

    public static enum HTTPMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD;

    }
}

