/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.net;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class EncodingTools {
    private static final byte[] ATTR_CHAR = new byte[]{33, 35, 36, 38, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 124, 126};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private EncodingTools() {
    }

    public static String escapedQuotedString(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String rfc5987_encode(String s) {
        byte[] s_bytes = s.getBytes(StandardCharsets.UTF_8);
        int len = s_bytes.length;
        StringBuilder sb = new StringBuilder(len << 1);
        for (int i = 0; i < len; ++i) {
            byte b = s_bytes[i];
            if (Arrays.binarySearch(ATTR_CHAR, b) >= 0) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            sb.append(DIGITS[0xF & b >>> 4]);
            sb.append(DIGITS[b & 0xF]);
        }
        return sb.toString();
    }
}

