/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.net.ssl;

import com.inversoft.net.ssl.UnsafeTrustManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class SSLTools {
    public static final String CERT_END = "-----END CERTIFICATE";
    public static final String CERT_START = "BEGIN CERTIFICATE-----";
    public static final String P8_KEY_END = "-----END PRIVATE KEY";
    public static final String P8_KEY_START = "BEGIN PRIVATE KEY-----";
    public static final String PKCS_1_KEY_END = "-----END RSA PRIVATE KEY";
    public static final String PKCS_1_KEY_START = "BEGIN RSA PRIVATE KEY-----";

    public static void disableSSLValidation() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new UnsafeTrustManager()}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void enableSSLValidation() {
        try {
            SSLContext.getInstance("SSL").init(null, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext getSSLServerContext(String certificateString, String keyString) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, InvalidKeySpecException {
        byte[] certBytes = SSLTools.parseDERFromPEM(certificateString, CERT_START, CERT_END);
        byte[] keyBytes = SSLTools.parseDERFromPEM(keyString, P8_KEY_START, P8_KEY_END);
        X509Certificate cert = SSLTools.generateCertificateFromDER(certBytes);
        RSAPrivateKey key = SSLTools.generatePrivateKeyFromPKCS8DER(keyBytes);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", cert);
        keystore.setKeyEntry("key-alias", key, "changeit".toCharArray(), new Certificate[]{cert});
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, "changeit".toCharArray());
        KeyManager[] km = kmf.getKeyManagers();
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(km, null, null);
        return context;
    }

    public static SSLSocketFactory getSSLSocketFactory(String certificateString) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        byte[] certBytes = SSLTools.parseDERFromPEM(certificateString, CERT_START, CERT_END);
        X509Certificate cert = SSLTools.generateCertificateFromDER(certBytes);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", cert);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        TrustManager[] tm = tmf.getTrustManagers();
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, tm, null);
        return context.getSocketFactory();
    }

    public static String signWithRSA(String string, String keyString) throws GeneralSecurityException, IOException {
        try {
            RSAPrivateKey privateKey;
            byte[] bytes;
            if (keyString.contains(PKCS_1_KEY_START)) {
                bytes = SSLTools.parseDERFromPEM(keyString, PKCS_1_KEY_START, PKCS_1_KEY_END);
                privateKey = SSLTools.generatePrivateKeyFromPKCS10DER(bytes);
            } else {
                bytes = SSLTools.parseDERFromPEM(keyString, P8_KEY_START, P8_KEY_END);
                privateKey = SSLTools.generatePrivateKeyFromPKCS8DER(bytes);
            }
            Signature rsa = Signature.getInstance("NONEwithRSA");
            rsa.initSign(privateKey);
            rsa.update(string.getBytes());
            byte[] signed = rsa.sign();
            return new String(Base64.getEncoder().encode(signed));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean validCertificateString(String certificateString) {
        try {
            byte[] certBytes = SSLTools.parseDERFromPEM(certificateString, CERT_START, CERT_END);
            SSLTools.generateCertificateFromDER(certBytes);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static X509Certificate generateCertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    private static RSAPrivateKey generatePrivateKeyFromPKCS10DER(byte[] keyBytes) throws GeneralSecurityException, IOException {
        DerInputStream derReader = new DerInputStream(keyBytes);
        DerValue[] seq = derReader.getSequence(0);
        if (seq.length < 9) {
            throw new GeneralSecurityException("Could not parse a PKCS1 private key.");
        }
        BigInteger modulus = seq[1].getBigInteger();
        BigInteger publicExponent = seq[2].getBigInteger();
        BigInteger privateExponent = seq[3].getBigInteger();
        BigInteger primeP = seq[4].getBigInteger();
        BigInteger primeQ = seq[5].getBigInteger();
        BigInteger primeExponentP = seq[6].getBigInteger();
        BigInteger primeExponentQ = seq[7].getBigInteger();
        BigInteger crtCoefficient = seq[8].getBigInteger();
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(keySpec);
    }

    private static RSAPrivateKey generatePrivateKeyFromPKCS8DER(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    private static byte[] parseDERFromPEM(String pem, String beginDelimiter, String endDelimiter) {
        int startIndex = pem.indexOf(beginDelimiter);
        if (startIndex < 0) {
            throw new IllegalArgumentException("Invalid PEM format");
        }
        int endIndex = pem.indexOf(endDelimiter);
        if (endIndex < 0) {
            throw new IllegalArgumentException("Invalid PEM format");
        }
        String base64 = pem.substring(startIndex + beginDelimiter.length(), endIndex).replaceAll("\\s", "");
        return Base64.getDecoder().decode(base64);
    }
}

