/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.inversoft.http.Cookie;
import com.inversoft.rest.DateTools;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClientResponse<T, U> {
    public final List<Cookie> cookies = new ArrayList<Cookie>();
    public final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    public ZonedDateTime date;
    public U errorResponse;
    public Exception exception;
    public ZonedDateTime lastModified;
    public String method;
    public Object request;
    public int status;
    public T successResponse;
    public URL url;

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    public U getErrorResponse() {
        return this.errorResponse;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name.toLowerCase());
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<String> getHeaders(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public ZonedDateTime getLastModified() {
        return this.lastModified;
    }

    public String getMethod() {
        return this.method;
    }

    public Object getRequest() {
        return this.request;
    }

    public int getStatus() {
        return this.status;
    }

    public T getSuccessResponse() {
        return this.successResponse;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        headers.forEach((key, values) -> {
            if (key == null) {
                return;
            }
            this.headers.put(key.toLowerCase(), (List<String>)values);
        });
        this.date = this.parseDateHeader("Date".toLowerCase());
        this.lastModified = this.parseDateHeader("Last-Modified".toLowerCase());
        List<String> cookies = this.headers.get("Set-Cookie".toLowerCase());
        if (cookies != null && cookies.size() > 0) {
            cookies.stream().map(Cookie::fromResponseHeader).filter(Objects::nonNull).forEach(this.cookies::add);
        }
    }

    public boolean wasSuccessful() {
        return this.status >= 200 && this.status <= 299 && this.exception == null;
    }

    private ZonedDateTime parseDateHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && values.size() > 0) {
            return DateTools.parse(values.get(0));
        }
        return null;
    }
}

