/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.inversoft.rest.RESTClient;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormDataBodyHandler
implements RESTClient.BodyHandler {
    private final Map<String, List<String>> request;
    private byte[] body;
    private boolean excludeNullValues;

    public FormDataBodyHandler(Map<String, List<String>> request, boolean excludeNullValues) {
        this.request = request;
        this.excludeNullValues = excludeNullValues;
    }

    public FormDataBodyHandler() {
        this.request = new HashMap<String, List<String>>();
    }

    public FormDataBodyHandler(Map<String, List<String>> request) {
        this.request = request;
    }

    @Override
    public void accept(OutputStream os) throws IOException {
        if (this.body != null && os != null) {
            os.write(this.body);
        }
    }

    public FormDataBodyHandler addParameter(String key, List<String> value) {
        if (value == null) {
            this.request.put(key, null);
        } else {
            this.request.computeIfAbsent(key, k -> new ArrayList(1)).addAll(value);
        }
        return this;
    }

    public FormDataBodyHandler addParameter(String key, String value) {
        if (value == null) {
            this.request.put(key, null);
        } else {
            this.request.computeIfAbsent(key, k -> new ArrayList(1)).add(value);
        }
        return this;
    }

    @Override
    public byte[] getBody() {
        if (this.request != null) {
            this.serializeRequest();
        }
        return this.body;
    }

    @Override
    public Object getBodyObject() {
        return this.request;
    }

    public void setExcludeNullValues(boolean value) {
        this.excludeNullValues = value;
    }

    @Override
    public void setHeaders(HttpURLConnection huc) {
        if (this.request != null) {
            this.serializeRequest();
            huc.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            huc.addRequestProperty("Content-Length", "" + this.body.length);
        }
    }

    public FormDataBodyHandler withExcludeNullValues(boolean excludeNullValues) {
        this.excludeNullValues = excludeNullValues;
        return this;
    }

    public FormDataBodyHandler withParameter(String key, List<String> value) {
        this.request.put(key, value);
        return this;
    }

    public FormDataBodyHandler withParameter(String key, String value) {
        if (value == null) {
            this.request.put(key, null);
        } else {
            this.request.put(key, Arrays.asList(value));
        }
        return this;
    }

    public FormDataBodyHandler withParameters(Map<String, String> parameters) {
        parameters.keySet().forEach(k -> this.request.put((String)k, Arrays.asList((String)parameters.get(k))));
        return this;
    }

    private void append(StringBuilder build, String key, String value) {
        if (build.length() > 0) {
            build.append("&");
        }
        build.append(this.encode(key)).append("=");
        if (value != null) {
            build.append(this.encode(value));
        }
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private void serializeRequest() {
        if (this.body == null) {
            StringBuilder build = new StringBuilder();
            this.request.forEach((key, values) -> {
                if (values == null) {
                    if (!this.excludeNullValues) {
                        this.append(build, (String)key, null);
                    }
                    return;
                }
                values.stream().filter(v -> v != null || !this.excludeNullValues).forEach(v -> this.append(build, (String)key, (String)v));
            });
            this.body = build.toString().getBytes(StandardCharsets.UTF_8);
        }
    }
}

