/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.inversoft.json.JacksonModule;
import com.inversoft.rest.JSONException;
import com.inversoft.rest.RESTClient;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class JSONResponseHandler<T>
implements RESTClient.ResponseHandler<T> {
    public static final ObjectMapper defaultObjectMapper = new ObjectMapper().registerModule((Module)new JacksonModule());
    private final ObjectMapper instanceObjectMapper;
    private final Class<T> type;

    public JSONResponseHandler(Class<T> type) {
        this.type = type;
        this.instanceObjectMapper = defaultObjectMapper;
    }

    public JSONResponseHandler(Class<T> type, ObjectMapper objectMapper) {
        this.type = type;
        this.instanceObjectMapper = objectMapper;
    }

    @Override
    public T apply(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        BetterBufferedInputStream bis = new BetterBufferedInputStream(is, 1024, 1024);
        bis.mark(1024);
        int c = bis.read();
        if (c == -1) {
            return null;
        }
        bis.reset();
        try {
            return (T)this.instanceObjectMapper.readValue((InputStream)bis, this.type);
        }
        catch (IOException e) {
            throw new JSONException("Failed to parse the HTTP response as JSON. Actual HTTP response body:\n" + (bis.isObservableTruncated() ? "Note: Output has been truncated to the first " + bis.getObservableLength() + " of " + bis.actualLength + " bytes.\n\n" : "") + bis.getObservableAsString(), e);
        }
    }

    public static class BetterBufferedInputStream
    extends BufferedInputStream {
        private final int maximumBytesToObserve;
        private final byte[] observableBuffer;
        private int actualLength;
        private int index;

        public BetterBufferedInputStream(InputStream in, int size, int maximumBytesToObserve) {
            super(in, size);
            this.maximumBytesToObserve = maximumBytesToObserve;
            this.observableBuffer = new byte[maximumBytesToObserve];
        }

        public BetterBufferedInputStream(InputStream in) {
            super(in);
            this.maximumBytesToObserve = 1024;
            this.observableBuffer = new byte[this.maximumBytesToObserve];
        }

        public int getActualLength() {
            return this.actualLength;
        }

        public String getObservableAsString() {
            return new String(this.observableBuffer, 0, Math.min(this.index, this.maximumBytesToObserve), StandardCharsets.UTF_8);
        }

        public int getObservableLength() {
            return Math.min(this.index, this.maximumBytesToObserve);
        }

        public boolean isObservableTruncated() {
            return this.actualLength > this.maximumBytesToObserve;
        }

        @Override
        public synchronized int read() throws IOException {
            int c = super.read();
            if (c != -1 && this.index < this.maximumBytesToObserve) {
                this.observableBuffer[this.index++] = (byte)c;
            }
            ++this.actualLength;
            return c;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read == -1) {
                return read;
            }
            int copyToObservable = Math.min(read, this.maximumBytesToObserve - this.index);
            if (this.index < this.maximumBytesToObserve) {
                System.arraycopy(b, 0, this.observableBuffer, this.index, copyToObservable);
            }
            this.actualLength += read;
            this.index += copyToObservable;
            return read;
        }

        @Override
        public synchronized void reset() throws IOException {
            super.reset();
            this.actualLength = 0;
            this.index = 0;
        }
    }
}

