/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.inversoft.http.FileUpload;
import com.inversoft.net.EncodingTools;
import com.inversoft.rest.RESTClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MultipartBodyHandler
implements RESTClient.BodyHandler {
    public final String boundary = UUID.randomUUID().toString().replace("-", "");
    private final Multiparts request;
    private byte[] body;

    public MultipartBodyHandler(Multiparts request) {
        this.request = request;
    }

    @Override
    public void accept(OutputStream os) throws IOException {
        if (this.body != null && os != null) {
            os.write(this.body);
        }
    }

    @Override
    public byte[] getBody() {
        if (this.request.files != null || this.request.parameters != null) {
            this.serializeRequest();
        }
        return this.body;
    }

    @Override
    public Object getBodyObject() {
        return this.request;
    }

    @Override
    public void setHeaders(HttpURLConnection huc) {
        if (this.request.files != null || this.request.parameters != null) {
            this.serializeRequest();
            huc.addRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            huc.addRequestProperty("Content-Length", "" + this.body.length);
        }
    }

    private void serializeRequest() {
        if (this.body == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(baos);
            try {
                if (this.request.files != null) {
                    for (FileUpload fileUpload : this.request.files) {
                        ((Writer)writer).append("--").append(this.boundary).append("\r\n");
                        ((Writer)writer).append("Content-Disposition: form-data; name=\"").append(URLEncoder.encode(fileUpload.name, "UTF-8")).append("\"").append("; filename=\"").append(EncodingTools.escapedQuotedString(fileUpload.fileName)).append("\"; filename*=UTF-8''").append(EncodingTools.rfc5987_encode(fileUpload.fileName));
                        if (fileUpload.contentType != null) {
                            ((Writer)writer).append("\r\nContent-Type: ").append(fileUpload.contentType);
                        }
                        ((Writer)writer).append("\r\n\r\n");
                        ((Writer)writer).flush();
                        baos.write(Files.readAllBytes(fileUpload.file));
                        baos.flush();
                        ((Writer)writer).append("\r\n");
                        ((Writer)writer).flush();
                    }
                }
                if (this.request.parameters != null) {
                    for (Map.Entry entry : this.request.parameters.entrySet()) {
                        for (String value : (List)entry.getValue()) {
                            ((Writer)writer).append("--").append(this.boundary).append("\r\n");
                            ((Writer)writer).append("Content-Disposition: form-data; name=\"").append(URLEncoder.encode((String)entry.getKey(), "UTF-8")).append("\"\r\n\r\n").append(URLEncoder.encode(value, "UTF-8")).append("\r\n");
                        }
                    }
                }
                ((Writer)writer).append("--").append(this.boundary).append("--");
                ((Writer)writer).flush();
                baos.flush();
                this.body = baos.toByteArray();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class Multiparts {
        public final List<FileUpload> files;
        public final Map<String, List<String>> parameters;

        public Multiparts(List<FileUpload> files, Map<String, List<String>> parameters) {
            this.files = files;
            this.parameters = parameters;
        }
    }
}

