/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.inversoft.http.Cookie;
import com.inversoft.net.ssl.SSLTools;
import com.inversoft.rest.ClientResponse;
import com.inversoft.rest.ProxyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;

public class RESTClient<RS, ERS> {
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Class<ERS> errorType;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
    private final Class<RS> successType;
    private final StringBuilder url = new StringBuilder();
    private BodyHandler bodyHandler;
    private String certificate;
    private int connectTimeout = 2000;
    private ResponseHandler<ERS> errorResponseHandler;
    private boolean followRedirects = true;
    private String key;
    private String method;
    private ProxyInfo proxyInfo;
    private int readTimeout = 2000;
    private boolean sniVerificationDisabled;
    private ResponseHandler<RS> successResponseHandler;
    private String userAgent = "Restify (https://github.com/inversoft/restify)";

    public RESTClient(Class<RS> successType, Class<ERS> errorType) {
        if (successType == Void.class || errorType == Void.class) {
            throw new IllegalArgumentException("Void.class isn't valid. Use Void.TYPE instead.");
        }
        this.successType = successType;
        this.errorType = errorType;
    }

    public RESTClient<RS, ERS> addHeader(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.headers.computeIfAbsent(name, key -> new ArrayList()).add(value);
        return this;
    }

    public RESTClient<RS, ERS> addHeaders(Map<String, List<String>> headers) {
        if (headers == null) {
            return this;
        }
        headers.forEach((key, values) -> values.forEach(value -> this.addHeader((String)key, (String)value)));
        return this;
    }

    public RESTClient<RS, ERS> addURLParameter(String name, Object value) {
        if (value instanceof ZonedDateTime) {
            this.addURLParameter(name, Long.toString(((ZonedDateTime)value).toInstant().toEpochMilli()));
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                if (o == null) continue;
                this.addURLParameter(name, o.toString());
            }
        } else if (value != null) {
            this.addURLParameter(name, value.toString());
        }
        return this;
    }

    public RESTClient<RS, ERS> addURLParameter(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.parameters.computeIfAbsent(name, k -> new ArrayList()).add(value);
        return this;
    }

    public RESTClient<RS, ERS> addURLParameterObjects(Map<String, Object> urlParameters) {
        if (urlParameters != null) {
            urlParameters.forEach(this::addURLParameter);
        }
        return this;
    }

    public RESTClient<RS, ERS> addURLParameters(Map<String, List<String>> urlParameters) {
        if (urlParameters != null) {
            urlParameters.forEach(this::addURLParameter);
        }
        return this;
    }

    public RESTClient<RS, ERS> authorization(String key) {
        if (key != null && !key.isEmpty()) {
            this.headers.put("Authorization", Collections.singletonList(key));
        } else {
            this.headers.remove("Authorization");
        }
        return this;
    }

    public RESTClient<RS, ERS> basicAuthorization(String username, String password) {
        if (username != null && password != null) {
            this.headers.put("Authorization", Collections.singletonList(this.base64Basic(username, password)));
        }
        return this;
    }

    public RESTClient<RS, ERS> bodyHandler(BodyHandler bodyHandler) {
        this.bodyHandler = bodyHandler;
        return this;
    }

    public RESTClient<RS, ERS> certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    public RESTClient<RS, ERS> connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public RESTClient<RS, ERS> cookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public RESTClient<RS, ERS> cookies(Cookie ... cookies) {
        this.cookies.addAll(Arrays.asList(cookies));
        return this;
    }

    public RESTClient<RS, ERS> cookies(List<Cookie> cookies) {
        this.cookies.addAll(cookies);
        return this;
    }

    public RESTClient<RS, ERS> delete() {
        this.method = HTTPMethod.DELETE.name();
        return this;
    }

    public RESTClient<RS, ERS> disableSNIVerification() {
        this.sniVerificationDisabled = true;
        return this;
    }

    public RESTClient<RS, ERS> errorResponseHandler(ResponseHandler<ERS> errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public RESTClient<RS, ERS> followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public RESTClient<RS, ERS> get() {
        this.method = HTTPMethod.GET.name();
        return this;
    }

    public URI getURI() {
        return URI.create(this.url.toString());
    }

    public ClientResponse<RS, ERS> go() {
        ClientResponse response;
        block48: {
            InputStream is;
            int status;
            HttpURLConnection huc;
            block47: {
                if (this.url.length() == 0) {
                    throw new IllegalStateException("You must specify a URL");
                }
                Objects.requireNonNull(this.method, "You must specify a HTTP method");
                if (this.successType != Void.TYPE && this.successResponseHandler == null) {
                    throw new IllegalStateException("You specified a success response type, you must then provide a success response handler.");
                }
                if (this.errorType != Void.TYPE && this.errorResponseHandler == null) {
                    throw new IllegalStateException("You specified an error response type, you must then provide an error response handler.");
                }
                response = new ClientResponse();
                response.request = this.bodyHandler != null ? this.bodyHandler.getBodyObject() : null;
                response.method = this.method;
                try {
                    if (this.parameters.size() > 0) {
                        if (this.url.indexOf("?") == -1) {
                            this.url.append("?");
                        }
                        Iterator<Map.Entry<String, List<String>>> i = this.parameters.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry<String, List<String>> entry = i.next();
                            Iterator<String> j = entry.getValue().iterator();
                            while (j.hasNext()) {
                                String value = j.next();
                                this.url.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
                                if (!j.hasNext()) continue;
                                this.url.append("&");
                            }
                            if (!i.hasNext()) continue;
                            this.url.append("&");
                        }
                    }
                    response.url = new URL(this.url.toString());
                    Proxy proxy = Proxy.NO_PROXY;
                    if (this.proxyInfo != null) {
                        if (this.proxyInfo.host != null && this.proxyInfo.port != -1) {
                            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyInfo.host, this.proxyInfo.port));
                        }
                        if (this.proxyInfo.username != null && this.proxyInfo.password != null) {
                            this.headers.put("Proxy-Authorization", Collections.singletonList(this.base64Basic(this.proxyInfo.username, this.proxyInfo.password)));
                        }
                    }
                    huc = (HttpURLConnection)response.url.openConnection(proxy);
                    if (response.url.getProtocol().equalsIgnoreCase("https")) {
                        HttpsURLConnection hsuc = (HttpsURLConnection)huc;
                        if (this.certificate != null) {
                            if (this.key != null) {
                                hsuc.setSSLSocketFactory(SSLTools.getSSLServerContext(this.certificate, this.key).getSocketFactory());
                            } else {
                                hsuc.setSSLSocketFactory(SSLTools.getSSLSocketFactory(this.certificate));
                            }
                        }
                        if (this.sniVerificationDisabled) {
                            hsuc.setHostnameVerifier((hostname, session) -> true);
                        }
                    }
                    huc.setInstanceFollowRedirects(this.followRedirects);
                    huc.setDoOutput(this.bodyHandler != null);
                    huc.setConnectTimeout(this.connectTimeout);
                    huc.setReadTimeout(this.readTimeout);
                    huc.setRequestMethod(this.method);
                    if (this.headers.keySet().stream().noneMatch(name -> name.equalsIgnoreCase("User-Agent"))) {
                        this.headers.put("User-Agent", Collections.singletonList(this.userAgent));
                    }
                    this.headers.forEach((name, values) -> values.forEach(value -> huc.addRequestProperty((String)name, (String)value)));
                    if (this.headers.keySet().stream().noneMatch(name -> name.equalsIgnoreCase("Cookie")) && this.cookies.size() > 0) {
                        String header = this.cookies.stream().map(Cookie::toRequestHeader).collect(Collectors.joining("; "));
                        huc.addRequestProperty("Cookie", header);
                    }
                    if (this.bodyHandler != null) {
                        this.bodyHandler.setHeaders(huc);
                    }
                    huc.connect();
                    if (this.bodyHandler == null) break block47;
                    try (OutputStream os = huc.getOutputStream();){
                        this.bodyHandler.accept(os);
                        os.flush();
                    }
                }
                catch (Exception e) {
                    response.status = -1;
                    response.exception = e;
                    return response;
                }
            }
            try {
                status = huc.getResponseCode();
            }
            catch (Exception e) {
                response.status = -1;
                response.exception = e;
                return response;
            }
            response.setHeaders(huc.getHeaderFields());
            response.status = status;
            if (status < 200 || status > 299) {
                if (this.errorResponseHandler == null) {
                    return response;
                }
                try {
                    is = huc.getErrorStream();
                    try {
                        response.errorResponse = this.errorResponseHandler.apply(is);
                        break block48;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Exception e) {
                    response.exception = e;
                    return response;
                }
            }
            if (this.successResponseHandler == null || this.method.equalsIgnoreCase(HTTPMethod.HEAD.name())) {
                return response;
            }
            try {
                is = huc.getInputStream();
                try {
                    response.successResponse = this.successResponseHandler.apply(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                response.exception = e;
                return response;
            }
        }
        return response;
    }

    public RESTClient<RS, ERS> head() {
        this.method = HTTPMethod.HEAD.name();
        return this;
    }

    public RESTClient<RS, ERS> header(String name, String value) {
        return this.addHeader(name, value);
    }

    public RESTClient<RS, ERS> headers(Map<String, List<String>> headers) {
        return this.addHeaders(headers);
    }

    public RESTClient<RS, ERS> key(String key) {
        this.key = key;
        return this;
    }

    public RESTClient<RS, ERS> method(String method) {
        try {
            if (method.equals(HTTPMethod.PATCH.name())) {
                this.method = HTTPMethod.POST.name();
                this.headers.put("X-HTTP-Method-Override", Collections.singletonList(method));
            } else {
                this.method = HTTPMethod.valueOf(method).name();
            }
        }
        catch (Exception e) {
            this.method = HTTPMethod.POST.name();
            this.headers.put("X-HTTP-Method-Override", Collections.singletonList(method));
        }
        return this;
    }

    public RESTClient<RS, ERS> method(HTTPMethod method) {
        this.method = method.name();
        return this;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public RESTClient<RS, ERS> patch() {
        this.method = HTTPMethod.POST.name();
        this.headers.put("X-HTTP-Method-Override", Collections.singletonList("PATCH"));
        return this;
    }

    public RESTClient<RS, ERS> post() {
        this.method = HTTPMethod.POST.name();
        return this;
    }

    public RESTClient<RS, ERS> proxy(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
        return this;
    }

    public RESTClient<RS, ERS> put() {
        this.method = HTTPMethod.PUT.name();
        return this;
    }

    public RESTClient<RS, ERS> readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public RESTClient<RS, ERS> replaceHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        this.setHeaders(headers);
        return this;
    }

    public RESTClient<RS, ERS> replaceURLParameters(Map<String, List<String>> urlParameters) {
        this.parameters.clear();
        this.setURLParameters(urlParameters);
        return this;
    }

    public RESTClient<RS, ERS> setHeader(String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.headers.remove(name);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.headers.put(name, list);
        }
        return this;
    }

    public RESTClient<RS, ERS> setHeaders(String name, List<String> values) {
        if (values == null) {
            this.headers.remove(name);
        } else {
            this.headers.put(name, new ArrayList(values.stream().filter(Objects::nonNull).collect(Collectors.toList())));
        }
        return this;
    }

    public RESTClient<RS, ERS> setHeaders(Map<String, List<String>> headers) {
        if (headers != null) {
            for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                if (e.getKey() == null || e.getValue() == null || !e.getValue().stream().anyMatch(Objects::nonNull)) continue;
                this.headers.put(e.getKey(), e.getValue().stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        return this;
    }

    public RESTClient<RS, ERS> setURLParameter(String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.parameters.remove(name);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.parameters.put(name, list);
        }
        return this;
    }

    public RESTClient<RS, ERS> setURLParameter(String name, Object value) {
        if (value instanceof ZonedDateTime) {
            this.setURLParameter(name, Long.toString(((ZonedDateTime)value).toInstant().toEpochMilli()));
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                if (o == null) continue;
                this.setURLParameter(name, o.toString());
            }
        } else if (value != null) {
            this.setURLParameter(name, value.toString());
        }
        return this;
    }

    public RESTClient<RS, ERS> setURLParameterObjects(Map<String, Object> urlParameters) {
        if (urlParameters != null) {
            urlParameters.forEach(this::setURLParameter);
        }
        return this;
    }

    public RESTClient<RS, ERS> setURLParameters(Map<String, List<String>> urlParameters) {
        if (urlParameters != null) {
            for (Map.Entry<String, List<String>> e : urlParameters.entrySet()) {
                if (e.getKey() == null || e.getValue() == null || !e.getValue().stream().anyMatch(Objects::nonNull)) continue;
                this.parameters.put(e.getKey(), e.getValue().stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        return this;
    }

    public RESTClient<RS, ERS> successResponseHandler(ResponseHandler<RS> successResponseHandler) {
        this.successResponseHandler = successResponseHandler;
        return this;
    }

    public RESTClient<RS, ERS> uri(String uri) {
        if (this.url.length() == 0) {
            return this;
        }
        if (this.url.charAt(this.url.length() - 1) == '/' && uri.startsWith("/")) {
            this.url.append(uri.substring(1));
        } else if (this.url.charAt(this.url.length() - 1) != '/' && !uri.startsWith("/")) {
            this.url.append("/").append(uri);
        } else {
            this.url.append(uri);
        }
        return this;
    }

    public String url() {
        return this.url.toString();
    }

    public RESTClient<RS, ERS> url(String url) {
        this.url.delete(0, this.url.length());
        this.url.append(url);
        return this;
    }

    public RESTClient<RS, ERS> urlParameter(String name, Object value) {
        return this.addURLParameter(name, value);
    }

    public RESTClient<RS, ERS> urlParameter(String name, String value) {
        return this.addURLParameter(name, value);
    }

    public RESTClient<RS, ERS> urlParameterObjects(Map<String, Object> urlParameters) {
        return this.addURLParameterObjects(urlParameters);
    }

    public RESTClient<RS, ERS> urlParameters(Map<String, List<String>> urlParameters) {
        return this.addURLParameters(urlParameters);
    }

    public RESTClient<RS, ERS> urlSegment(Object value) {
        if (value != null) {
            if (this.url.charAt(this.url.length() - 1) != '/') {
                this.url.append('/');
            }
            this.url.append(value);
        }
        return this;
    }

    public RESTClient<RS, ERS> userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    private String base64Basic(String username, String password) {
        String credentials = username + ":" + password;
        Base64.Encoder encoder = Base64.getEncoder();
        return "Basic " + encoder.encodeToString(credentials.getBytes());
    }

    static {
        System.setProperty("sun.net.http.retryPost", "false");
    }

    public static interface BodyHandler {
        public void accept(OutputStream var1) throws IOException;

        public byte[] getBody();

        default public Object getBodyObject() {
            return null;
        }

        public void setHeaders(HttpURLConnection var1);
    }

    public static enum HTTPMethod {
        CONNECT,
        DELETE,
        GET,
        HEAD,
        OPTIONS,
        PATCH,
        POST,
        PUT,
        TRACE;

    }

    public static interface ResponseHandler<T> {
        public T apply(InputStream var1) throws IOException;
    }
}

