/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ioinformarics.oss.jackson.module.jsonld.HydraCollection;
import ioinformarics.oss.jackson.module.jsonld.JsonldContextFactory;
import ioinformarics.oss.jackson.module.jsonld.JsonldGraphBuilder;
import ioinformarics.oss.jackson.module.jsonld.JsonldResource;
import java.util.Optional;

public class HydraCollectionBuilder<T>
extends JsonldGraphBuilder<T> {
    private Long totalItems;
    private Integer itemsPerPage;
    private String firstPage;
    private String nextPage;
    private String previousPage;
    private String lastPage;
    private boolean isPaged = false;

    public HydraCollectionBuilder<T> totalItems(Long totalItems) {
        this.totalItems = totalItems;
        this.isPaged = true;
        return this;
    }

    public HydraCollectionBuilder<T> itemsPerPage(Integer itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        this.isPaged = true;
        return this;
    }

    public HydraCollectionBuilder<T> firstPage(String firstPage) {
        this.firstPage = firstPage;
        this.isPaged = true;
        return this;
    }

    public HydraCollectionBuilder<T> nextPage(String nextPage) {
        this.nextPage = nextPage;
        this.isPaged = true;
        return this;
    }

    public HydraCollectionBuilder<T> previousPage(String previousPage) {
        this.previousPage = previousPage;
        this.isPaged = true;
        return this;
    }

    public HydraCollectionBuilder<T> lastPage(String lastPage) {
        this.lastPage = lastPage;
        this.isPaged = true;
        return this;
    }

    @Override
    public JsonldResource build(Iterable<T> elements) {
        return new HydraCollection(this.buildElements(elements), this.buildContext(elements).orElse(null), this.isPaged ? "hydra:PagedCollection" : "hydra:Collection", this.graphId, this.totalItems, this.itemsPerPage, this.firstPage, this.nextPage, this.previousPage, this.lastPage);
    }

    protected Optional<JsonNode> buildContext(Iterable<T> elements) {
        Optional<ObjectNode> hydraContext = JsonldContextFactory.fromAnnotations(HydraCollection.CollectionContainer.class);
        Optional<ObjectNode> mergedContext = hydraContext.map(it -> (ObjectNode)it.setAll(JsonldContextFactory.fromAnnotations(elements).orElse(this.emptyNode())));
        return JsonldContextFactory.multiContext(Optional.ofNullable(this.context), mergedContext);
    }

    private ObjectNode emptyNode() {
        return JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
    }
}

