/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import ioinformarics.oss.jackson.module.jsonld.BeanJsonldResource;
import ioinformarics.oss.jackson.module.jsonld.JsonldContextFactory;
import ioinformarics.oss.jackson.module.jsonld.JsonldResource;
import ioinformarics.oss.jackson.module.jsonld.MapJsonldResource;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldType;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class JsonldResourceBuilder<T> {
    private String _context;
    private String _type;
    private String _id;
    private Function<T, String> _idSupplier;

    JsonldResourceBuilder() {
    }

    public JsonldResourceBuilder<T> context(String context) {
        this._context = context;
        return this;
    }

    public JsonldResourceBuilder<T> type(String type) {
        this._type = type;
        return this;
    }

    public JsonldResourceBuilder<T> id(String id) {
        this._id = id;
        return this;
    }

    public JsonldResourceBuilder<T> id(Function<T, String> idSupplier) {
        this._idSupplier = idSupplier;
        return this;
    }

    public JsonldResource build(T scopedObj) {
        if (scopedObj == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(scopedObj.getClass())) {
            return new MapJsonldResource((Map)scopedObj, this.getContext(scopedObj).orElse(null), this.getType(scopedObj), this.getId(scopedObj));
        }
        return new BeanJsonldResource(scopedObj, this.getContext(scopedObj).orElse(null), this.getType(scopedObj), this.getId(scopedObj));
    }

    protected Optional<JsonNode> getContext(T scopedObj) {
        return JsonldContextFactory.multiContext(Optional.ofNullable(this._context), JsonldContextFactory.fromAnnotations(scopedObj));
    }

    protected String getId(T scopedObj) {
        return Optional.ofNullable(this._id).orElse(Optional.ofNullable(this._idSupplier).map(f -> (String)f.apply(scopedObj)).orElse(null));
    }

    protected String getType(T scopedObj) {
        return Optional.ofNullable(this._type).orElse(JsonldResourceBuilder.dynamicTypeLookup(scopedObj.getClass()));
    }

    static String dynamicTypeLookup(Class<?> objType) {
        JsonldType type = objType.getAnnotation(JsonldType.class);
        return type == null ? null : type.value();
    }
}

