/*
 * Decompiled with CFR 0.152.
 */
package com.iodesystems.junit4.runner;

import com.iodesystems.junit4.runner.util.SystemOutputSpy;
import com.iodesystems.junit4.xsd.Failure;
import com.iodesystems.junit4.xsd.Result;
import com.iodesystems.junit4.xsd.Skip;
import com.iodesystems.junit4.xsd.TestCase;
import com.iodesystems.junit4.xsd.TestSuite;
import com.iodesystems.junit4.xsd.TestSuites;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010+\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010,\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010-\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010.\u001a\u00020/H\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00060"}, d2={"Lcom/iodesystems/junit4/runner/XmlRunListener;", "Lorg/junit/runner/notification/RunListener;", "suites", "Lcom/iodesystems/junit4/xsd/TestSuites;", "output", "Ljava/io/OutputStream;", "(Lcom/iodesystems/junit4/xsd/TestSuites;Ljava/io/OutputStream;)V", "currentSuite", "Lcom/iodesystems/junit4/xsd/TestSuite;", "getCurrentSuite", "()Lcom/iodesystems/junit4/xsd/TestSuite;", "setCurrentSuite", "(Lcom/iodesystems/junit4/xsd/TestSuite;)V", "currentTest", "Lcom/iodesystems/junit4/xsd/TestCase;", "getCurrentTest", "()Lcom/iodesystems/junit4/xsd/TestCase;", "setCurrentTest", "(Lcom/iodesystems/junit4/xsd/TestCase;)V", "mc", "Ljava/math/MathContext;", "getOutput", "()Ljava/io/OutputStream;", "spy", "Lcom/iodesystems/junit4/runner/util/SystemOutputSpy;", "getSuites", "()Lcom/iodesystems/junit4/xsd/TestSuites;", "end", "Ljava/math/BigDecimal;", "start", "now", "testFailure", "", "failure", "Lorg/junit/runner/notification/Failure;", "testFinished", "description", "Lorg/junit/runner/Description;", "testIgnored", "testRunFinished", "result", "Lorg/junit/runner/Result;", "testRunStarted", "testStarted", "testSuiteFinished", "testSuiteStarted", "timestamp", "", "junit4-runner"})
public final class XmlRunListener
extends RunListener {
    @NotNull
    private final TestSuites suites;
    @NotNull
    private final OutputStream output;
    @NotNull
    private final SystemOutputSpy spy;
    @NotNull
    private final MathContext mc;
    @Nullable
    private TestSuite currentSuite;
    @Nullable
    private TestCase currentTest;

    public XmlRunListener(@NotNull TestSuites suites, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)suites, (String)"suites");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.suites = suites;
        this.output = output;
        this.spy = new SystemOutputSpy();
        this.mc = new MathContext(2, RoundingMode.HALF_UP);
    }

    public /* synthetic */ XmlRunListener(TestSuites testSuites, OutputStream outputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            testSuites = new TestSuites();
        }
        if ((n & 2) != 0) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            outputStream = printStream;
        }
        this(testSuites, outputStream);
    }

    @NotNull
    public final TestSuites getSuites() {
        return this.suites;
    }

    @NotNull
    public final OutputStream getOutput() {
        return this.output;
    }

    private final String timestamp() {
        String string = OffsetDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"now().format(DateTimeFormatter.ISO_DATE_TIME)");
        return string;
    }

    @Nullable
    public final TestSuite getCurrentSuite() {
        return this.currentSuite;
    }

    public final void setCurrentSuite(@Nullable TestSuite testSuite) {
        this.currentSuite = testSuite;
    }

    @Nullable
    public final TestCase getCurrentTest() {
        return this.currentTest;
    }

    public final void setCurrentTest(@Nullable TestCase testCase) {
        this.currentTest = testCase;
    }

    private final BigDecimal now() {
        BigDecimal bigDecimal = BigDecimal.valueOf(System.currentTimeMillis());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
        return bigDecimal;
    }

    private final BigDecimal end(BigDecimal start) {
        BigDecimal bigDecimal = BigDecimal.valueOf(System.currentTimeMillis());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
        BigDecimal bigDecimal2 = bigDecimal.subtract(start);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.subtract(other)");
        BigDecimal bigDecimal3 = BigDecimal.valueOf(1000);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(this.toLong())");
        BigDecimal bigDecimal4 = bigDecimal2.divide(bigDecimal3, this.mc);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"currentTimeMillis().toBi\u2026(1000.toBigDecimal(), mc)");
        return bigDecimal4;
    }

    public void testRunStarted(@NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.suites.setTimestamp(this.timestamp());
    }

    public void testRunFinished(@NotNull org.junit.runner.Result result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.suites.setTime(new BigDecimal(String.valueOf((double)result.getRunTime() / 1000.0)));
        this.suites.setSkipped(Integer.valueOf(result.getIgnoreCount()));
        this.suites.setFailures(Integer.valueOf(result.getFailureCount()));
        OutputStreamWriter writer = new OutputStreamWriter(this.output);
        Class[] classArray = new Class[]{TestSuites.class};
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)jAXBContext, (String)"newInstance(TestSuites::class.java)");
        JAXBContext context = jAXBContext;
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this.suites, (Writer)writer);
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - void declaration
     */
    public void testSuiteStarted(@NotNull Description description) {
        void $this$testSuiteStarted_u24lambda_u240;
        TestSuite testSuite;
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (description.getTestClass() == null) {
            return;
        }
        TestSuite testSuite2 = testSuite = new TestSuite();
        XmlRunListener xmlRunListener = this;
        boolean bl = false;
        $this$testSuiteStarted_u24lambda_u240.setTime(this.now());
        $this$testSuiteStarted_u24lambda_u240.setTimestamp(this.timestamp());
        $this$testSuiteStarted_u24lambda_u240.setName(description.getDisplayName());
        this.suites.getTestSuites().add($this$testSuiteStarted_u24lambda_u240);
        xmlRunListener.currentSuite = testSuite;
    }

    public void testSuiteFinished(@NotNull Description description) {
        block1: {
            TestSuite testSuite;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            if (description.getTestClass() == null) {
                return;
            }
            TestSuite testSuite2 = this.currentSuite;
            if (testSuite2 == null) break block1;
            TestSuite $this$testSuiteFinished_u24lambda_u241 = testSuite = testSuite2;
            boolean bl = false;
            BigDecimal bigDecimal = $this$testSuiteFinished_u24lambda_u241.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"time");
            $this$testSuiteFinished_u24lambda_u241.setTime(this.end(bigDecimal));
            $this$testSuiteFinished_u24lambda_u241.setClassname(description.getClassName());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testStarted(@NotNull Description description) {
        block0: {
            void $this$testStarted_u24lambda_u243_u24lambda_u242;
            TestCase testCase;
            TestSuite testSuite;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.spy.trap();
            TestSuites testSuites = this.suites;
            testSuites.setTestCount(Integer.valueOf(testSuites.getTestCount() + 1));
            TestSuite testSuite2 = this.currentSuite;
            if (testSuite2 == null) break block0;
            TestSuite $this$testStarted_u24lambda_u243 = testSuite = testSuite2;
            boolean bl = false;
            $this$testStarted_u24lambda_u243.setTests(Integer.valueOf($this$testStarted_u24lambda_u243.getTests() + 1));
            TestCase testCase2 = testCase = new TestCase();
            XmlRunListener xmlRunListener = this;
            boolean bl2 = false;
            $this$testStarted_u24lambda_u243_u24lambda_u242.setName(description.getMethodName());
            $this$testStarted_u24lambda_u243_u24lambda_u242.setFile(description.getTestClass().getCanonicalName());
            $this$testStarted_u24lambda_u243_u24lambda_u242.setTime(this.now());
            $this$testStarted_u24lambda_u243.getTestCases().add($this$testStarted_u24lambda_u243_u24lambda_u242);
            xmlRunListener.currentTest = testCase;
        }
    }

    public void testFinished(@NotNull Description description) {
        block2: {
            TestCase testCase;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            SystemOutputSpy.Output out = this.spy.restore();
            TestCase testCase2 = this.currentTest;
            if (testCase2 == null) break block2;
            TestCase $this$testFinished_u24lambda_u244 = testCase = testCase2;
            boolean bl = false;
            BigDecimal bigDecimal = $this$testFinished_u24lambda_u244.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"time");
            $this$testFinished_u24lambda_u244.setTime(this.end(bigDecimal));
            if (!StringsKt.isBlank((CharSequence)out.getStd())) {
                $this$testFinished_u24lambda_u244.setSystemOut(out.getStd());
            }
            if (!StringsKt.isBlank((CharSequence)out.getErr())) {
                $this$testFinished_u24lambda_u244.setSystemErr(out.getErr());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testFailure(@NotNull org.junit.runner.notification.Failure failure) {
        block0: {
            void $this$testFailure_u24lambda_u246_u24lambda_u245;
            Failure failure2;
            TestCase testCase;
            Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
            TestCase testCase2 = this.currentTest;
            if (testCase2 == null) break block0;
            TestCase $this$testFailure_u24lambda_u246 = testCase = testCase2;
            boolean bl = false;
            Failure failure3 = failure2 = new Failure();
            TestCase testCase3 = $this$testFailure_u24lambda_u246;
            boolean bl2 = false;
            $this$testFailure_u24lambda_u246_u24lambda_u245.setMessage(failure.getMessage());
            $this$testFailure_u24lambda_u246_u24lambda_u245.setStackTrace(failure.getTrace());
            $this$testFailure_u24lambda_u246_u24lambda_u245.setType(failure.getException().getClass().getSimpleName());
            testCase3.setResult((Result)failure2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testIgnored(@NotNull Description description) {
        block0: {
            void $this$testIgnored_u24lambda_u248_u24lambda_u247;
            Skip skip;
            TestCase testCase;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            TestCase testCase2 = this.currentTest;
            if (testCase2 == null) break block0;
            TestCase $this$testIgnored_u24lambda_u248 = testCase = testCase2;
            boolean bl = false;
            Skip skip2 = skip = new Skip();
            TestCase testCase3 = $this$testIgnored_u24lambda_u248;
            boolean bl2 = false;
            $this$testIgnored_u24lambda_u248_u24lambda_u247.setMessage("Skipped");
            testCase3.setResult((Result)skip);
        }
    }

    public XmlRunListener() {
        this(null, null, 3, null);
    }
}

