/*
 * Decompiled with CFR 0.152.
 */
package com.iodesystems.junit4.runner.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/iodesystems/junit4/runner/util/MultiplexOutputStream;", "Ljava/io/OutputStream;", "outputStreams", "", "(Ljava/util/List;)V", "getOutputStreams", "()Ljava/util/List;", "close", "", "flush", "write", "b", "", "off", "", "len", "junit4-runner"})
public final class MultiplexOutputStream
extends OutputStream {
    @NotNull
    private final List<OutputStream> outputStreams;

    public MultiplexOutputStream(@NotNull List<? extends OutputStream> outputStreams) {
        Intrinsics.checkNotNullParameter(outputStreams, (String)"outputStreams");
        this.outputStreams = outputStreams;
    }

    @NotNull
    public final List<OutputStream> getOutputStreams() {
        return this.outputStreams;
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b);
        }
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        for (OutputStream os : this.outputStreams) {
            os.write(b);
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        for (OutputStream os : this.outputStreams) {
            os.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.close();
        }
    }
}

