/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.fs;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class FileKit {
    public static File[] listFiles(File file) {
        return FileKit.listFiles(file, 0, null);
    }

    public static File[] listFiles(File file, FileFilter filter) {
        return FileKit.listFiles(file, 0, filter);
    }

    public static File[] listFiles(File file, int recursiveLevel) {
        return FileKit.listFiles(file, recursiveLevel, null);
    }

    public static File[] listFiles(File file, int recursiveLevel, FileFilter filter) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return null;
        }
        File[] fileArray = file.listFiles(filter);
        if (fileArray == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : fileArray) {
            FileKit.listFiles(f, files, recursiveLevel, filter);
        }
        return files.toArray(new File[0]);
    }

    private static void listFiles(File file, List<File> files, int recursiveLevel, FileFilter filter) {
        files.add(file);
        if (file.isDirectory() && recursiveLevel != 0) {
            File[] fileArray = file.listFiles(filter);
            if (fileArray == null) {
                return;
            }
            for (File f : fileArray) {
                FileKit.listFiles(f, files, recursiveLevel - 1, filter);
            }
        }
    }
}

