/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.fs;

import com.iofairy.falcon.fs.PathInfo;
import com.iofairy.falcon.fs.SeparatorType;
import com.iofairy.falcon.os.OS;
import com.iofairy.string.Ascii;
import com.iofairy.top.G;
import com.iofairy.top.S;
import java.util.Arrays;
import java.util.regex.Pattern;

public class FilePath {
    public static final String ROOT = "/";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String DOT = ".";
    public static final String PARENT_DIR = "..";
    public static final String DOTSLASH = "./";
    public static final String DOTBACKSLASH = ".\\";
    public static final String TWOBACKSLASH = "\\\\";
    public static final String SLASHDOT = "/.";
    public static final String BACKSLASHDOT = "\\.";
    public static final Pattern SLASH_PATTERN = Pattern.compile("[/\\\\]");
    public static final Pattern ONLY_DOT_PATTERN = Pattern.compile("\\.+");

    public static String path(String firstPath, String ... subPaths) {
        return FilePath.concatPath(false, firstPath, subPaths);
    }

    public static String pathWin(String firstPath, String ... subPaths) {
        String path = FilePath.concatPath(true, firstPath, subPaths);
        return FilePath.slashToBackslash(path);
    }

    public static String pathSlash(String firstPath, String ... subPaths) {
        return FilePath.concatPath(true, firstPath, subPaths);
    }

    private static String concatPath(boolean isWin, String firstPath, String ... subPaths) {
        if (null == firstPath) {
            return null;
        }
        boolean isFirstPathEmpty = EMPTY.equals(firstPath);
        StringBuilder pathBuffer = new StringBuilder(firstPath);
        if (!G.isEmpty((Object)subPaths)) {
            if (G.hasNull((Object[])subPaths)) {
                return null;
            }
            boolean isFirstNonEmptySubPath = true;
            for (String path : subPaths) {
                if (G.isEmpty((CharSequence)path)) continue;
                if (isFirstNonEmptySubPath && isFirstPathEmpty) {
                    isFirstNonEmptySubPath = false;
                    pathBuffer.append(path);
                    continue;
                }
                pathBuffer.append("/").append(path);
            }
        }
        String tempPath = pathBuffer.toString();
        tempPath = isWin ? FilePath.backslashToSlash(tempPath) : tempPath;
        tempPath = FilePath.mergeRepeated(tempPath);
        tempPath = FilePath.rmTailSlash(tempPath, false);
        return FilePath.rmTailSlashDot(tempPath, false);
    }

    public static String pathAuto(String firstPath, String ... subPaths) {
        return OS.IS_WINDOWS ? FilePath.pathSlash(firstPath, subPaths) : FilePath.path(firstPath, subPaths);
    }

    public static String pathAutoWin(String firstPath, String ... subPaths) {
        return OS.IS_WINDOWS ? FilePath.pathWin(firstPath, subPaths) : FilePath.path(firstPath, subPaths);
    }

    public static PathInfo info(String filePath) {
        return FilePath.getPathInfo(filePath, SeparatorType.SLASH);
    }

    public static PathInfo infoWin(String filePath) {
        return FilePath.getPathInfo(filePath, SeparatorType.BACKSLASH);
    }

    public static PathInfo infoSlash(String filePath) {
        return FilePath.getPathInfo(filePath, SeparatorType.WIN_SLASH);
    }

    public static PathInfo infoAuto(String filePath) {
        return OS.IS_WINDOWS ? FilePath.infoSlash(filePath) : FilePath.info(filePath);
    }

    public static PathInfo infoAutoWin(String filePath) {
        return OS.IS_WINDOWS ? FilePath.infoWin(filePath) : FilePath.info(filePath);
    }

    private static PathInfo getPathInfo(String filePath, SeparatorType separatorType) {
        char[] chars;
        String path;
        if (G.isEmpty((CharSequence)filePath)) {
            return null;
        }
        String rootStr = "/";
        String separator = "/";
        switch (separatorType) {
            case SLASH: {
                path = FilePath.path(filePath, new String[0]);
                break;
            }
            case WIN_SLASH: {
                path = FilePath.pathSlash(filePath, new String[0]);
                break;
            }
            default: {
                path = FilePath.pathWin(filePath, new String[0]);
                rootStr = BACKSLASH;
                separator = BACKSLASH;
            }
        }
        String[] paths = path.split(separator.equals("/") ? "/" : TWOBACKSLASH);
        if (path.equals(rootStr)) {
            return new PathInfo(true, rootStr, null, path, paths, null, separator, separatorType);
        }
        String fileName = paths[paths.length - 1];
        String parentPath = String.join((CharSequence)separator, Arrays.copyOfRange(paths, 0, paths.length - 1));
        if (SeparatorType.SLASH != separatorType && (chars = path.toCharArray()).length >= 2) {
            char c0 = chars[0];
            char c1 = chars[1];
            if (Ascii.isLetter((char)c0) && c1 == ':') {
                if (chars.length == 2) {
                    return new PathInfo(true, path + separator, null, path, paths, null, separator, separatorType);
                }
                if (chars[2] == separator.charAt(0)) {
                    return new PathInfo(true, EMPTY + c0 + c1 + separator, parentPath, path, paths, fileName, separator, separatorType);
                }
            }
        }
        if (path.startsWith(rootStr)) {
            return new PathInfo(true, rootStr, EMPTY.equals(parentPath) ? rootStr : parentPath, path, paths, fileName, separator, separatorType);
        }
        return new PathInfo(false, null, paths.length == 1 ? null : parentPath, path, paths, fileName, separator, separatorType);
    }

    public static String addHeadDotSlash(String originPath) {
        return FilePath.addHeadDotSlash(originPath, true);
    }

    public static String addHeadDotSlash(String originPath, boolean isNeedMerge) {
        String path;
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        String string = path = isNeedMerge ? FilePath.mergeRepeated(originPath) : originPath;
        if (path.startsWith(DOTSLASH)) {
            return path;
        }
        return path.startsWith("/") ? DOT + path : DOTSLASH + path;
    }

    public static String rmHeadDotSlash(String originPath) {
        return FilePath.rmHeadDotSlash(originPath, true);
    }

    public static String rmHeadDotSlash(String originPath, boolean isNeedMerge) {
        String path;
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        String string = path = isNeedMerge ? FilePath.mergeRepeated(originPath) : originPath;
        if (path.equals(DOTSLASH)) {
            return path;
        }
        return path.startsWith(DOTSLASH) ? path.substring(2) : path;
    }

    public static String rmTailSlashDot(String originPath) {
        return FilePath.rmTailSlashDot(originPath, true);
    }

    public static String rmTailSlashDot(String originPath, boolean isNeedMerge) {
        String path;
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        String string = path = isNeedMerge ? FilePath.mergeRepeated(originPath) : originPath;
        if (path.equals(SLASHDOT)) {
            return "/";
        }
        return path.endsWith(SLASHDOT) ? path.substring(0, path.length() - 2) : path;
    }

    public static String rmTailSlash(String originPath) {
        return FilePath.rmTailSlash(originPath, true);
    }

    public static String rmTailSlash(String originPath, boolean isNeedMerge) {
        String path;
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        String string = path = isNeedMerge ? FilePath.mergeRepeated(originPath) : originPath;
        if (path.equals("/")) {
            return path;
        }
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public static String rmHeadSlash(String originPath) {
        return FilePath.rmHeadSlash(originPath, true);
    }

    public static String rmHeadSlash(String originPath, boolean isNeedMerge) {
        String path;
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        String string = path = isNeedMerge ? FilePath.mergeRepeated(originPath) : originPath;
        if (path.equals("/")) {
            return path;
        }
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static String addHeadSlash(String originPath) {
        return FilePath.addHeadSlash(originPath, true);
    }

    public static String addHeadSlash(String originPath, boolean isNeedMerge) {
        String path;
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        String string = path = isNeedMerge ? FilePath.mergeRepeated(originPath) : originPath;
        if (path.equals("/")) {
            return path;
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public static String addTailSlash(String originPath) {
        return FilePath.addTailSlash(originPath, true);
    }

    public static String addTailSlash(String originPath, boolean isNeedMerge) {
        String path;
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        String string = path = isNeedMerge ? FilePath.mergeRepeated(originPath) : originPath;
        if (path.equals("/")) {
            return path;
        }
        return path.endsWith("/") ? path : path + "/";
    }

    public static String backslashToSlash(String originPath) {
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        return FilePath.mergeSlash(originPath.replaceAll("\\\\+", "/"), true);
    }

    public static String slashToBackslash(String originPath) {
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        return FilePath.mergeSlash(originPath.replaceAll("/+", TWOBACKSLASH), false);
    }

    public static String mergeRepeated(String originPath) {
        return FilePath.mergeDotSlash(FilePath.mergeSlash(originPath, true));
    }

    public static String mergeSlash(String originPath, boolean whetherMergeSlash) {
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        String mergeChar = whetherMergeSlash ? "/" : TWOBACKSLASH;
        return originPath.replaceAll(mergeChar + "+", mergeChar);
    }

    public static String mergeDotSlash(String originPath) {
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        return originPath.replaceAll("/(\\./)+", "/");
    }

    public static String mergeDotBackslash(String originPath) {
        if (G.isEmpty((CharSequence)originPath)) {
            return originPath;
        }
        return originPath.replaceAll("\\\\(\\.\\\\)+", TWOBACKSLASH);
    }

    public static String[] exts(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (S.isEmpty((CharSequence)fileName) || ONLY_DOT_PATTERN.matcher(fileName).matches() || fileName.endsWith("/") || fileName.endsWith(BACKSLASH)) {
            return new String[0];
        }
        return fileName.split(BACKSLASHDOT, -1);
    }

    public static String ext(String fileName) {
        String extNoDot = FilePath.extNoDot(fileName);
        return extNoDot == null ? extNoDot : DOT + extNoDot;
    }

    public static String extNoDot(String fileName) {
        String[] exts = FilePath.exts(fileName);
        if (exts == null || exts.length <= 1) {
            return null;
        }
        String tempExt = exts[exts.length - 1];
        return SLASH_PATTERN.matcher(tempExt).find() ? null : tempExt;
    }

    private static void verifyParams(String firstPath, String ... subPaths) {
        if (S.isEmpty((CharSequence)firstPath) || S.hasEmpty((CharSequence[])subPaths)) {
            throw new NullPointerException("`firstPath` or `subPaths` must be not empty! \u53c2\u6570`firstPath` or `subPaths`\u5fc5\u987b\u662f\u975e\u7a7a\uff01");
        }
    }
}

