/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.io;

import com.iofairy.falcon.io.MultiByteArrayInputStream;
import com.iofairy.falcon.io.MultiByteArrayOutputStream;
import com.iofairy.top.G;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class IOs {
    public static final int EOF = -1;
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static MultiByteArrayInputStream toMultiBAIS(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "Parameter `inputStream` must be non-null!");
        MultiByteArrayOutputStream multiBaos = new MultiByteArrayOutputStream();
        IOs.copy(inputStream, multiBaos);
        return new MultiByteArrayInputStream(multiBaos.toByteArrays());
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOs.copy(inputStream, outputStream, new byte[8192]);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        return IOs.copy(inputStream, outputStream, new byte[bufferSize]);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int n;
        if (G.hasNull((Object[])new Object[]{inputStream, outputStream})) {
            throw new RuntimeException("Parameters `inputStream`, `outputStream` must be non-null!");
        }
        long count = 0L;
        while ((n = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

