/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MultiByteArrayInputStream
extends InputStream {
    protected List<ByteArrayInputStream> baisList = new ArrayList<ByteArrayInputStream>();
    protected long pos;
    protected long mark = 0L;
    protected long count;

    public MultiByteArrayInputStream(byte[] ... bufs) {
        if (bufs == null || Arrays.stream(bufs).anyMatch(Objects::isNull)) {
            throw new NullPointerException("Parameter `bufs` must be non-null, and any elements in the `bufs` must be non-null too! ");
        }
        long countSum = 0L;
        if (bufs.length == 0) {
            this.baisList.add(new ByteArrayInputStream(new byte[0]));
        } else {
            for (byte[] buf : bufs) {
                this.baisList.add(new ByteArrayInputStream(buf));
                countSum += (long)buf.length;
            }
        }
        this.pos = 0L;
        this.count = countSum;
    }

    @Override
    public synchronized int read() {
        if (this.pos < this.count) {
            ++this.pos;
            return this.baisList.get(this.findFirstAvailableGreaterThan0()).read();
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        int firstAvailableGreaterThan0;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        long totalAvailable = this.count - this.pos;
        if ((long)len > totalAvailable) {
            len = (int)totalAvailable;
        }
        if (len <= 0) {
            return 0;
        }
        int tmpLen = len;
        while ((firstAvailableGreaterThan0 = this.findFirstAvailableGreaterThan0()) != -1) {
            ByteArrayInputStream bais = this.baisList.get(firstAvailableGreaterThan0);
            int available = bais.available();
            if (tmpLen > available) {
                int readLen = bais.read(b, off, available);
                off += readLen;
                tmpLen -= readLen;
                continue;
            }
            bais.read(b, off, tmpLen);
            break;
        }
        this.pos += (long)len;
        return len;
    }

    private int findFirstAvailableGreaterThan0() {
        for (int i = 0; i < this.baisList.size(); ++i) {
            if (this.baisList.get(i).available() <= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        long tmpK = k;
        for (ByteArrayInputStream bais : this.baisList) {
            if (tmpK < 0L) break;
            int available = bais.available();
            if (available <= 0) continue;
            if (tmpK <= (long)available) {
                bais.skip(tmpK);
                break;
            }
            tmpK -= bais.skip(available);
        }
        this.pos += k;
        return k;
    }

    @Override
    public synchronized int available() {
        long availableBytes = this.count - this.pos;
        return availableBytes >= 0x7FFFFFF7L ? 0x7FFFFFF7 : (int)availableBytes;
    }

    public synchronized long availableBytes() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readAheadLimit) {
        this.mark = this.pos;
        this.baisList.forEach(bais -> bais.mark(readAheadLimit));
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
        this.baisList.forEach(ByteArrayInputStream::reset);
    }

    @Override
    public void close() throws IOException {
        Exception e = null;
        for (ByteArrayInputStream bais : this.baisList) {
            try {
                bais.close();
            }
            catch (Exception ex) {
                e = ex;
            }
        }
        if (e != null) {
            throw new IOException(e);
        }
    }
}

