/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiByteArrayOutputStream
extends OutputStream {
    protected List<ByteArrayOutputStream> baosList = new ArrayList<ByteArrayOutputStream>();
    protected long count;
    private static final int BUFFER_INITIALIZED_SIZE = 1024;

    public MultiByteArrayOutputStream() {
        this(1024);
    }

    public MultiByteArrayOutputStream(int size) {
        this.baosList.add(new ByteArrayOutputStream(size));
    }

    @Override
    public synchronized void write(int b) {
        try {
            this.baosList.get(this.baosList.size() - 1).write(b);
        }
        catch (OutOfMemoryError error) {
            this.baosList.add(new ByteArrayOutputStream(1024));
            this.baosList.get(this.baosList.size() - 1).write(b);
        }
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.baosList.get(this.baosList.size() - 1).write(b, off, len);
        }
        catch (OutOfMemoryError error) {
            this.baosList.add(new ByteArrayOutputStream(1024));
            this.baosList.get(this.baosList.size() - 1).write(b, off, len);
        }
        this.count += (long)len;
    }

    public synchronized void reset() {
        this.count = 0L;
        this.baosList.forEach(ByteArrayOutputStream::reset);
        this.baosList.clear();
        this.baosList.add(new ByteArrayOutputStream(1024));
    }

    public synchronized byte[][] toByteArrays() {
        byte[][] byteArrays = new byte[this.baosList.size()][];
        for (int i = 0; i < this.baosList.size(); ++i) {
            byteArrays[i] = this.baosList.get(i).toByteArray();
        }
        return byteArrays;
    }

    public synchronized long size() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        Exception e = null;
        for (ByteArrayOutputStream baos : this.baosList) {
            try {
                baos.close();
            }
            catch (Exception ex) {
                e = ex;
            }
        }
        if (e != null) {
            throw new IOException(e);
        }
    }
}

