/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.iterable;

import com.iofairy.falcon.iterable.ToArrayMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PrimitiveArrays {
    public static char[] toChars(ToArrayMode toArrayMode, Collection<Character> chars) {
        if (chars == null) {
            return null;
        }
        if (chars.size() == 0) {
            return new char[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        char[] cs = new char[chars.size()];
        int index = 0;
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (Character c : chars) {
                    cs[index] = c.charValue();
                    ++index;
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (Character c : chars) {
                    cs[index] = c == null ? (char)'\u0000' : c.charValue();
                    ++index;
                }
                break;
            }
            default: {
                Character[] characterArray = (Character[])chars.stream().filter(Objects::nonNull).toArray(Character[]::new);
                cs = new char[characterArray.length];
                for (int i = 0; i < characterArray.length; ++i) {
                    cs[i] = characterArray[i].charValue();
                }
            }
        }
        return cs;
    }

    public static char[] toChars(char valueForNull, Collection<Character> chars) {
        if (chars == null) {
            return null;
        }
        if (chars.size() == 0) {
            return new char[0];
        }
        char[] cs = new char[chars.size()];
        int index = 0;
        for (Character c : chars) {
            cs[index] = c == null ? valueForNull : c.charValue();
            ++index;
        }
        return cs;
    }

    public static char[] toChars(ToArrayMode toArrayMode, Character ... chars) {
        if (chars == null) {
            return null;
        }
        if (chars.length == 0) {
            return new char[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        char[] cs = new char[chars.length];
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (int i = 0; i < chars.length; ++i) {
                    cs[i] = chars[i].charValue();
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (int i = 0; i < chars.length; ++i) {
                    Character c = chars[i];
                    cs[i] = c == null ? (char)'\u0000' : c.charValue();
                }
                break;
            }
            default: {
                Character[] characterArray = (Character[])Arrays.stream(chars).filter(Objects::nonNull).toArray(Character[]::new);
                cs = new char[characterArray.length];
                for (int i = 0; i < characterArray.length; ++i) {
                    cs[i] = characterArray[i].charValue();
                }
            }
        }
        return cs;
    }

    public static char[] toChars(char valueForNull, Character ... chars) {
        if (chars == null) {
            return null;
        }
        if (chars.length == 0) {
            return new char[0];
        }
        char[] cs = new char[chars.length];
        int index = 0;
        for (Character c : chars) {
            cs[index] = c == null ? valueForNull : c.charValue();
            ++index;
        }
        return cs;
    }

    public static boolean[] toBooleans(ToArrayMode toArrayMode, Collection<Boolean> bools) {
        if (bools == null) {
            return null;
        }
        if (bools.size() == 0) {
            return new boolean[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        boolean[] bs = new boolean[bools.size()];
        int index = 0;
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (Boolean b : bools) {
                    bs[index] = b;
                    ++index;
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (Boolean b : bools) {
                    bs[index] = b != null && b != false;
                    ++index;
                }
                break;
            }
            default: {
                Boolean[] booleanArray = (Boolean[])bools.stream().filter(Objects::nonNull).toArray(Boolean[]::new);
                bs = new boolean[booleanArray.length];
                for (int i = 0; i < booleanArray.length; ++i) {
                    bs[i] = booleanArray[i];
                }
            }
        }
        return bs;
    }

    public static boolean[] toBooleans(boolean valueForNull, Collection<Boolean> bools) {
        if (bools == null) {
            return null;
        }
        if (bools.size() == 0) {
            return new boolean[0];
        }
        boolean[] bs = new boolean[bools.size()];
        int index = 0;
        for (Boolean b : bools) {
            bs[index] = b == null ? valueForNull : b;
            ++index;
        }
        return bs;
    }

    public static boolean[] toBooleans(ToArrayMode toArrayMode, Boolean ... bools) {
        if (bools == null) {
            return null;
        }
        if (bools.length == 0) {
            return new boolean[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        boolean[] bs = new boolean[bools.length];
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (int i = 0; i < bools.length; ++i) {
                    bs[i] = bools[i];
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (int i = 0; i < bools.length; ++i) {
                    Boolean b = bools[i];
                    bs[i] = b != null && b != false;
                }
                break;
            }
            default: {
                Boolean[] booleanArray = (Boolean[])Arrays.stream(bools).filter(Objects::nonNull).toArray(Boolean[]::new);
                bs = new boolean[booleanArray.length];
                for (int i = 0; i < booleanArray.length; ++i) {
                    bs[i] = booleanArray[i];
                }
            }
        }
        return bs;
    }

    public static boolean[] toBooleans(boolean valueForNull, Boolean ... bools) {
        if (bools == null) {
            return null;
        }
        if (bools.length == 0) {
            return new boolean[0];
        }
        boolean[] bs = new boolean[bools.length];
        int index = 0;
        for (Boolean b : bools) {
            bs[index] = b == null ? valueForNull : b;
            ++index;
        }
        return bs;
    }

    public static byte[] toBytes(ToArrayMode toArrayMode, Collection<Byte> bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.size() == 0) {
            return new byte[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        byte[] bs = new byte[bytes.size()];
        int index = 0;
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (Byte b : bytes) {
                    bs[index] = b;
                    ++index;
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (Byte b : bytes) {
                    bs[index] = b == null ? (byte)0 : b;
                    ++index;
                }
                break;
            }
            default: {
                Byte[] byteArray = (Byte[])bytes.stream().filter(Objects::nonNull).toArray(Byte[]::new);
                bs = new byte[byteArray.length];
                for (int i = 0; i < byteArray.length; ++i) {
                    bs[i] = byteArray[i];
                }
            }
        }
        return bs;
    }

    public static byte[] toBytes(byte valueForNull, Collection<Byte> bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.size() == 0) {
            return new byte[0];
        }
        byte[] bs = new byte[bytes.size()];
        int index = 0;
        for (Byte b : bytes) {
            bs[index] = b == null ? valueForNull : b;
            ++index;
        }
        return bs;
    }

    public static byte[] toBytes(ToArrayMode toArrayMode, Byte ... bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return new byte[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        byte[] bs = new byte[bytes.length];
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (int i = 0; i < bytes.length; ++i) {
                    bs[i] = bytes[i];
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (int i = 0; i < bytes.length; ++i) {
                    Byte b = bytes[i];
                    bs[i] = b == null ? (byte)0 : b;
                }
                break;
            }
            default: {
                Byte[] byteArray = (Byte[])Arrays.stream(bytes).filter(Objects::nonNull).toArray(Byte[]::new);
                bs = new byte[byteArray.length];
                for (int i = 0; i < byteArray.length; ++i) {
                    bs[i] = byteArray[i];
                }
            }
        }
        return bs;
    }

    public static byte[] toBytes(byte valueForNull, Byte ... bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return new byte[0];
        }
        byte[] bs = new byte[bytes.length];
        int index = 0;
        for (Byte b : bytes) {
            bs[index] = b == null ? valueForNull : b;
            ++index;
        }
        return bs;
    }

    public static short[] toShorts(ToArrayMode toArrayMode, Collection<Short> shorts) {
        if (shorts == null) {
            return null;
        }
        if (shorts.size() == 0) {
            return new short[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        short[] ss = new short[shorts.size()];
        int index = 0;
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (Short s : shorts) {
                    ss[index] = s;
                    ++index;
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (Short s : shorts) {
                    ss[index] = s == null ? (short)0 : s;
                    ++index;
                }
                break;
            }
            default: {
                Short[] shortArray = (Short[])shorts.stream().filter(Objects::nonNull).toArray(Short[]::new);
                ss = new short[shortArray.length];
                for (int i = 0; i < shortArray.length; ++i) {
                    ss[i] = shortArray[i];
                }
            }
        }
        return ss;
    }

    public static short[] toShorts(short valueForNull, Collection<Short> shorts) {
        if (shorts == null) {
            return null;
        }
        if (shorts.size() == 0) {
            return new short[0];
        }
        short[] ss = new short[shorts.size()];
        int index = 0;
        for (Short s : shorts) {
            ss[index] = s == null ? valueForNull : s;
            ++index;
        }
        return ss;
    }

    public static short[] toShorts(ToArrayMode toArrayMode, Short ... shorts) {
        if (shorts == null) {
            return null;
        }
        if (shorts.length == 0) {
            return new short[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        short[] ss = new short[shorts.length];
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (int i = 0; i < shorts.length; ++i) {
                    ss[i] = shorts[i];
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (int i = 0; i < shorts.length; ++i) {
                    Short s = shorts[i];
                    ss[i] = s == null ? (short)0 : s;
                }
                break;
            }
            default: {
                Short[] shortArray = (Short[])Arrays.stream(shorts).filter(Objects::nonNull).toArray(Short[]::new);
                ss = new short[shortArray.length];
                for (int i = 0; i < shortArray.length; ++i) {
                    ss[i] = shortArray[i];
                }
            }
        }
        return ss;
    }

    public static short[] toShorts(short valueForNull, Short ... shorts) {
        if (shorts == null) {
            return null;
        }
        if (shorts.length == 0) {
            return new short[0];
        }
        short[] ss = new short[shorts.length];
        int index = 0;
        for (Short s : shorts) {
            ss[index] = s == null ? valueForNull : s;
            ++index;
        }
        return ss;
    }

    public static int[] toInts(ToArrayMode toArrayMode, Collection<Integer> ints) {
        if (ints == null) {
            return null;
        }
        if (ints.size() == 0) {
            return new int[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        int[] is = new int[ints.size()];
        int index = 0;
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (Integer i : ints) {
                    is[index] = i;
                    ++index;
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (Integer i : ints) {
                    is[index] = i == null ? 0 : i;
                    ++index;
                }
                break;
            }
            default: {
                is = ints.stream().filter(Objects::nonNull).mapToInt(Integer::intValue).toArray();
            }
        }
        return is;
    }

    public static int[] toInts(int valueForNull, Collection<Integer> ints) {
        if (ints == null) {
            return null;
        }
        if (ints.size() == 0) {
            return new int[0];
        }
        int[] is = new int[ints.size()];
        int index = 0;
        for (Integer i : ints) {
            is[index] = i == null ? valueForNull : i;
            ++index;
        }
        return is;
    }

    public static int[] toInts(ToArrayMode toArrayMode, Integer ... ints) {
        if (ints == null) {
            return null;
        }
        if (ints.length == 0) {
            return new int[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        int[] is = new int[ints.length];
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (int i = 0; i < ints.length; ++i) {
                    is[i] = ints[i];
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (int i = 0; i < ints.length; ++i) {
                    Integer integer = ints[i];
                    is[i] = integer == null ? 0 : integer;
                }
                break;
            }
            default: {
                is = Arrays.stream(ints).filter(Objects::nonNull).mapToInt(Integer::intValue).toArray();
            }
        }
        return is;
    }

    public static int[] toInts(int valueForNull, Integer ... ints) {
        if (ints == null) {
            return null;
        }
        if (ints.length == 0) {
            return new int[0];
        }
        int[] is = new int[ints.length];
        int index = 0;
        for (Integer i : ints) {
            is[index] = i == null ? valueForNull : i;
            ++index;
        }
        return is;
    }

    public static float[] toFloats(ToArrayMode toArrayMode, Collection<Float> floats) {
        if (floats == null) {
            return null;
        }
        if (floats.size() == 0) {
            return new float[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        float[] fs = new float[floats.size()];
        int index = 0;
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (Float f : floats) {
                    fs[index] = f.floatValue();
                    ++index;
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (Float f : floats) {
                    fs[index] = f == null ? 0.0f : f.floatValue();
                    ++index;
                }
                break;
            }
            default: {
                Float[] floatArray = (Float[])floats.stream().filter(Objects::nonNull).toArray(Float[]::new);
                fs = new float[floatArray.length];
                for (int i = 0; i < floatArray.length; ++i) {
                    fs[i] = floatArray[i].floatValue();
                }
            }
        }
        return fs;
    }

    public static float[] toFloats(float valueForNull, Collection<Float> floats) {
        if (floats == null) {
            return null;
        }
        if (floats.size() == 0) {
            return new float[0];
        }
        float[] fs = new float[floats.size()];
        int index = 0;
        for (Float f : floats) {
            fs[index] = f == null ? valueForNull : f.floatValue();
            ++index;
        }
        return fs;
    }

    public static float[] toFloats(ToArrayMode toArrayMode, Float ... floats) {
        if (floats == null) {
            return null;
        }
        if (floats.length == 0) {
            return new float[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        float[] fs = new float[floats.length];
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (int i = 0; i < floats.length; ++i) {
                    fs[i] = floats[i].floatValue();
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (int i = 0; i < floats.length; ++i) {
                    Float f = floats[i];
                    fs[i] = f == null ? 0.0f : f.floatValue();
                }
                break;
            }
            default: {
                Float[] floatArray = (Float[])Arrays.stream(floats).filter(Objects::nonNull).toArray(Float[]::new);
                fs = new float[floatArray.length];
                for (int i = 0; i < floatArray.length; ++i) {
                    fs[i] = floatArray[i].floatValue();
                }
            }
        }
        return fs;
    }

    public static float[] toFloats(float valueForNull, Float ... floats) {
        if (floats == null) {
            return null;
        }
        if (floats.length == 0) {
            return new float[0];
        }
        float[] fs = new float[floats.length];
        int index = 0;
        for (Float f : floats) {
            fs[index] = f == null ? valueForNull : f.floatValue();
            ++index;
        }
        return fs;
    }

    public static long[] toLongs(ToArrayMode toArrayMode, Collection<Long> longs) {
        if (longs == null) {
            return null;
        }
        if (longs.size() == 0) {
            return new long[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        long[] ls = new long[longs.size()];
        int index = 0;
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (Long l : longs) {
                    ls[index] = l;
                    ++index;
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (Long l : longs) {
                    ls[index] = l == null ? 0L : l;
                    ++index;
                }
                break;
            }
            default: {
                ls = longs.stream().filter(Objects::nonNull).mapToLong(Long::longValue).toArray();
            }
        }
        return ls;
    }

    public static long[] toLongs(long valueForNull, Collection<Long> longs) {
        if (longs == null) {
            return null;
        }
        if (longs.size() == 0) {
            return new long[0];
        }
        long[] ls = new long[longs.size()];
        int index = 0;
        for (Long l : longs) {
            ls[index] = l == null ? valueForNull : l;
            ++index;
        }
        return ls;
    }

    public static long[] toLongs(ToArrayMode toArrayMode, Long ... longs) {
        if (longs == null) {
            return null;
        }
        if (longs.length == 0) {
            return new long[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        long[] ls = new long[longs.length];
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (int i = 0; i < longs.length; ++i) {
                    ls[i] = longs[i];
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (int i = 0; i < longs.length; ++i) {
                    Long l = longs[i];
                    ls[i] = l == null ? 0L : l;
                }
                break;
            }
            default: {
                ls = Arrays.stream(longs).filter(Objects::nonNull).mapToLong(Long::longValue).toArray();
            }
        }
        return ls;
    }

    public static long[] toLongs(long valueForNull, Long ... longs) {
        if (longs == null) {
            return null;
        }
        if (longs.length == 0) {
            return new long[0];
        }
        long[] ls = new long[longs.length];
        int index = 0;
        for (Long l : longs) {
            ls[index] = l == null ? valueForNull : l;
            ++index;
        }
        return ls;
    }

    public static double[] toDoubles(ToArrayMode toArrayMode, Collection<Double> doubles) {
        if (doubles == null) {
            return null;
        }
        if (doubles.size() == 0) {
            return new double[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        double[] ds = new double[doubles.size()];
        int index = 0;
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (Double d : doubles) {
                    ds[index] = d;
                    ++index;
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (Double d : doubles) {
                    ds[index] = d == null ? 0.0 : d;
                    ++index;
                }
                break;
            }
            default: {
                ds = doubles.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).toArray();
            }
        }
        return ds;
    }

    public static double[] toDoubles(double valueForNull, Collection<Double> doubles) {
        if (doubles == null) {
            return null;
        }
        if (doubles.size() == 0) {
            return new double[0];
        }
        double[] ds = new double[doubles.size()];
        int index = 0;
        for (Double d : doubles) {
            ds[index] = d == null ? valueForNull : d;
            ++index;
        }
        return ds;
    }

    public static double[] toDoubles(ToArrayMode toArrayMode, Double ... doubles) {
        if (doubles == null) {
            return null;
        }
        if (doubles.length == 0) {
            return new double[0];
        }
        if (toArrayMode == null) {
            toArrayMode = ToArrayMode.IGNORE_NULL;
        }
        double[] ds = new double[doubles.length];
        switch (toArrayMode) {
            case THROW_WHEN_NULL: {
                for (int i = 0; i < doubles.length; ++i) {
                    ds[i] = doubles[i];
                }
                break;
            }
            case DEFAULT_VALUE: {
                for (int i = 0; i < doubles.length; ++i) {
                    Double d = doubles[i];
                    ds[i] = d == null ? 0.0 : d;
                }
                break;
            }
            default: {
                ds = Arrays.stream(doubles).filter(Objects::nonNull).mapToDouble(Double::doubleValue).toArray();
            }
        }
        return ds;
    }

    public static double[] toDoubles(double valueForNull, Double ... doubles) {
        if (doubles == null) {
            return null;
        }
        if (doubles.length == 0) {
            return new double[0];
        }
        double[] ds = new double[doubles.length];
        int index = 0;
        for (Double d : doubles) {
            ds[index] = d == null ? valueForNull : d;
            ++index;
        }
        return ds;
    }

    public static char[] toChars(CharSequence charSequence) {
        return charSequence == null ? null : charSequence.toString().toCharArray();
    }

    public static Character[] toObjects(char ... chars) {
        if (chars == null) {
            return null;
        }
        Character[] cs = new Character[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            cs[i] = Character.valueOf(chars[i]);
        }
        return cs;
    }

    public static Boolean[] toObjects(boolean ... booleans) {
        if (booleans == null) {
            return null;
        }
        Boolean[] bs = new Boolean[booleans.length];
        for (int i = 0; i < booleans.length; ++i) {
            bs[i] = booleans[i];
        }
        return bs;
    }

    public static Byte[] toObjects(byte ... bytes) {
        if (bytes == null) {
            return null;
        }
        Byte[] bs = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bs[i] = bytes[i];
        }
        return bs;
    }

    public static Short[] toObjects(short ... shorts) {
        if (shorts == null) {
            return null;
        }
        Short[] ss = new Short[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            ss[i] = shorts[i];
        }
        return ss;
    }

    public static Integer[] toObjects(int ... ints) {
        if (ints == null) {
            return null;
        }
        Integer[] is = new Integer[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            is[i] = ints[i];
        }
        return is;
    }

    public static Long[] toObjects(long ... longs) {
        if (longs == null) {
            return null;
        }
        Long[] ls = new Long[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            ls[i] = longs[i];
        }
        return ls;
    }

    public static Float[] toObjects(float ... floats) {
        if (floats == null) {
            return null;
        }
        Float[] fs = new Float[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            fs[i] = Float.valueOf(floats[i]);
        }
        return fs;
    }

    public static Double[] toObjects(double ... doubles) {
        if (doubles == null) {
            return null;
        }
        Double[] ds = new Double[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            ds[i] = doubles[i];
        }
        return ds;
    }

    public static List<Character> asList(char ... chars) {
        if (chars == null) {
            return null;
        }
        ArrayList<Character> cs = new ArrayList<Character>();
        for (char c : chars) {
            cs.add(Character.valueOf(c));
        }
        return cs;
    }

    public static List<Boolean> asList(boolean ... booleans) {
        if (booleans == null) {
            return null;
        }
        ArrayList<Boolean> bs = new ArrayList<Boolean>();
        for (boolean b : booleans) {
            bs.add(b);
        }
        return bs;
    }

    public static List<Byte> asList(byte ... bytes) {
        if (bytes == null) {
            return null;
        }
        ArrayList<Byte> bs = new ArrayList<Byte>();
        for (byte b : bytes) {
            bs.add(b);
        }
        return bs;
    }

    public static List<Short> asList(short ... shorts) {
        if (shorts == null) {
            return null;
        }
        ArrayList<Short> ss = new ArrayList<Short>();
        for (short s : shorts) {
            ss.add(s);
        }
        return ss;
    }

    public static List<Integer> asList(int ... ints) {
        if (ints == null) {
            return null;
        }
        ArrayList<Integer> is = new ArrayList<Integer>();
        for (int i : ints) {
            is.add(i);
        }
        return is;
    }

    public static List<Long> asList(long ... longs) {
        if (longs == null) {
            return null;
        }
        ArrayList<Long> ls = new ArrayList<Long>();
        for (long l : longs) {
            ls.add(l);
        }
        return ls;
    }

    public static List<Float> asList(float ... floats) {
        if (floats == null) {
            return null;
        }
        ArrayList<Float> fs = new ArrayList<Float>();
        for (float f : floats) {
            fs.add(Float.valueOf(f));
        }
        return fs;
    }

    public static List<Double> asList(double ... doubles) {
        if (doubles == null) {
            return null;
        }
        ArrayList<Double> ds = new ArrayList<Double>();
        for (double d : doubles) {
            ds.add(d);
        }
        return ds;
    }
}

