/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.os;

public enum JavaVersion {
    JAVA_0("1.0", "1.0", 1.0f, "1996-01-23"),
    JAVA_1("1.1", "1.1", 1.1f, "1997-02-19"),
    JAVA_2("1.2", "1.2", 1.2f, "1998-12-08"),
    JAVA_3("1.3", "1.3", 1.3f, "2000-05-08"),
    JAVA_4("1.4", "1.4", 1.4f, "2002-02-06"),
    JAVA_5("1.5", "5", 1.5f, "2004-09-30"),
    JAVA_6("1.6", "6", 1.6f, "2006-12-11"),
    JAVA_7("1.7", "7", 1.7f, "2011-07-28"),
    JAVA_8("1.8", "8", 1.8f, "2014-03-18"),
    JAVA_9("9", "9", 9.0f, "2017-09-21"),
    JAVA_10("10", "10", 10.0f, "2018-03-20"),
    JAVA_11("11", "11", 11.0f, "2018-09-25"),
    JAVA_12("12", "12", 12.0f, "2019-03-19"),
    JAVA_13("13", "13", 13.0f, "2019-09-17"),
    JAVA_14("14", "14", 14.0f, "2020-03-17"),
    JAVA_15("15", "15", 15.0f, "2020-09-15"),
    JAVA_16("16", "16", 16.0f, "2021-03-16"),
    JAVA_17("17", "17", 17.0f, "2021-09-14"),
    JAVA_18("18", "18", 18.0f, "2022-03-22"),
    JAVA_19("19", "19", 18.0f, "2022-09-20");

    public final String name;
    public final String alias;
    public final float version;
    public final String releaseDate;

    private JavaVersion(String name, String alias, float version, String releaseDate) {
        this.name = name;
        this.alias = alias;
        this.version = version;
        this.releaseDate = releaseDate;
    }

    public static JavaVersion of(String versionName) {
        if (versionName == null) {
            return null;
        }
        switch (versionName) {
            case "1.0": {
                return JAVA_0;
            }
            case "1.1": {
                return JAVA_1;
            }
            case "1.2": {
                return JAVA_2;
            }
            case "1.3": {
                return JAVA_3;
            }
            case "1.4": {
                return JAVA_4;
            }
            case "1.5": {
                return JAVA_5;
            }
            case "1.6": {
                return JAVA_6;
            }
            case "1.7": {
                return JAVA_7;
            }
            case "1.8": {
                return JAVA_8;
            }
            case "9": {
                return JAVA_9;
            }
            case "10": {
                return JAVA_10;
            }
            case "11": {
                return JAVA_11;
            }
            case "12": {
                return JAVA_12;
            }
            case "13": {
                return JAVA_13;
            }
            case "14": {
                return JAVA_14;
            }
            case "15": {
                return JAVA_15;
            }
            case "16": {
                return JAVA_16;
            }
            case "17": {
                return JAVA_17;
            }
            case "18": {
                return JAVA_18;
            }
        }
        return null;
    }

    public static int compare(JavaVersion javaVersion1, JavaVersion javaVersion2) {
        return Float.compare(javaVersion1.version, javaVersion2.version);
    }

    public boolean gte(JavaVersion javaVersion) {
        return this.version >= javaVersion.version;
    }

    public boolean lte(JavaVersion javaVersion) {
        return this.version <= javaVersion.version;
    }

    public boolean gt(JavaVersion javaVersion) {
        return this.version > javaVersion.version;
    }

    public boolean lt(JavaVersion javaVersion) {
        return this.version < javaVersion.version;
    }

    public boolean eq(JavaVersion javaVersion) {
        return this.version == javaVersion.version;
    }

    public boolean neq(JavaVersion javaVersion) {
        return this.version != javaVersion.version;
    }
}

