/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class CollectorKit {
    public static final Collector.Characteristics[] CH_ALL = new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH};
    public static final Collector.Characteristics[] CH_CONCURRENT_UNORDERED = new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED};
    public static final Collector.Characteristics[] CH_CONCURRENT_ID = new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT, Collector.Characteristics.IDENTITY_FINISH};
    public static final Collector.Characteristics[] CH_UNORDERED_ID = new Collector.Characteristics[]{Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH};
    public static final Collector.Characteristics[] CH_CONCURRENT = new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT};
    public static final Collector.Characteristics[] CH_UNORDERED = new Collector.Characteristics[]{Collector.Characteristics.UNORDERED};
    public static final Collector.Characteristics[] CH_ID = new Collector.Characteristics[]{Collector.Characteristics.IDENTITY_FINISH};
    public static final Collector.Characteristics[] CH_EMPTY = new Collector.Characteristics[0];

    private CollectorKit() {
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingByAllowNullKey(Function<? super T, ? extends K> classifier) {
        return Collectors.toMap(classifier, Collections::singletonList, (oldList, newList) -> {
            ArrayList resultList = new ArrayList(oldList.size() + 1);
            resultList.addAll(oldList);
            resultList.addAll(newList);
            return resultList;
        });
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Supplier<M> mapSupplier, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, boolean isAllowDuplicateKeys) {
        Collector.Characteristics[] characteristics = mapSupplier.get() instanceof ConcurrentMap ? CH_ALL : CH_ID;
        BiConsumer<Map, Object> accumulator = (map, element) -> {
            Object key = keyMapper.apply(element);
            if (!isAllowDuplicateKeys && map.containsKey(key)) {
                CollectorKit.throwDuplicateKeyException(key);
            }
            map.put(key, valueMapper.apply(element));
        };
        return Collector.of(mapSupplier, accumulator, (map1, map2) -> {
            map2.forEach((k, v) -> {
                if (!isAllowDuplicateKeys && map1.containsKey(k)) {
                    CollectorKit.throwDuplicateKeyException(k);
                }
                map1.put(k, v);
            });
            return map1;
        }, characteristics);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return CollectorKit.toMap(() -> new HashMap(), keyMapper, valueMapper, false);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, boolean isAllowDuplicateKeys) {
        return CollectorKit.toMap(() -> new HashMap(), keyMapper, valueMapper, isAllowDuplicateKeys);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return CollectorKit.toMap(() -> new LinkedHashMap(), keyMapper, valueMapper, false);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, boolean isAllowDuplicateKeys) {
        return CollectorKit.toMap(() -> new LinkedHashMap(), keyMapper, valueMapper, isAllowDuplicateKeys);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return CollectorKit.toMap(() -> new ConcurrentHashMap(), keyMapper, valueMapper, false);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, boolean isAllowDuplicateKeys) {
        return CollectorKit.toMap(() -> new ConcurrentHashMap(), keyMapper, valueMapper, isAllowDuplicateKeys);
    }

    private static void throwDuplicateKeyException(Object key) {
        throw new IllegalStateException(String.format("Duplicate key: `%s`", key));
    }
}

