/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.falcon.time.DateTime;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public interface ChronoInterval
extends TemporalAmount,
Serializable {
    default public Date addTo(Date date) {
        Objects.requireNonNull(date, "Parameter `date` must be non-null!");
        return Date.from((Instant)this.addTo(date.toInstant()));
    }

    default public Calendar addTo(Calendar calendar) {
        Objects.requireNonNull(calendar, "Parameter `calendar` must be non-null!");
        return DateTime.from(this.addTo(DateTime.from(calendar).getZonedDateTime())).toCalendar(calendar.getTimeZone().toZoneId());
    }

    default public <T> DateTime<T> addTo(DateTime<T> dateTime) {
        Objects.requireNonNull(dateTime, "Parameter `dateTime` must be non-null!");
        T dt = dateTime.get();
        if (dt instanceof Date) {
            return DateTime.from(this.addTo((Date)dt));
        }
        if (dt instanceof Calendar) {
            return DateTime.from(this.addTo((Calendar)dt));
        }
        return DateTime.from(this.addTo((Temporal)dt));
    }

    default public <T extends Temporal> T plusTo(T temporal) {
        return (T)this.addTo(temporal);
    }

    default public Date subtractFrom(Date date) {
        Objects.requireNonNull(date, "Parameter `date` must be non-null!");
        return Date.from((Instant)this.subtractFrom(date.toInstant()));
    }

    default public Calendar subtractFrom(Calendar calendar) {
        Objects.requireNonNull(calendar, "Parameter `calendar` must be non-null!");
        return DateTime.from(this.subtractFrom(DateTime.from(calendar).getZonedDateTime())).toCalendar(calendar.getTimeZone().toZoneId());
    }

    default public <T> DateTime<T> subtractFrom(DateTime<T> dateTime) {
        Objects.requireNonNull(dateTime, "Parameter `dateTime` must be non-null!");
        T dt = dateTime.get();
        if (dt instanceof Date) {
            return DateTime.from(this.subtractFrom((Date)dt));
        }
        if (dt instanceof Calendar) {
            return DateTime.from(this.subtractFrom((Calendar)dt));
        }
        return DateTime.from(this.subtractFrom((Temporal)dt));
    }

    default public <T extends Temporal> T minusFrom(T temporal) {
        return (T)this.subtractFrom(temporal);
    }
}

