/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.except.UnexpectedParameterException;
import com.iofairy.falcon.range.IntervalType;
import com.iofairy.falcon.time.ChronoInterval;
import com.iofairy.falcon.time.DateTimePattern;
import com.iofairy.falcon.time.DateTimeRound;
import com.iofairy.falcon.time.DateTimeShift;
import com.iofairy.falcon.time.DateTimes;
import com.iofairy.falcon.time.RoundingDT;
import com.iofairy.falcon.time.TZ;
import com.iofairy.si.SI;
import com.iofairy.top.G;
import com.iofairy.top.S;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class DateTime<T>
implements Temporal,
Comparable<DateTime<?>>,
Serializable {
    private static final long serialVersionUID = 6206615563566L;
    private final T dateTime;
    private final LocalDateTime localDateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;
    private final Instant instant;
    private final ZonedDateTime zonedDateTime;
    private final OffsetDateTime offsetDateTime;
    private static final List<Class<?>> SUPPORTED_DATETIME = Arrays.asList(Date.class, Calendar.class, LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, Instant.class);
    private static final String SUPPORTED_DATETIME_STRING = SUPPORTED_DATETIME.stream().map(Class::getSimpleName).collect(Collectors.joining(", "));
    private static final List<String> EXCLUDED_CLASS_NAMES = Arrays.asList("java.sql.Date", "java.sql.Time");
    private static final String DT_PARSE_ERROR_MSG_TPL = "Text '${text}' could not be parsed, you can specify the DateTime `formatter` manually by calling `${method}`. ";

    public DateTime(T dateTime) {
        this(dateTime, true);
    }

    private DateTime(T dateTime, boolean checkValue) {
        if (checkValue) {
            Objects.requireNonNull(dateTime, "Parameter `dateTime` must be non-null!");
            if (SUPPORTED_DATETIME.stream().noneMatch(c -> c.isAssignableFrom(dateTime.getClass()))) {
                throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_DATETIME_STRING + "] is supported for `dateTime` parameter!");
            }
            if (EXCLUDED_CLASS_NAMES.contains(dateTime.getClass().getName())) {
                throw new UnsupportedTemporalTypeException(EXCLUDED_CLASS_NAMES + " are unsupported here, you can convert it to the `java.util.Date` first!");
            }
        }
        this.dateTime = this.getDateTime(dateTime);
        Tuple2<Instant, ZonedDateTime> zdtAndInstant = this.toZDTAndInstant();
        this.instant = (Instant)zdtAndInstant._1;
        this.zonedDateTime = (ZonedDateTime)zdtAndInstant._2;
        this.offset = this.zonedDateTime.getOffset();
        this.zone = this.zonedDateTime.getZone();
        if (this.dateTime instanceof OffsetDateTime) {
            this.offsetDateTime = (OffsetDateTime)this.dateTime;
            this.localDateTime = this.offsetDateTime.toLocalDateTime();
        } else {
            this.offsetDateTime = this.zonedDateTime.toOffsetDateTime();
            this.localDateTime = this.dateTime instanceof LocalDateTime ? (LocalDateTime)this.dateTime : this.zonedDateTime.toLocalDateTime();
        }
    }

    public static <T> DateTime<T> of(T dateTime) {
        return new DateTime<T>(dateTime, true);
    }

    static <T> DateTime<T> from(T dateTime) {
        return new DateTime<T>(dateTime, false);
    }

    private T getDateTime(T dt) {
        if (dt instanceof Date) {
            return (T)DateTimes.clone((Date)dt);
        }
        if (dt instanceof Calendar) {
            return (T)DateTimes.clone((Calendar)dt);
        }
        return dt;
    }

    public T get() {
        return this.getDateTime(this.dateTime);
    }

    public static DateTime<LocalDateTime> now() {
        return DateTime.from(LocalDateTime.now());
    }

    public static DateTime<Date> nowDate() {
        return DateTime.from(new Date());
    }

    public static DateTime<Instant> nowInstant() {
        return DateTime.from(Instant.now());
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public OffsetDateTime getOffsetDateTime() {
        return this.offsetDateTime;
    }

    private Tuple2<Instant, ZonedDateTime> toZDTAndInstant() {
        ZonedDateTime zdt = null;
        Instant ins = null;
        if (this.dateTime instanceof Calendar) {
            Calendar calendar = (Calendar)this.dateTime;
            ins = calendar.toInstant();
            zdt = ins.atZone(calendar.getTimeZone().toZoneId());
            return Tuple.of((Object)ins, (Object)zdt);
        }
        if (this.dateTime instanceof Date) {
            ins = ((Date)this.dateTime).toInstant();
            zdt = ins.atZone(TZ.DEFAULT_ZONE);
            return Tuple.of((Object)ins, (Object)zdt);
        }
        if (this.dateTime instanceof Instant) {
            ins = (Instant)this.dateTime;
            zdt = ZonedDateTime.ofInstant(ins, TZ.DEFAULT_ZONE);
            return Tuple.of((Object)ins, (Object)zdt);
        }
        if (this.dateTime instanceof LocalDateTime) {
            zdt = ((LocalDateTime)this.dateTime).atZone(TZ.DEFAULT_ZONE);
            ins = zdt.toInstant();
            return Tuple.of((Object)ins, (Object)zdt);
        }
        if (this.dateTime instanceof OffsetDateTime) {
            ins = ((OffsetDateTime)this.dateTime).toInstant();
            zdt = ((OffsetDateTime)this.dateTime).toZonedDateTime();
            return Tuple.of((Object)ins, (Object)zdt);
        }
        zdt = (ZonedDateTime)this.dateTime;
        ins = zdt.toInstant();
        return Tuple.of((Object)ins, (Object)zdt);
    }

    public ZonedDateTime toUTCZonedDT() {
        return this.toZonedDT(TZ.UTC);
    }

    public ZonedDateTime toDefaultZonedDT() {
        return this.toZonedDT(TZ.DEFAULT_ZONE);
    }

    public ZonedDateTime toZonedDT(ZoneId zoneId) {
        if (zoneId == null || this.zone.equals(zoneId)) {
            return this.zonedDateTime;
        }
        return this.zonedDateTime.withZoneSameInstant(zoneId);
    }

    public OffsetDateTime toUTCOffsetDT() {
        return this.toOffsetDT(ZoneOffset.UTC);
    }

    public OffsetDateTime toDefaultOffsetDT() {
        return this.toOffsetDT(DateTimes.defaultOffset());
    }

    public OffsetDateTime toOffsetDT(ZoneOffset zoneOffset) {
        if (zoneOffset == null || this.offset.equals(zoneOffset)) {
            return this.offsetDateTime;
        }
        return this.offsetDateTime.withOffsetSameInstant(zoneOffset);
    }

    public Calendar toUTCCalendar() {
        return this.toCalendar(TZ.UTC);
    }

    public Calendar toDefaultCalendar() {
        return this.toCalendar(TZ.DEFAULT_ZONE);
    }

    public Calendar toCalendar(ZoneId zoneId) {
        if (zoneId == null || this.zone.equals(zoneId)) {
            return this.dateTime instanceof Calendar ? (Calendar)this.get() : DateTimes.toCalendar(this.zonedDateTime);
        }
        if (this.dateTime instanceof Calendar) {
            Calendar calendar = (Calendar)this.get();
            calendar.setTimeZone(TimeZone.getTimeZone(zoneId));
            return calendar;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(zoneId));
        if (this.dateTime instanceof Date) {
            Date date = (Date)this.get();
            calendar.setTime(date);
            return calendar;
        }
        if (this.dateTime instanceof Instant) {
            calendar.setTimeInMillis(this.instant.toEpochMilli());
            return calendar;
        }
        return DateTimes.toCalendar(this.toZonedDT(zoneId));
    }

    Calendar toCalendar(Calendar calendar, ZonedDateTime zonedDateTime) {
        calendar.setTimeZone(TimeZone.getTimeZone(zonedDateTime.getZone()));
        calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
        return calendar;
    }

    public LocalDateTime toLocalDateTime() {
        return this.localDateTime;
    }

    public Date toDate() {
        if (this.dateTime instanceof Date) {
            return (Date)this.get();
        }
        if (this.dateTime instanceof Calendar) {
            return ((Calendar)this.get()).getTime();
        }
        return Date.from(this.instant);
    }

    public Instant toInstant() {
        return this.instant;
    }

    @Override
    public DateTime<T> plus(long amount, TemporalUnit unit) {
        if (amount == 0L) {
            return this;
        }
        if (this.dateTime instanceof Instant) {
            ZonedDateTime zdt = this.zonedDateTime.plus(amount, unit);
            return DateTime.from(zdt.toInstant());
        }
        if (this.dateTime instanceof Calendar) {
            ZonedDateTime zdt = this.zonedDateTime.plus(amount, unit);
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        if (this.dateTime instanceof Date) {
            ZonedDateTime zdt = this.zonedDateTime.plus(amount, unit);
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        return DateTime.from(((Temporal)this.dateTime).plus(amount, unit));
    }

    @Override
    public DateTime<T> plus(TemporalAmount amountToAdd) {
        if (amountToAdd instanceof ChronoInterval) {
            return ((ChronoInterval)amountToAdd).addTo(this);
        }
        if (this.dateTime instanceof Instant) {
            ZonedDateTime zdt = (ZonedDateTime)amountToAdd.addTo(this.zonedDateTime);
            return DateTime.from(zdt.toInstant());
        }
        if (this.dateTime instanceof Date) {
            ZonedDateTime zdt = (ZonedDateTime)amountToAdd.addTo(this.zonedDateTime);
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        if (this.dateTime instanceof Calendar) {
            ZonedDateTime zdt = (ZonedDateTime)amountToAdd.addTo(this.zonedDateTime);
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        return DateTime.from(amountToAdd.addTo((Temporal)this.dateTime));
    }

    public DateTime<T> plusYears(long years) {
        return this.plus(years, ChronoUnit.YEARS);
    }

    public DateTime<T> plusMonths(long months) {
        return this.plus(months, ChronoUnit.MONTHS);
    }

    public DateTime<T> plusDays(long days) {
        return this.plus(days, ChronoUnit.DAYS);
    }

    public DateTime<T> plusHours(long hours) {
        return this.plus(hours, ChronoUnit.HOURS);
    }

    public DateTime<T> plusMinutes(long minutes) {
        return this.plus(minutes, ChronoUnit.MINUTES);
    }

    public DateTime<T> plusSeconds(long seconds) {
        return this.plus(seconds, ChronoUnit.SECONDS);
    }

    public DateTime<T> plusMillis(long millis) {
        return this.plus(millis, ChronoUnit.MILLIS);
    }

    public DateTime<T> plusMicros(long micros) {
        return this.plus(micros, ChronoUnit.MICROS);
    }

    public DateTime<T> plusNanos(long nanos) {
        return this.plus(nanos, ChronoUnit.NANOS);
    }

    @Override
    public DateTime<T> minus(long amount, TemporalUnit unit) {
        if (amount == 0L) {
            return this;
        }
        if (this.dateTime instanceof Instant) {
            ZonedDateTime zdt = this.zonedDateTime.minus(amount, unit);
            return DateTime.from(zdt.toInstant());
        }
        if (this.dateTime instanceof Calendar) {
            ZonedDateTime zdt = this.zonedDateTime.minus(amount, unit);
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        if (this.dateTime instanceof Date) {
            ZonedDateTime zdt = this.zonedDateTime.minus(amount, unit);
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        return DateTime.from(((Temporal)this.dateTime).minus(amount, unit));
    }

    @Override
    public DateTime<T> minus(TemporalAmount amountToSubtract) {
        if (amountToSubtract instanceof ChronoInterval) {
            return ((ChronoInterval)amountToSubtract).subtractFrom(this);
        }
        if (this.dateTime instanceof Instant) {
            ZonedDateTime zdt = (ZonedDateTime)amountToSubtract.subtractFrom(this.zonedDateTime);
            return DateTime.from(zdt.toInstant());
        }
        if (this.dateTime instanceof Date) {
            ZonedDateTime zdt = (ZonedDateTime)amountToSubtract.subtractFrom(this.zonedDateTime);
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        if (this.dateTime instanceof Calendar) {
            ZonedDateTime zdt = (ZonedDateTime)amountToSubtract.subtractFrom(this.zonedDateTime);
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        return DateTime.from(amountToSubtract.subtractFrom((Temporal)this.dateTime));
    }

    public DateTime<T> minusYears(long years) {
        return this.minus(years, ChronoUnit.YEARS);
    }

    public DateTime<T> minusMonths(long months) {
        return this.minus(months, ChronoUnit.MONTHS);
    }

    public DateTime<T> minusDays(long days) {
        return this.minus(days, ChronoUnit.DAYS);
    }

    public DateTime<T> minusHours(long hours) {
        return this.minus(hours, ChronoUnit.HOURS);
    }

    public DateTime<T> minusMinutes(long minutes) {
        return this.minus(minutes, ChronoUnit.MINUTES);
    }

    public DateTime<T> minusSeconds(long seconds) {
        return this.minus(seconds, ChronoUnit.SECONDS);
    }

    public DateTime<T> minusMillis(long millis) {
        return this.minus(millis, ChronoUnit.MILLIS);
    }

    public DateTime<T> minusMicros(long micros) {
        return this.minus(micros, ChronoUnit.MICROS);
    }

    public DateTime<T> minusNanos(long nanos) {
        return this.minus(nanos, ChronoUnit.NANOS);
    }

    @Override
    public DateTime<T> with(TemporalAdjuster adjuster) {
        if (this.dateTime instanceof LocalDateTime || this.dateTime instanceof OffsetDateTime || this.dateTime instanceof ZonedDateTime) {
            return DateTime.from(((Temporal)this.dateTime).with(adjuster));
        }
        ZonedDateTime zdt = this.zonedDateTime.with(adjuster);
        if (this.dateTime instanceof Date) {
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        if (this.dateTime instanceof Calendar) {
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        return DateTime.from(zdt.toInstant());
    }

    @Override
    public DateTime<T> with(TemporalField field, long newValue) {
        if (this.dateTime instanceof LocalDateTime || this.dateTime instanceof OffsetDateTime || this.dateTime instanceof ZonedDateTime) {
            return DateTime.from(((Temporal)this.dateTime).with(field, newValue));
        }
        ZonedDateTime zdt = this.zonedDateTime.with(field, newValue);
        if (this.dateTime instanceof Date) {
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        if (this.dateTime instanceof Calendar) {
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        return DateTime.from(zdt.toInstant());
    }

    public DateTime<T> withYear(int year) {
        return this.with(ChronoField.YEAR, year);
    }

    public DateTime<T> withMonth(int month) {
        return this.with(ChronoField.MONTH_OF_YEAR, month);
    }

    public DateTime<T> withDayOfYear(int dayOfYear) {
        return this.with(ChronoField.DAY_OF_YEAR, dayOfYear);
    }

    public DateTime<T> withDayOfMonth(int dayOfMonth) {
        return this.with(ChronoField.DAY_OF_MONTH, dayOfMonth);
    }

    public DateTime<T> withHour(int hour) {
        return this.with(ChronoField.HOUR_OF_DAY, hour);
    }

    public DateTime<T> withMinute(int minute) {
        return this.with(ChronoField.MINUTE_OF_HOUR, minute);
    }

    public DateTime<T> withSecond(int second) {
        return this.with(ChronoField.SECOND_OF_MINUTE, second);
    }

    public DateTime<T> withNano(int nanoOfSecond) {
        return this.with(ChronoField.NANO_OF_SECOND, nanoOfSecond);
    }

    @Override
    public int get(TemporalField field) {
        if (this.dateTime instanceof LocalDateTime || this.dateTime instanceof OffsetDateTime || this.dateTime instanceof ZonedDateTime) {
            return ((Temporal)this.dateTime).get(field);
        }
        return this.zonedDateTime.get(field);
    }

    public int getYear() {
        return this.localDateTime.getYear();
    }

    public int getMonthValue() {
        return this.localDateTime.getMonthValue();
    }

    public Month getMonth() {
        return this.localDateTime.getMonth();
    }

    public int getDayOfYear() {
        return this.localDateTime.getDayOfYear();
    }

    public int getDayOfMonth() {
        return this.localDateTime.getDayOfMonth();
    }

    public DayOfWeek getDayOfWeek() {
        return this.localDateTime.getDayOfWeek();
    }

    public int getHour() {
        return this.localDateTime.getHour();
    }

    public int getMinute() {
        return this.localDateTime.getMinute();
    }

    public int getSecond() {
        return this.localDateTime.getSecond();
    }

    public int getMillis() {
        return this.localDateTime.get(ChronoField.MILLI_OF_SECOND);
    }

    public int getMicros() {
        return this.localDateTime.get(ChronoField.MICRO_OF_SECOND);
    }

    public int getNano() {
        return this.localDateTime.getNano();
    }

    public DateTime<T> round(ChronoUnit chronoUnit, RoundingDT roundingDT) {
        if (this.dateTime instanceof Calendar) {
            return DateTime.from(DateTimeRound.round((Calendar)this.get(), chronoUnit, roundingDT));
        }
        if (this.dateTime instanceof Date) {
            return DateTime.from(DateTimeRound.round((Date)this.get(), chronoUnit, roundingDT));
        }
        return DateTime.from(DateTimeRound.round((Temporal)this.dateTime, this.localDateTime, this.zone, chronoUnit, roundingDT));
    }

    public DateTime<T> roundTime(ChronoUnit chronoUnit, int amountUnit, RoundingDT roundingDT) {
        if (this.dateTime instanceof Calendar) {
            return DateTime.from(DateTimeRound.roundTime((Calendar)this.get(), chronoUnit, amountUnit, roundingDT));
        }
        if (this.dateTime instanceof Date) {
            return DateTime.from(DateTimeRound.roundTime((Date)this.get(), chronoUnit, amountUnit, roundingDT));
        }
        return DateTime.from(DateTimeRound.roundTime((Temporal)this.dateTime, this.localDateTime, this.zone, chronoUnit, amountUnit, roundingDT));
    }

    public List<T> datesByShift(int shiftTimes, int amountUnit, ChronoUnit chronoUnit, boolean includeCurrentTime) {
        if (this.dateTime instanceof Date) {
            return DateTimeShift.datesByShift((Date)this.get(), this.zonedDateTime, shiftTimes, amountUnit, chronoUnit, includeCurrentTime);
        }
        if (this.dateTime instanceof Calendar) {
            return DateTimeShift.datesByShift((Calendar)this.get(), shiftTimes, amountUnit, chronoUnit, includeCurrentTime);
        }
        return DateTimeShift.datesByShift((Temporal)this.dateTime, shiftTimes, amountUnit, chronoUnit, includeCurrentTime);
    }

    public List<T> datesByShift(int shiftTimes, ChronoUnit chronoUnit, boolean includeCurrentTime) {
        return this.datesByShift(shiftTimes, 1, chronoUnit, includeCurrentTime);
    }

    public List<T> datesByShift(int shiftTimes, ChronoUnit chronoUnit) {
        return this.datesByShift(shiftTimes, 1, chronoUnit, true);
    }

    public List<T> datesFromRange(DateTime<?> toDateTime, int amountUnit, ChronoUnit chronoUnit, IntervalType intervalType) {
        Objects.requireNonNull(toDateTime, "Parameter `toDateTime` must be non-null!");
        if (this.dateTime instanceof Date) {
            return DateTimeShift.datesFromRange((Date)this.get(), toDateTime.toDate(), this.zonedDateTime, toDateTime.zonedDateTime, amountUnit, chronoUnit, intervalType);
        }
        if (this.dateTime instanceof Calendar) {
            return DateTimeShift.datesFromRange((Calendar)this.get(), toDateTime.toCalendar(null), amountUnit, chronoUnit, intervalType);
        }
        if (this.dateTime instanceof OffsetDateTime && toDateTime.dateTime instanceof OffsetDateTime) {
            return DateTimeShift.datesFromRange((Temporal)this.dateTime, (Temporal)toDateTime.dateTime, amountUnit, chronoUnit, intervalType);
        }
        return DateTimeShift.datesFromRange((Temporal)this.dateTime, toDateTime.zonedDateTime, amountUnit, chronoUnit, intervalType);
    }

    public List<T> datesFromRange(DateTime<?> toDateTime, ChronoUnit chronoUnit, IntervalType intervalType) {
        return this.datesFromRange(toDateTime, 1, chronoUnit, intervalType);
    }

    public List<T> datesFromRange(DateTime<?> toDateTime, ChronoUnit chronoUnit) {
        return this.datesFromRange(toDateTime, 1, chronoUnit, IntervalType.CLOSED);
    }

    public DateTime<T> fill0(ChronoUnit chronoUnit) {
        return this.round(chronoUnit, RoundingDT.FLOOR);
    }

    public DateTime<T> fill9(ChronoUnit chronoUnit) {
        return ((DateTime)this.round(chronoUnit, RoundingDT.FLOOR).plus(1L, chronoUnit)).minusNanos(1L);
    }

    public int daysOfMonth() {
        return DateTimes.daysOfMonth(this.localDateTime.getYear(), this.localDateTime.getMonthValue());
    }

    public String format(String dtPattern) {
        if (S.isBlank((CharSequence)dtPattern)) {
            dtPattern = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        return this.format(DateTimeFormatter.ofPattern(dtPattern));
    }

    public String format(DateTimeFormatter formatter) {
        if (this.dateTime instanceof LocalDateTime) {
            return this.localDateTime.format(formatter);
        }
        if (this.dateTime instanceof OffsetDateTime) {
            return this.offsetDateTime.format(formatter);
        }
        return this.zonedDateTime.format(formatter);
    }

    public static DateTime<LocalDateTime> parse(CharSequence text) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        String dateFormat = DateTimePattern.forDTF(text.toString());
        if (S.isEmpty((CharSequence)dateFormat)) {
            throw new DateTimeParseException(SI.$((CharSequence)DT_PARSE_ERROR_MSG_TPL, (Object[])new Object[]{text, "DateTime.parse(CharSequence, String)"}), text, 0);
        }
        return DateTime.parse(text, dateFormat);
    }

    public static DateTime<LocalDateTime> parse(CharSequence text, String dtPattern) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        if (S.isEmpty((CharSequence)dtPattern)) {
            return DateTime.parse(text);
        }
        Tuple2<CharSequence, String> text_pattern = DateTime.compatibleFormatter(text, dtPattern);
        text = (CharSequence)text_pattern._1;
        dtPattern = (String)text_pattern._2;
        return DateTime.parse(text, DateTimePattern.getDTF(dtPattern));
    }

    public static DateTime<LocalDateTime> parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        return DateTime.from(LocalDateTime.parse(text, formatter));
    }

    public static DateTime<Date> parseDate(CharSequence text) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        String dateFormat = DateTimePattern.forDTF(text.toString());
        if (S.isEmpty((CharSequence)dateFormat)) {
            throw new DateTimeParseException(SI.$((CharSequence)DT_PARSE_ERROR_MSG_TPL, (Object[])new Object[]{text, "DateTime.parseDate(CharSequence, String)"}), text, 0);
        }
        return DateTime.parseDate(text, dateFormat, TZ.DEFAULT_ZONE);
    }

    public static DateTime<Date> parseDate(CharSequence text, ZoneId zoneId) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        String dateFormat = DateTimePattern.forDTF(text.toString());
        if (S.isEmpty((CharSequence)dateFormat)) {
            throw new DateTimeParseException(SI.$((CharSequence)DT_PARSE_ERROR_MSG_TPL, (Object[])new Object[]{text, "DateTime.parseDate(CharSequence, String, ZoneId)"}), text, 0);
        }
        return DateTime.parseDate(text, dateFormat, zoneId);
    }

    public static DateTime<Date> parseDate(CharSequence text, String dtPattern) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        if (S.isEmpty((CharSequence)dtPattern)) {
            return DateTime.parseDate(text, TZ.DEFAULT_ZONE);
        }
        Tuple2<CharSequence, String> text_pattern = DateTime.compatibleFormatter(text, dtPattern);
        text = (CharSequence)text_pattern._1;
        dtPattern = (String)text_pattern._2;
        return DateTime.parseDate(text, DateTimePattern.getDTF(dtPattern), TZ.DEFAULT_ZONE);
    }

    public static DateTime<Date> parseDate(CharSequence text, String dtPattern, ZoneId zoneId) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        if (S.isEmpty((CharSequence)dtPattern)) {
            return DateTime.parseDate(text, zoneId);
        }
        Tuple2<CharSequence, String> text_pattern = DateTime.compatibleFormatter(text, dtPattern);
        text = (CharSequence)text_pattern._1;
        dtPattern = (String)text_pattern._2;
        return DateTime.parseDate(text, DateTimePattern.getDTF(dtPattern), zoneId);
    }

    public static DateTime<Date> parseDate(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        return DateTime.parseDate(text, formatter, TZ.DEFAULT_ZONE);
    }

    public static DateTime<Date> parseDate(CharSequence text, DateTimeFormatter formatter, ZoneId zoneId) {
        Objects.requireNonNull(text, "Parameter `text` must be non-null!");
        LocalDateTime ldt = LocalDateTime.parse(text, formatter);
        ZonedDateTime zdt = ldt.atZone(zoneId == null ? TZ.DEFAULT_ZONE : zoneId);
        return DateTime.from(Date.from(zdt.toInstant()));
    }

    private static Tuple2<CharSequence, String> compatibleFormatter(CharSequence text, String dtPattern) {
        if (text.length() == 17 && dtPattern.equals("yyyyMMddHHmmssSSS")) {
            String textStr = text.toString();
            text = textStr.substring(0, 8) + "T" + textStr.substring(8);
            dtPattern = "yyyyMMdd'T'HHmmssSSS";
        }
        return Tuple.of((Object)text, (Object)dtPattern);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        OffsetDateTime offsetDateTime = this.toOffsetDT(null);
        OffsetDateTime endOffsetDateTime = DateTime.of(endExclusive).toOffsetDT(offsetDateTime.getOffset());
        return offsetDateTime.until(endOffsetDateTime, unit);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar || this.dateTime instanceof Instant) {
            return this.zonedDateTime.isSupported(unit);
        }
        return ((Temporal)this.dateTime).isSupported(unit);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar || this.dateTime instanceof Instant) {
            return this.zonedDateTime.isSupported(field);
        }
        return ((Temporal)this.dateTime).isSupported(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar || this.dateTime instanceof Instant) {
            return this.zonedDateTime.getLong(field);
        }
        return ((Temporal)this.dateTime).getLong(field);
    }

    public DateTime<T> dtInThisWeek(DayOfWeek dayOfWeek) {
        Objects.requireNonNull(dayOfWeek, "Parameter `dayOfWeek` must be non-null!");
        return this.dtInThisWeek(DayOfWeek.MONDAY, dayOfWeek);
    }

    public DateTime<T> dtInThisWeek(DayOfWeek firstDayOfWeek, DayOfWeek dayOfWeek) {
        if (G.hasNull((Object[])new Object[]{firstDayOfWeek, dayOfWeek})) {
            throw new NullPointerException("Parameters `firstDayOfWeek`, `dayOfWeek` must be non-null!");
        }
        Tuple2<Integer, Integer> days1 = DateTimes.daysBetween(firstDayOfWeek, this.localDateTime.getDayOfWeek());
        Tuple2<Integer, Integer> days2 = DateTimes.daysBetween(firstDayOfWeek, dayOfWeek);
        return this.plusDays((Integer)days2._2 - (Integer)days1._2);
    }

    public DateTime<T> firstInThisWeek() {
        return this.firstInThisWeek(DayOfWeek.MONDAY);
    }

    public DateTime<T> firstInThisWeek(DayOfWeek firstDayOfWeek) {
        Objects.requireNonNull(firstDayOfWeek, "Parameter `firstDayOfWeek` must be non-null!");
        TemporalAdjuster temporalAdjuster = TemporalAdjusters.previousOrSame(firstDayOfWeek);
        return this.with(temporalAdjuster);
    }

    public DateTime<T> lastInThisWeek() {
        return this.lastInThisWeek(DayOfWeek.MONDAY);
    }

    public DateTime<T> lastInThisWeek(DayOfWeek firstDayOfWeek) {
        Objects.requireNonNull(firstDayOfWeek, "Parameter `firstDayOfWeek` must be non-null!");
        DayOfWeek lastDayOfWeek = DateTimes.getLastDayOfWeek(firstDayOfWeek);
        TemporalAdjuster temporalAdjuster = TemporalAdjusters.nextOrSame(lastDayOfWeek);
        return this.with(temporalAdjuster);
    }

    public List<DateTime<T>> allDaysInThisWeek() {
        return this.allDaysInThisWeek(DayOfWeek.MONDAY);
    }

    public List<DateTime<T>> allDaysInThisWeek(DayOfWeek firstDayOfWeek) {
        Objects.requireNonNull(firstDayOfWeek, "Parameter `firstDayOfWeek` must be non-null!");
        DateTime<T> firstDateTime = this.firstInThisWeek(firstDayOfWeek);
        List<T> ts = firstDateTime.datesByShift(6, ChronoUnit.DAYS);
        return ts.stream().map(DateTime::from).collect(Collectors.toList());
    }

    public boolean isBefore(DateTime<?> otherDT) {
        return this.compareTo(otherDT) < 0;
    }

    public boolean isAfter(DateTime<?> otherDT) {
        return this.compareTo(otherDT) > 0;
    }

    public boolean isBeforeOrEquals(DateTime<?> otherDT) {
        return this.compareTo(otherDT) <= 0;
    }

    public boolean isAfterOrEquals(DateTime<?> otherDT) {
        return this.compareTo(otherDT) >= 0;
    }

    public boolean in(DateTime<?> startDT, DateTime<?> endDT, IntervalType intervalType) {
        if (G.hasNull((Object[])new Object[]{startDT, endDT, intervalType})) {
            throw new NullPointerException("Parameters `startDT`, `endDT`, `intervalType` must be non-null!");
        }
        if (startDT.isAfterOrEquals(endDT)) {
            throw new UnexpectedParameterException("Parameter `startDT` must be before `endDT`! ");
        }
        if (intervalType == null) {
            intervalType = IntervalType.CLOSED;
        }
        switch (intervalType) {
            case OPEN: {
                return this.isAfter(startDT) && this.isBefore(endDT);
            }
            case CLOSED: {
                return this.isAfterOrEquals(startDT) && this.isBeforeOrEquals(endDT);
            }
            case OPEN_CLOSED: {
                return this.isAfter(startDT) && this.isBeforeOrEquals(endDT);
            }
        }
        return this.isAfterOrEquals(startDT) && this.isBefore(endDT);
    }

    public long toEpochSecond() {
        return this.instant.getEpochSecond();
    }

    public long toEpochMilli() {
        return this.instant.toEpochMilli();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DateTime) {
            DateTime otherDT = (DateTime)obj;
            int i = this.compareTo(otherDT);
            return i == 0;
        }
        return false;
    }

    @Override
    public int compareTo(DateTime<?> otherDT) {
        Objects.requireNonNull(otherDT, "Parameter `otherDT` must be non-null!");
        Instant otherInstant = otherDT.toInstant();
        if (this.instant.equals(otherInstant)) {
            return 0;
        }
        return this.instant.isBefore(otherInstant) ? -1 : 1;
    }

    public String dtDetail() {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar) {
            return G.dtDetail((Temporal)this.zonedDateTime);
        }
        return G.dtDetail((Temporal)((Temporal)this.dateTime));
    }

    public String toString() {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar) {
            return G.dtSimple((Temporal)this.zonedDateTime);
        }
        return G.dtSimple((Temporal)((Temporal)this.dateTime));
    }
}

