/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.except.OutOfBoundsException;
import com.iofairy.falcon.time.DateTime;
import com.iofairy.falcon.time.DateTimes;
import com.iofairy.falcon.time.RoundingDT;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

class DateTimeRound {
    private static final List<ChronoUnit> SUPPORTED_UNITS_FOR_ROUND = Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS);
    private static final String SUPPORTED_UNITS_FOR_ROUND_STRING = SUPPORTED_UNITS_FOR_ROUND.stream().map(ChronoUnit::toString).collect(Collectors.joining(", "));
    private static final List<ChronoUnit> SUPPORTED_UNITS_FOR_ROUND_TIME = Arrays.asList(ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS);
    private static final String SUPPORTED_UNITS_FOR_ROUND_TIME_STRING = SUPPORTED_UNITS_FOR_ROUND_TIME.stream().map(ChronoUnit::toString).collect(Collectors.joining(", "));

    DateTimeRound() {
    }

    public static LocalDateTime round(LocalDateTime localDateTime, ChronoUnit chronoUnit, RoundingDT roundingDT) {
        if (!SUPPORTED_UNITS_FOR_ROUND.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_ROUND_STRING + "] is supported for `chronoUnit` parameter!");
        }
        roundingDT = roundingDT == null ? RoundingDT.FLOOR : roundingDT;
        LocalDateTime ldt = localDateTime;
        switch (chronoUnit) {
            case YEARS: {
                switch (roundingDT) {
                    case CEILING: {
                        if (ldt.getMonth() == Month.JANUARY && ldt.getDayOfMonth() == 1 && ldt.getHour() == 0 && ldt.getMinute() == 0 && ldt.getSecond() == 0 && ldt.getNano() == 0) break;
                        ldt = ldt.plusYears(1L);
                        break;
                    }
                    case HALF_UP: {
                        if (ldt.getMonthValue() < 7) break;
                        ldt = ldt.plusYears(1L);
                    }
                }
                return LocalDateTime.of(ldt.getYear(), Month.JANUARY, 1, 0, 0, 0, 0);
            }
            case MONTHS: {
                switch (roundingDT) {
                    case CEILING: {
                        if (ldt.getDayOfMonth() == 1 && ldt.getHour() == 0 && ldt.getMinute() == 0 && ldt.getSecond() == 0 && ldt.getNano() == 0) break;
                        ldt = ldt.plusMonths(1L);
                        break;
                    }
                    case HALF_UP: {
                        int dayOfMonth = ldt.getDayOfMonth();
                        int halfUpDay = DateTimeRound.halfUpDay(DateTimes.daysOfMonth(ldt));
                        if (dayOfMonth < halfUpDay) break;
                        ldt = ldt.plusMonths(1L);
                    }
                }
                return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), 1, 0, 0, 0, 0);
            }
            case DAYS: {
                switch (roundingDT) {
                    case CEILING: {
                        if (ldt.getHour() == 0 && ldt.getMinute() == 0 && ldt.getSecond() == 0 && ldt.getNano() == 0) break;
                        ldt = ldt.plusDays(1L);
                        break;
                    }
                    case HALF_UP: {
                        if (ldt.getHour() < 12) break;
                        ldt = ldt.plusDays(1L);
                    }
                }
                return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), 0, 0, 0, 0);
            }
            case HOURS: {
                switch (roundingDT) {
                    case CEILING: {
                        if (ldt.getMinute() == 0 && ldt.getSecond() == 0 && ldt.getNano() == 0) break;
                        ldt = ldt.plusHours(1L);
                        break;
                    }
                    case HALF_UP: {
                        if (ldt.getMinute() < 30) break;
                        ldt = ldt.plusHours(1L);
                    }
                }
                return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), 0, 0, 0);
            }
            case MINUTES: {
                switch (roundingDT) {
                    case CEILING: {
                        if (ldt.getSecond() == 0 && ldt.getNano() == 0) break;
                        ldt = ldt.plusMinutes(1L);
                        break;
                    }
                    case HALF_UP: {
                        if (ldt.getSecond() < 30) break;
                        ldt = ldt.plusMinutes(1L);
                    }
                }
                return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), 0, 0);
            }
        }
        switch (roundingDT) {
            case CEILING: {
                if (ldt.getNano() == 0) break;
                ldt = ldt.plusSeconds(1L);
                break;
            }
            case HALF_UP: {
                if (ldt.getNano() < 500000000) break;
                ldt = ldt.plusSeconds(1L);
            }
        }
        return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), 0);
    }

    public static <T extends Temporal> T round(T temporal, LocalDateTime localDateTime, ZoneId zoneId, ChronoUnit chronoUnit, RoundingDT roundingDT) {
        LocalDateTime ldt = DateTimeRound.round(localDateTime, chronoUnit, roundingDT);
        if (temporal instanceof ZonedDateTime) {
            return (T)ldt.atZone(zoneId);
        }
        if (temporal instanceof OffsetDateTime) {
            return (T)ldt.atOffset((ZoneOffset)zoneId);
        }
        if (temporal instanceof Instant) {
            return (T)ldt.atZone(zoneId).toInstant();
        }
        return (T)ldt;
    }

    public static Date round(Date date, ChronoUnit chronoUnit, RoundingDT roundingDT) {
        return DateTimeRound.round(DateTimes.toCalendar(date, null), chronoUnit, roundingDT).getTime();
    }

    public static Calendar round(Calendar calendar, ChronoUnit chronoUnit, RoundingDT roundingDT) {
        if (!SUPPORTED_UNITS_FOR_ROUND.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_ROUND_STRING + "] is supported for `chronoUnit` parameter!");
        }
        roundingDT = roundingDT == null ? RoundingDT.FLOOR : roundingDT;
        switch (chronoUnit) {
            case YEARS: {
                switch (roundingDT) {
                    case CEILING: {
                        if (calendar.get(2) == 0 && calendar.get(5) == 1 && calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) break;
                        calendar.add(1, 1);
                        break;
                    }
                    case HALF_UP: {
                        if (calendar.get(2) < 6) break;
                        calendar.add(1, 1);
                    }
                }
                calendar.set(calendar.get(1), 0, 1, 0, 0, 0);
                break;
            }
            case MONTHS: {
                switch (roundingDT) {
                    case CEILING: {
                        if (calendar.get(5) == 1 && calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) break;
                        calendar.add(2, 1);
                        break;
                    }
                    case HALF_UP: {
                        int dayOfMonth = calendar.get(5);
                        int halfUpDay = DateTimeRound.halfUpDay(DateTime.from(calendar).daysOfMonth());
                        if (dayOfMonth < halfUpDay) break;
                        calendar.add(2, 1);
                    }
                }
                calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
                break;
            }
            case DAYS: {
                switch (roundingDT) {
                    case CEILING: {
                        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) break;
                        calendar.add(5, 1);
                        break;
                    }
                    case HALF_UP: {
                        if (calendar.get(11) < 12) break;
                        calendar.add(5, 1);
                    }
                }
                calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                break;
            }
            case HOURS: {
                switch (roundingDT) {
                    case CEILING: {
                        if (calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) break;
                        calendar.add(11, 1);
                        break;
                    }
                    case HALF_UP: {
                        if (calendar.get(12) < 30) break;
                        calendar.add(11, 1);
                    }
                }
                calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), 0, 0);
                break;
            }
            case MINUTES: {
                switch (roundingDT) {
                    case CEILING: {
                        if (calendar.get(13) == 0 && calendar.get(14) == 0) break;
                        calendar.add(12, 1);
                        break;
                    }
                    case HALF_UP: {
                        if (calendar.get(13) < 30) break;
                        calendar.add(12, 1);
                    }
                }
                calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), 0);
                break;
            }
            default: {
                switch (roundingDT) {
                    case CEILING: {
                        if (calendar.get(14) == 0) break;
                        calendar.add(13, 1);
                        break;
                    }
                    case HALF_UP: {
                        if (calendar.get(14) < 500) break;
                        calendar.add(13, 1);
                    }
                }
                calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
            }
        }
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar roundTime(Calendar calendar, ChronoUnit chronoUnit, int amountUnit, RoundingDT roundingDT) {
        if (!SUPPORTED_UNITS_FOR_ROUND_TIME.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_ROUND_TIME_STRING + "] is supported for `chronoUnit` parameter!");
        }
        roundingDT = roundingDT == null ? RoundingDT.FLOOR : roundingDT;
        DateTimeRound.checkValidAmountUnit(chronoUnit, amountUnit);
        int newAmountUnit = Math.abs(amountUnit);
        if (newAmountUnit == 0) {
            switch (chronoUnit) {
                case HOURS: {
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    break;
                }
                case MINUTES: {
                    calendar.set(13, 0);
                }
            }
            calendar.set(14, 0);
            return calendar;
        }
        int remainder = 0;
        int halfUpValue = DateTimeRound.halfUp(newAmountUnit);
        int amountToAdd = 0;
        block4 : switch (chronoUnit) {
            case HOURS: {
                int hourOfDay = calendar.get(11);
                remainder = hourOfDay % newAmountUnit;
                amountToAdd = newAmountUnit - remainder;
                if (hourOfDay + amountToAdd > 24) {
                    amountToAdd -= hourOfDay + amountToAdd - 24;
                }
                switch (roundingDT) {
                    case FLOOR: {
                        calendar.add(11, -remainder);
                        break;
                    }
                    case HALF_UP: {
                        if (halfUpValue == -1) {
                            calendar.add(11, -remainder);
                            break;
                        }
                        if (remainder >= halfUpValue) {
                            calendar.add(11, amountToAdd);
                            break;
                        }
                        calendar.add(11, -remainder);
                        break;
                    }
                    default: {
                        if (remainder == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) break;
                        calendar.add(11, amountToAdd);
                    }
                }
                calendar.set(12, 0);
                calendar.set(13, 0);
                break;
            }
            case MINUTES: {
                int minute = calendar.get(12);
                remainder = minute % newAmountUnit;
                amountToAdd = newAmountUnit - remainder;
                if (minute + amountToAdd > 60) {
                    amountToAdd -= minute + amountToAdd - 60;
                }
                switch (roundingDT) {
                    case FLOOR: {
                        calendar.add(12, -remainder);
                        break;
                    }
                    case HALF_UP: {
                        if (halfUpValue == -1) {
                            calendar.add(12, -remainder);
                            break;
                        }
                        if (remainder >= halfUpValue) {
                            calendar.add(12, amountToAdd);
                            break;
                        }
                        calendar.add(12, -remainder);
                        break;
                    }
                    default: {
                        if (remainder == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) break;
                        calendar.add(12, amountToAdd);
                    }
                }
                calendar.set(13, 0);
                break;
            }
            default: {
                int second = calendar.get(13);
                remainder = second % newAmountUnit;
                amountToAdd = newAmountUnit - remainder;
                if (second + amountToAdd > 60) {
                    amountToAdd -= second + amountToAdd - 60;
                }
                switch (roundingDT) {
                    case FLOOR: {
                        calendar.add(13, -remainder);
                        break block4;
                    }
                    case HALF_UP: {
                        if (halfUpValue == -1) {
                            calendar.add(13, -remainder);
                            break block4;
                        }
                        if (remainder >= halfUpValue) {
                            calendar.add(13, amountToAdd);
                            break block4;
                        }
                        calendar.add(13, -remainder);
                        break block4;
                    }
                }
                if (remainder == 0 && calendar.get(14) == 0) break;
                calendar.add(13, amountToAdd);
            }
        }
        calendar.set(14, 0);
        return calendar;
    }

    public static Date roundTime(Date date, ChronoUnit chronoUnit, int amountUnit, RoundingDT roundingDT) {
        return DateTimeRound.roundTime(DateTimes.toCalendar(date, null), chronoUnit, amountUnit, roundingDT).getTime();
    }

    public static LocalDateTime roundTime(LocalDateTime localDateTime, ChronoUnit chronoUnit, int amountUnit, RoundingDT roundingDT) {
        if (!SUPPORTED_UNITS_FOR_ROUND_TIME.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_ROUND_TIME_STRING + "] is supported for `chronoUnit` parameter!");
        }
        roundingDT = roundingDT == null ? RoundingDT.FLOOR : roundingDT;
        DateTimeRound.checkValidAmountUnit(chronoUnit, amountUnit);
        int newAmountUnit = Math.abs(amountUnit);
        LocalDateTime ldt = localDateTime;
        if (newAmountUnit == 0) {
            switch (chronoUnit) {
                case HOURS: {
                    return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), 0, 0, 0);
                }
                case MINUTES: {
                    return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), 0, 0);
                }
            }
            return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), 0);
        }
        int remainder = 0;
        int halfUpValue = DateTimeRound.halfUp(newAmountUnit);
        int amountToAdd = 0;
        switch (chronoUnit) {
            case HOURS: {
                int hourOfDay = ldt.getHour();
                remainder = hourOfDay % newAmountUnit;
                amountToAdd = newAmountUnit - remainder;
                if (hourOfDay + amountToAdd > 24) {
                    amountToAdd -= hourOfDay + amountToAdd - 24;
                }
                switch (roundingDT) {
                    case FLOOR: {
                        ldt = ldt.plusHours(-remainder);
                        break;
                    }
                    case HALF_UP: {
                        if (halfUpValue == -1) {
                            ldt = ldt.plusHours(-remainder);
                            break;
                        }
                        if (remainder >= halfUpValue) {
                            ldt = ldt.plusHours(amountToAdd);
                            break;
                        }
                        ldt = ldt.plusHours(-remainder);
                        break;
                    }
                    default: {
                        if (remainder == 0 && ldt.getMinute() == 0 && ldt.getSecond() == 0 && ldt.getNano() == 0) break;
                        ldt = ldt.plusHours(amountToAdd);
                    }
                }
                return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), 0, 0, 0);
            }
            case MINUTES: {
                int minute = ldt.getMinute();
                remainder = minute % newAmountUnit;
                amountToAdd = newAmountUnit - remainder;
                if (minute + amountToAdd > 60) {
                    amountToAdd -= minute + amountToAdd - 60;
                }
                switch (roundingDT) {
                    case FLOOR: {
                        ldt = ldt.plusMinutes(-remainder);
                        break;
                    }
                    case HALF_UP: {
                        if (halfUpValue == -1) {
                            ldt = ldt.plusMinutes(-remainder);
                            break;
                        }
                        if (remainder >= halfUpValue) {
                            ldt = ldt.plusMinutes(amountToAdd);
                            break;
                        }
                        ldt = ldt.plusMinutes(-remainder);
                        break;
                    }
                    default: {
                        if (remainder == 0 && ldt.getSecond() == 0 && ldt.getNano() == 0) break;
                        ldt = ldt.plusMinutes(amountToAdd);
                    }
                }
                return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), 0, 0);
            }
        }
        int second = ldt.getSecond();
        remainder = second % newAmountUnit;
        amountToAdd = newAmountUnit - remainder;
        if (second + amountToAdd > 60) {
            amountToAdd -= second + amountToAdd - 60;
        }
        switch (roundingDT) {
            case FLOOR: {
                ldt = ldt.plusSeconds(-remainder);
                break;
            }
            case HALF_UP: {
                if (halfUpValue == -1) {
                    ldt = ldt.plusSeconds(-remainder);
                    break;
                }
                if (remainder >= halfUpValue) {
                    ldt = ldt.plusSeconds(amountToAdd);
                    break;
                }
                ldt = ldt.plusSeconds(-remainder);
                break;
            }
            default: {
                if (remainder == 0 && ldt.getNano() == 0) break;
                ldt = ldt.plusSeconds(amountToAdd);
            }
        }
        return LocalDateTime.of(ldt.getYear(), ldt.getMonth(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), 0);
    }

    public static <T extends Temporal> T roundTime(T temporal, LocalDateTime localDateTime, ZoneId zoneId, ChronoUnit chronoUnit, int amountUnit, RoundingDT roundingDT) {
        LocalDateTime ldt = DateTimeRound.roundTime(localDateTime, chronoUnit, amountUnit, roundingDT);
        if (temporal instanceof ZonedDateTime) {
            return (T)ldt.atZone(zoneId);
        }
        if (temporal instanceof OffsetDateTime) {
            return (T)ldt.atOffset((ZoneOffset)zoneId);
        }
        if (temporal instanceof Instant) {
            return (T)ldt.atZone(zoneId).toInstant();
        }
        return (T)ldt;
    }

    private static void checkValidAmountUnit(ChronoUnit chronoUnit, int amountUnit) {
        if (chronoUnit == ChronoUnit.HOURS) {
            if (amountUnit < -24 || amountUnit > 24) {
                throw new OutOfBoundsException((Number)amountUnit, "The `amountUnit`'s range is [-24, 24] when `chronoUnit` is `HOURS`.");
            }
        } else if (amountUnit < -60 || amountUnit > 60) {
            throw new OutOfBoundsException((Number)amountUnit, "The `amountUnit`'s range is [-60, 60] when `chronoUnit` is `MINUTES` or `SECONDS`.");
        }
    }

    private static int halfUpDay(int daysOfMonth) {
        return daysOfMonth == 28 || daysOfMonth == 29 ? 15 : 16;
    }

    private static int halfUp(int value) {
        int quotient = value / 2;
        int remainder = value % 2;
        return value <= 2 ? -1 : (remainder == 0 ? quotient : quotient + 1);
    }
}

