/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.falcon.range.IntervalType;
import com.iofairy.falcon.time.DateTime;
import com.iofairy.falcon.time.DateTimes;
import com.iofairy.falcon.time.SignedInterval;
import com.iofairy.top.G;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class DateTimeShift {
    private static final List<ChronoUnit> SUPPORTED_UNITS_FOR_DBS = Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS);
    private static final String SUPPORTED_UNITS_FOR_DBS_STRING = SUPPORTED_UNITS_FOR_DBS.stream().map(ChronoUnit::toString).collect(Collectors.joining(", "));

    DateTimeShift() {
    }

    public static List<Date> datesByShift(Date fromDate, ZonedDateTime zdt, int shiftTimes, int amountUnit, ChronoUnit chronoUnit, boolean includeCurrentTime) {
        Objects.requireNonNull(chronoUnit, "Parameter `chronoUnit` must be non-null!");
        if (!SUPPORTED_UNITS_FOR_DBS.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_DBS_STRING + "] is supported for `chronoUnit` parameter!");
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        if (includeCurrentTime) {
            dates.add(fromDate);
        }
        if (shiftTimes == 0 || amountUnit == 0) {
            return dates;
        }
        amountUnit = shiftTimes < 0 ? -Math.abs(amountUnit) : Math.abs(amountUnit);
        long abs = Math.abs(shiftTimes);
        for (long i = 0L; i < abs; ++i) {
            zdt = zdt.plus(amountUnit, chronoUnit);
            dates.add(Date.from(zdt.toInstant()));
        }
        if (amountUnit < 0) {
            Collections.reverse(dates);
        }
        return dates;
    }

    public static List<Calendar> datesByShift(Calendar fromCalendar, int shiftTimes, int amountUnit, ChronoUnit chronoUnit, boolean includeCurrentTime) {
        Objects.requireNonNull(chronoUnit, "Parameter `chronoUnit` must be non-null!");
        if (!SUPPORTED_UNITS_FOR_DBS.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_DBS_STRING + "] is supported for `chronoUnit` parameter!");
        }
        Calendar calendar = DateTimes.clone(fromCalendar);
        ArrayList<Calendar> dates = new ArrayList<Calendar>();
        if (includeCurrentTime) {
            dates.add(calendar);
        }
        if (shiftTimes == 0 || amountUnit == 0) {
            return dates;
        }
        amountUnit = shiftTimes < 0 ? -Math.abs(amountUnit) : Math.abs(amountUnit);
        long abs = Math.abs(shiftTimes);
        for (long i = 0L; i < abs; ++i) {
            calendar = DateTimes.clone(calendar);
            DateTimeShift.addAmountToCalendar(calendar, amountUnit, chronoUnit);
            dates.add(calendar);
        }
        if (amountUnit < 0) {
            Collections.reverse(dates);
        }
        return dates;
    }

    public static <T extends Temporal> List<T> datesByShift(T fromTemporal, int shiftTimes, int amountUnit, ChronoUnit chronoUnit, boolean includeCurrentTime) {
        Objects.requireNonNull(chronoUnit, "Parameter `chronoUnit` must be non-null!");
        if (!SUPPORTED_UNITS_FOR_DBS.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_DBS_STRING + "] is supported for `chronoUnit` parameter!");
        }
        ArrayList<Object> dates = new ArrayList<Object>();
        if (includeCurrentTime) {
            dates.add(fromTemporal);
        }
        if (shiftTimes == 0 || amountUnit == 0) {
            return dates;
        }
        amountUnit = shiftTimes < 0 ? -Math.abs(amountUnit) : Math.abs(amountUnit);
        long abs = Math.abs(shiftTimes);
        if (fromTemporal instanceof Instant) {
            ZonedDateTime zdt = DateTime.from(fromTemporal).getZonedDateTime();
            for (long i = 0L; i < abs; ++i) {
                zdt = zdt.plus(amountUnit, chronoUnit);
                dates.add(zdt.toInstant());
            }
        } else {
            for (long i = 0L; i < abs; ++i) {
                fromTemporal = fromTemporal.plus(amountUnit, chronoUnit);
                dates.add(fromTemporal);
            }
        }
        if (amountUnit < 0) {
            Collections.reverse(dates);
        }
        return dates;
    }

    public static List<Date> datesFromRange(Date fromDate, Date toDate, ZonedDateTime fromZdt, ZonedDateTime toZdt, int amountUnit, ChronoUnit chronoUnit, IntervalType intervalType) {
        boolean isExactDivision;
        if (G.hasNull((Object[])new Object[]{toDate, chronoUnit})) {
            throw new NullPointerException("Parameters `toDate`, `chronoUnit` must be non-null!");
        }
        if (!SUPPORTED_UNITS_FOR_DBS.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_DBS_STRING + "] is supported for `chronoUnit` parameter!");
        }
        if (intervalType == null) {
            intervalType = IntervalType.CLOSED;
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        if (intervalType.isLeftClose()) {
            dates.add(fromDate);
        }
        if (amountUnit == 0) {
            return dates;
        }
        SignedInterval signedInterval = SignedInterval.between(fromZdt, toZdt);
        long totalShift = DateTimeShift.getShiftTimes(chronoUnit, signedInterval);
        amountUnit = totalShift < 0L ? -Math.abs(amountUnit) : Math.abs(amountUnit);
        long shiftTimes = totalShift / (long)amountUnit;
        boolean bl = isExactDivision = totalShift % (long)amountUnit == 0L;
        if (shiftTimes == 0L) {
            return dates;
        }
        long maxIndex = Math.abs(shiftTimes) - 1L;
        long i = 0L;
        while (true) {
            fromZdt = fromZdt.plus(amountUnit, chronoUnit);
            if (i == maxIndex) {
                if (isExactDivision) {
                    if (!intervalType.isRightClose()) break;
                    dates.add(Date.from(fromZdt.toInstant()));
                    break;
                }
                dates.add(Date.from(fromZdt.toInstant()));
                break;
            }
            dates.add(Date.from(fromZdt.toInstant()));
            ++i;
        }
        if (amountUnit < 0) {
            Collections.reverse(dates);
        }
        return dates;
    }

    public static List<Calendar> datesFromRange(Calendar fromCalendar, Calendar toCalendar, int amountUnit, ChronoUnit chronoUnit, IntervalType intervalType) {
        boolean isExactDivision;
        if (G.hasNull((Object[])new Object[]{toCalendar, chronoUnit})) {
            throw new NullPointerException("Parameters `toCalendar`, `chronoUnit` must be non-null!");
        }
        if (!SUPPORTED_UNITS_FOR_DBS.contains(chronoUnit)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_DBS_STRING + "] is supported for `chronoUnit` parameter!");
        }
        if (intervalType == null) {
            intervalType = IntervalType.CLOSED;
        }
        Calendar calendar = DateTimes.clone(fromCalendar);
        ArrayList<Calendar> dates = new ArrayList<Calendar>();
        if (intervalType.isLeftClose()) {
            dates.add(fromCalendar);
        }
        if (amountUnit == 0) {
            return dates;
        }
        SignedInterval signedInterval = SignedInterval.between(calendar, toCalendar);
        long totalShift = DateTimeShift.getShiftTimes(chronoUnit, signedInterval);
        amountUnit = totalShift < 0L ? -Math.abs(amountUnit) : Math.abs(amountUnit);
        long shiftTimes = totalShift / (long)amountUnit;
        boolean bl = isExactDivision = totalShift % (long)amountUnit == 0L;
        if (shiftTimes == 0L) {
            return dates;
        }
        long maxIndex = Math.abs(shiftTimes) - 1L;
        long i = 0L;
        while (true) {
            calendar = DateTimes.clone(calendar);
            DateTimeShift.addAmountToCalendar(calendar, amountUnit, chronoUnit);
            if (i == maxIndex) {
                if (isExactDivision) {
                    if (!intervalType.isRightClose()) break;
                    dates.add(calendar);
                    break;
                }
                dates.add(calendar);
                break;
            }
            dates.add(calendar);
            ++i;
        }
        if (amountUnit < 0) {
            Collections.reverse(dates);
        }
        return dates;
    }

    public static <T extends Temporal> List<T> datesFromRange(T fromTemporal, Temporal toTemporal, int amountUnit, ChronoUnit chronoUnit, IntervalType intervalType) {
        ArrayList<Object> dates;
        block16: {
            boolean isExactDivision;
            if (G.hasNull((Object[])new Object[]{toTemporal, chronoUnit})) {
                throw new NullPointerException("Parameters `toTemporal`, `chronoUnit` must be non-null!");
            }
            if (!SUPPORTED_UNITS_FOR_DBS.contains(chronoUnit)) {
                throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_UNITS_FOR_DBS_STRING + "] is supported for `chronoUnit` parameter!");
            }
            if (intervalType == null) {
                intervalType = IntervalType.CLOSED;
            }
            dates = new ArrayList<Object>();
            if (intervalType.isLeftClose()) {
                dates.add(fromTemporal);
            }
            if (amountUnit == 0) {
                return dates;
            }
            SignedInterval signedInterval = SignedInterval.between(fromTemporal, toTemporal);
            long totalShift = DateTimeShift.getShiftTimes(chronoUnit, signedInterval);
            amountUnit = totalShift < 0L ? -Math.abs(amountUnit) : Math.abs(amountUnit);
            long shiftTimes = totalShift / (long)amountUnit;
            boolean bl = isExactDivision = totalShift % (long)amountUnit == 0L;
            if (shiftTimes == 0L) {
                return dates;
            }
            long maxIndex = Math.abs(shiftTimes) - 1L;
            if (fromTemporal instanceof Instant) {
                ZonedDateTime zdt = DateTime.from(fromTemporal).getZonedDateTime();
                long i = 0L;
                while (true) {
                    zdt = zdt.plus(amountUnit, chronoUnit);
                    if (i == maxIndex) {
                        if (isExactDivision) {
                            if (intervalType.isRightClose()) {
                                dates.add(zdt.toInstant());
                            }
                        } else {
                            dates.add(zdt.toInstant());
                        }
                        break block16;
                    }
                    dates.add(zdt.toInstant());
                    ++i;
                }
            }
            long i = 0L;
            while (true) {
                fromTemporal = fromTemporal.plus(amountUnit, chronoUnit);
                if (i == maxIndex) {
                    if (isExactDivision) {
                        if (!intervalType.isRightClose()) break;
                        dates.add(fromTemporal);
                        break;
                    }
                    dates.add(fromTemporal);
                    break;
                }
                dates.add(fromTemporal);
                ++i;
            }
        }
        if (amountUnit < 0) {
            Collections.reverse(dates);
        }
        return dates;
    }

    private static void addAmountToCalendar(Calendar calendar, int amountUnit, ChronoUnit chronoUnit) {
        switch (chronoUnit) {
            case YEARS: {
                calendar.add(1, amountUnit);
                break;
            }
            case MONTHS: {
                calendar.add(2, amountUnit);
                break;
            }
            case DAYS: {
                calendar.add(5, amountUnit);
                break;
            }
            case HOURS: {
                calendar.add(11, amountUnit);
                break;
            }
            case MINUTES: {
                calendar.add(12, amountUnit);
                break;
            }
            default: {
                calendar.add(13, amountUnit);
            }
        }
    }

    private static long getShiftTimes(ChronoUnit chronoUnit, SignedInterval signedInterval) {
        switch (chronoUnit) {
            case YEARS: {
                return signedInterval.toYears();
            }
            case MONTHS: {
                return signedInterval.toMonths();
            }
            case DAYS: {
                return signedInterval.toDays();
            }
            case HOURS: {
                return signedInterval.toHours();
            }
            case MINUTES: {
                return signedInterval.toMinutes();
            }
        }
        return signedInterval.toSeconds();
    }
}

